/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

public abstract class OrderedStack<E> {
    private final Object[] pool;
    private int index;
    private final int size;
    private final Object[] container;

    public OrderedStack(int n, int n2) {
        this.size = n;
        this.pool = new Object[n];
        int n3 = 0;
        while (n3 < n) {
            this.pool[n3] = this.newInstance();
            ++n3;
        }
        this.index = 0;
        this.container = new Object[n2];
    }

    public final E pop() {
        assert (this.index < this.size) : "End of stack reached, there is probably a leak somewhere";
        return (E)this.pool[this.index++];
    }

    public final E[] pop(int n) {
        assert (this.index + n < this.size) : "End of stack reached, there is probably a leak somewhere";
        assert (n <= this.container.length) : "Container array is too small";
        System.arraycopy(this.pool, this.index, this.container, 0, n);
        this.index += n;
        return this.container;
    }

    public final void push(int n) {
        this.index -= n;
        assert (this.index >= 0) : "Beginning of stack reached, push/pops are unmatched";
    }

    protected abstract E newInstance();
}

