/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.narrowphase;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public abstract class TriangleRaycastCallback
implements TriangleCallback {
    public final Vector3f from = new Vector3f();
    public final Vector3f to = new Vector3f();
    public float hitFraction;

    public TriangleRaycastCallback(Vector3f vector3f, Vector3f vector3f2) {
        this.from.set(vector3f);
        this.to.set(vector3f2);
        this.hitFraction = 1.0f;
    }

    @Override
    public void processTriangle(Vector3f[] vector3fArray, int n, int n2) {
        float f;
        float f2;
        Vector3f vector3f;
        Vector3f vector3f2;
        Vector3f vector3f3;
        Vector3f vector3f4;
        Vector3f vector3f5;
        Vector3f vector3f6;
        block9: {
            vector3f6 = vector3fArray[0];
            vector3f5 = vector3fArray[1];
            vector3f4 = vector3fArray[2];
            vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f = (Vector3f)Pools.VECTORS.get();
            try {
                vector3f3.sub(vector3f5, vector3f6);
                vector3f2.sub(vector3f4, vector3f6);
                vector3f.cross(vector3f3, vector3f2);
                float f3 = vector3f6.dot(vector3f);
                f2 = vector3f.dot(this.from);
                f2 -= f3;
                f = vector3f.dot(this.to);
                f -= f3;
                if (!(f2 * f >= 0.0f)) break block9;
            }
            catch (Throwable throwable) {
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5, vector3f4, vector3f3, vector3f2, vector3f});
                throw throwable;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5, vector3f4, vector3f3, vector3f2, vector3f});
            return;
        }
        float f4 = f2 - f;
        float f5 = f2 / f4;
        if (f5 < this.hitFraction) {
            float f6 = vector3f.lengthSquared();
            f6 *= -1.0E-4f;
            Vector3f vector3f7 = new Vector3f();
            VectorUtil.setInterpolate3(vector3f7, this.from, this.to, f5);
            Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
            vector3f8.sub(vector3f6, vector3f7);
            Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
            vector3f9.sub(vector3f5, vector3f7);
            Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
            vector3f10.cross(vector3f8, vector3f9);
            if (vector3f10.dot(vector3f) >= f6) {
                Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
                vector3f11.sub(vector3f4, vector3f7);
                Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
                vector3f12.cross(vector3f9, vector3f11);
                if (vector3f12.dot(vector3f) >= f6) {
                    Vector3f vector3f13 = (Vector3f)Pools.VECTORS.get();
                    vector3f13.cross(vector3f11, vector3f8);
                    if (vector3f13.dot(vector3f) >= f6) {
                        if (f2 > 0.0f) {
                            this.hitFraction = this.reportHit(vector3f, f5, n, n2);
                        } else {
                            Vector3f vector3f14 = (Vector3f)Pools.VECTORS.get();
                            vector3f14.negate(vector3f);
                            this.hitFraction = this.reportHit(vector3f14, f5, n, n2);
                            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f14});
                        }
                    }
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f13});
                }
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f12, vector3f11});
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f8, vector3f9, vector3f10});
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7});
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5, vector3f4, vector3f3, vector3f2, vector3f});
    }

    public abstract float reportHit(Vector3f var1, float var2, int var3, int var4);
}

