/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.extras.gimpact.ClipPolygon;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

class GeometryOperations {
    public static final float PLANEDIREPSILON = 1.0E-7f;
    public static final float PARALELENORMALS = 1.0E-6f;

    GeometryOperations() {
    }

    public static final float CLAMP(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static void edge_plane(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector4f vector4f) {
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(vector3f2, vector3f);
        vector3f4.cross(vector3f4, vector3f3);
        vector3f4.normalize();
        vector4f.set(vector3f4);
        vector4f.w = vector3f2.dot(vector3f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4});
    }

    public static void closest_point_on_segment(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f4, vector3f3);
        vector3f.sub(vector3f2, vector3f3);
        float f = vector3f.dot(vector3f5) / vector3f5.dot(vector3f5);
        if (f < 0.0f) {
            vector3f = vector3f3;
        } else if (f > 1.0f) {
            vector3f = vector3f4;
        } else {
            vector3f.scaleAdd(f, vector3f5, vector3f3);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f5});
    }

    public static int line_plane_collision(Vector4f vector4f, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float[] fArray, float f, float f2) {
        float f3 = VectorUtil.dot3(vector3f, vector4f);
        if (Math.abs(f3) < 1.0E-7f) {
            fArray[0] = f2;
            return 0;
        }
        float f4 = ClipPolygon.distance_point_plane(vector4f, vector3f2);
        int n = f4 < 0.0f ? 2 : 1;
        fArray[0] = -f4 / f3;
        if (fArray[0] < f) {
            n = 0;
            fArray[0] = f;
        } else if (fArray[0] > f2) {
            n = 0;
            fArray[0] = f2;
        }
        vector3f3.scaleAdd(fArray[0], vector3f, vector3f2);
        return n;
    }

    public static void segment_collision(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, Vector3f vector3f6) {
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        vector3f7.sub(vector3f2, vector3f);
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        vector3f8.sub(vector3f4, vector3f3);
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        vector3f9.cross(vector3f7, vector3f8);
        float[] fArray = new float[]{vector3f9.lengthSquared()};
        Vector4f vector4f = (Vector4f)Pools.VECTORS4.get();
        if (fArray[0] < 1.1920929E-7f) {
            boolean bl = false;
            vector4f.x = vector3f3.dot(vector3f7);
            vector4f.y = vector3f4.dot(vector3f7);
            if (vector4f.x > vector4f.y) {
                bl = true;
                vector4f.x += vector4f.y;
                vector4f.y = vector4f.x - vector4f.y;
                vector4f.x -= vector4f.y;
            }
            vector4f.z = vector3f.dot(vector3f7);
            vector4f.w = vector3f2.dot(vector3f7);
            vector3f9.x = (vector4f.x + vector4f.y) * 0.5f;
            vector3f9.y = (vector4f.z + vector4f.w) * 0.5f;
            if (vector3f9.x < vector3f9.y) {
                if (vector4f.y < vector4f.z) {
                    vector3f6 = bl ? vector3f3 : vector3f4;
                    vector3f5 = vector3f;
                } else if (vector4f.y < vector4f.w) {
                    vector3f6 = bl ? vector3f3 : vector3f4;
                    GeometryOperations.closest_point_on_segment(vector3f5, vector3f6, vector3f, vector3f2);
                } else {
                    vector3f5 = vector3f2;
                    GeometryOperations.closest_point_on_segment(vector3f6, vector3f5, vector3f3, vector3f4);
                }
            } else if (vector4f.w < vector4f.x) {
                vector3f6 = bl ? vector3f4 : vector3f3;
                vector3f5 = vector3f2;
            } else if (vector4f.w < vector4f.y) {
                vector3f5 = vector3f2;
                GeometryOperations.closest_point_on_segment(vector3f6, vector3f5, vector3f3, vector3f4);
            } else {
                vector3f6 = bl ? vector3f3 : vector3f4;
                GeometryOperations.closest_point_on_segment(vector3f5, vector3f6, vector3f, vector3f2);
            }
            return;
        }
        vector3f9.cross(vector3f9, vector3f8);
        vector4f.set(vector3f9.x, vector3f9.y, vector3f9.z, vector3f3.dot(vector3f9));
        GeometryOperations.line_plane_collision(vector4f, vector3f7, vector3f, vector3f5, fArray, 0.0f, 1.0f);
        vector3f6.sub(vector3f5, vector3f3);
        fArray[0] = vector3f6.dot(vector3f8);
        fArray[0] = fArray[0] / vector3f8.dot(vector3f8);
        fArray[0] = GeometryOperations.CLAMP(fArray[0], 0.0f, 1.0f);
        vector3f6.scaleAdd(fArray[0], vector3f8, vector3f3);
        Pools.VECTORS4.release((Object[])new Vector4f[]{vector4f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f8, vector3f9});
    }
}

