/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.broadphase;

import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.broadphase.BroadPhaseStrategy;
import org.jbox2d.collision.broadphase.DynamicTreeNode;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;

public class DynamicTree
implements BroadPhaseStrategy {
    public static final int MAX_STACK_SIZE = 64;
    public static final int NULL_NODE = -1;
    private DynamicTreeNode m_root = null;
    private DynamicTreeNode[] m_nodes;
    private int m_nodeCount = 0;
    private int m_nodeCapacity = 16;
    private int m_freeList;
    private final Vec2[] drawVecs = new Vec2[4];
    private DynamicTreeNode[] nodeStack = new DynamicTreeNode[20];
    private int nodeStackIndex = 0;
    private final Vec2 r = new Vec2();
    private final AABB aabb = new AABB();
    private final RayCastInput subInput = new RayCastInput();
    private final AABB combinedAABB = new AABB();
    private final Color3f color = new Color3f();
    private final Vec2 textVec = new Vec2();

    public DynamicTree() {
        this.m_nodes = new DynamicTreeNode[16];
        int n = this.m_nodeCapacity - 1;
        while (n >= 0) {
            this.m_nodes[n] = new DynamicTreeNode(n);
            this.m_nodes[n].parent = n == this.m_nodeCapacity - 1 ? null : this.m_nodes[n + 1];
            this.m_nodes[n].height = -1;
            --n;
        }
        this.m_freeList = 0;
        n = 0;
        while (n < this.drawVecs.length) {
            this.drawVecs[n] = new Vec2();
            ++n;
        }
    }

    @Override
    public final int createProxy(AABB aABB, Object object) {
        assert (aABB.isValid());
        DynamicTreeNode dynamicTreeNode = this.allocateNode();
        int n = dynamicTreeNode.id;
        AABB aABB2 = dynamicTreeNode.aabb;
        aABB2.lowerBound.x = aABB.lowerBound.x - Settings.aabbExtension;
        aABB2.lowerBound.y = aABB.lowerBound.y - Settings.aabbExtension;
        aABB2.upperBound.x = aABB.upperBound.x + Settings.aabbExtension;
        aABB2.upperBound.y = aABB.upperBound.y + Settings.aabbExtension;
        dynamicTreeNode.userData = object;
        this.insertLeaf(n);
        return n;
    }

    @Override
    public final void destroyProxy(int n) {
        assert (n >= 0 && n < this.m_nodeCapacity);
        DynamicTreeNode dynamicTreeNode = this.m_nodes[n];
        assert (dynamicTreeNode.child1 == null);
        this.removeLeaf(dynamicTreeNode);
        this.freeNode(dynamicTreeNode);
    }

    @Override
    public final boolean moveProxy(int n, AABB aABB, Vec2 vec2) {
        assert (aABB.isValid());
        assert (n >= 0 && n < this.m_nodeCapacity);
        DynamicTreeNode dynamicTreeNode = this.m_nodes[n];
        assert (dynamicTreeNode.child1 == null);
        AABB aABB2 = dynamicTreeNode.aabb;
        if (aABB2.lowerBound.x <= aABB.lowerBound.x && aABB2.lowerBound.y <= aABB.lowerBound.y && aABB.upperBound.x <= aABB2.upperBound.x && aABB.upperBound.y <= aABB2.upperBound.y) {
            return false;
        }
        this.removeLeaf(dynamicTreeNode);
        Vec2 vec22 = aABB2.lowerBound;
        Vec2 vec23 = aABB2.upperBound;
        vec22.x = aABB.lowerBound.x - Settings.aabbExtension;
        vec22.y = aABB.lowerBound.y - Settings.aabbExtension;
        vec23.x = aABB.upperBound.x + Settings.aabbExtension;
        vec23.y = aABB.upperBound.y + Settings.aabbExtension;
        float f = vec2.x * Settings.aabbMultiplier;
        float f2 = vec2.y * Settings.aabbMultiplier;
        if (f < 0.0f) {
            vec22.x += f;
        } else {
            vec23.x += f;
        }
        if (f2 < 0.0f) {
            vec22.y += f2;
        } else {
            vec23.y += f2;
        }
        this.insertLeaf(n);
        return true;
    }

    @Override
    public final Object getUserData(int n) {
        assert (n >= 0 && n < this.m_nodeCapacity);
        return this.m_nodes[n].userData;
    }

    @Override
    public final AABB getFatAABB(int n) {
        assert (n >= 0 && n < this.m_nodeCapacity);
        return this.m_nodes[n].aabb;
    }

    @Override
    public final void query(TreeCallback treeCallback, AABB aABB) {
        assert (aABB.isValid());
        this.nodeStackIndex = 0;
        this.nodeStack[this.nodeStackIndex++] = this.m_root;
        while (this.nodeStackIndex > 0) {
            DynamicTreeNode dynamicTreeNode;
            if ((dynamicTreeNode = this.nodeStack[--this.nodeStackIndex]) == null || !AABB.testOverlap(dynamicTreeNode.aabb, aABB)) continue;
            if (dynamicTreeNode.child1 == null) {
                boolean bl = treeCallback.treeCallback(dynamicTreeNode.id);
                if (bl) continue;
                return;
            }
            if (this.nodeStack.length - this.nodeStackIndex - 2 <= 0) {
                DynamicTreeNode[] dynamicTreeNodeArray = new DynamicTreeNode[this.nodeStack.length * 2];
                System.arraycopy(this.nodeStack, 0, dynamicTreeNodeArray, 0, this.nodeStack.length);
                this.nodeStack = dynamicTreeNodeArray;
            }
            this.nodeStack[this.nodeStackIndex++] = dynamicTreeNode.child1;
            this.nodeStack[this.nodeStackIndex++] = dynamicTreeNode.child2;
        }
    }

    @Override
    public void raycast(TreeRayCastCallback treeRayCastCallback, RayCastInput rayCastInput) {
        Vec2 vec2 = rayCastInput.p1;
        Vec2 vec22 = rayCastInput.p2;
        float f = vec2.x;
        float f2 = vec22.x;
        float f3 = vec2.y;
        float f4 = vec22.y;
        this.r.x = f2 - f;
        this.r.y = f4 - f3;
        assert (this.r.x * this.r.x + this.r.y * this.r.y > 0.0f);
        this.r.normalize();
        float f5 = this.r.x;
        float f6 = this.r.y;
        float f7 = -1.0f * f6;
        float f8 = 1.0f * f5;
        float f9 = MathUtils.abs(f7);
        float f10 = MathUtils.abs(f8);
        float f11 = rayCastInput.maxFraction;
        AABB aABB = this.aabb;
        float f12 = (f2 - f) * f11 + f;
        float f13 = (f4 - f3) * f11 + f3;
        aABB.lowerBound.x = f < f12 ? f : f12;
        aABB.lowerBound.y = f3 < f13 ? f3 : f13;
        aABB.upperBound.x = f > f12 ? f : f12;
        aABB.upperBound.y = f3 > f13 ? f3 : f13;
        this.nodeStackIndex = 0;
        this.nodeStack[this.nodeStackIndex++] = this.m_root;
        while (this.nodeStackIndex > 0) {
            AABB aABB2;
            DynamicTreeNode dynamicTreeNode;
            if ((dynamicTreeNode = this.nodeStack[--this.nodeStackIndex]) == null || !AABB.testOverlap(aABB2 = dynamicTreeNode.aabb, aABB)) continue;
            float f14 = (aABB2.lowerBound.x + aABB2.upperBound.x) * 0.5f;
            float f15 = (aABB2.lowerBound.y + aABB2.upperBound.y) * 0.5f;
            float f16 = (aABB2.upperBound.x - aABB2.lowerBound.x) * 0.5f;
            float f17 = (aABB2.upperBound.y - aABB2.lowerBound.y) * 0.5f;
            f12 = f - f14;
            f13 = f3 - f15;
            float f18 = MathUtils.abs(f7 * f12 + f8 * f13) - (f9 * f16 + f10 * f17);
            if (f18 > 0.0f) continue;
            if (dynamicTreeNode.child1 == null) {
                this.subInput.p1.x = f;
                this.subInput.p1.y = f3;
                this.subInput.p2.x = f2;
                this.subInput.p2.y = f4;
                this.subInput.maxFraction = f11;
                float f19 = treeRayCastCallback.raycastCallback(this.subInput, dynamicTreeNode.id);
                if (f19 == 0.0f) {
                    return;
                }
                if (!(f19 > 0.0f)) continue;
                f11 = f19;
                f12 = (f2 - f) * f11 + f;
                f13 = (f4 - f3) * f11 + f3;
                aABB.lowerBound.x = f < f12 ? f : f12;
                aABB.lowerBound.y = f3 < f13 ? f3 : f13;
                aABB.upperBound.x = f > f12 ? f : f12;
                aABB.upperBound.y = f3 > f13 ? f3 : f13;
                continue;
            }
            if (this.nodeStack.length - this.nodeStackIndex - 2 <= 0) {
                DynamicTreeNode[] dynamicTreeNodeArray = new DynamicTreeNode[this.nodeStack.length * 2];
                System.arraycopy(this.nodeStack, 0, dynamicTreeNodeArray, 0, this.nodeStack.length);
                this.nodeStack = dynamicTreeNodeArray;
            }
            this.nodeStack[this.nodeStackIndex++] = dynamicTreeNode.child1;
            this.nodeStack[this.nodeStackIndex++] = dynamicTreeNode.child2;
        }
    }

    @Override
    public final int computeHeight() {
        return this.computeHeight(this.m_root);
    }

    private final int computeHeight(DynamicTreeNode dynamicTreeNode) {
        assert (dynamicTreeNode.id >= 0 && dynamicTreeNode.id < this.m_nodeCapacity);
        if (dynamicTreeNode.child1 == null) {
            return 0;
        }
        int n = this.computeHeight(dynamicTreeNode.child1);
        int n2 = this.computeHeight(dynamicTreeNode.child2);
        return 1 + MathUtils.max(n, n2);
    }

    public void validate() {
        this.validateStructure(this.m_root);
        this.validateMetrics(this.m_root);
        int n = 0;
        DynamicTreeNode dynamicTreeNode = this.m_freeList != -1 ? this.m_nodes[this.m_freeList] : null;
        while (dynamicTreeNode != null) {
            assert (dynamicTreeNode.id >= 0 && dynamicTreeNode.id < this.m_nodeCapacity);
            assert (dynamicTreeNode == this.m_nodes[dynamicTreeNode.id]);
            dynamicTreeNode = dynamicTreeNode.parent;
            ++n;
        }
        assert (this.getHeight() == this.computeHeight());
        assert (this.m_nodeCount + n == this.m_nodeCapacity);
    }

    @Override
    public int getHeight() {
        if (this.m_root == null) {
            return 0;
        }
        return this.m_root.height;
    }

    @Override
    public int getMaxBalance() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_nodeCapacity) {
            DynamicTreeNode dynamicTreeNode = this.m_nodes[n2];
            if (dynamicTreeNode.height > 1) {
                assert (dynamicTreeNode.child1 != null);
                DynamicTreeNode dynamicTreeNode2 = dynamicTreeNode.child1;
                DynamicTreeNode dynamicTreeNode3 = dynamicTreeNode.child2;
                int n3 = MathUtils.abs(dynamicTreeNode3.height - dynamicTreeNode2.height);
                n = MathUtils.max(n, n3);
            }
            ++n2;
        }
        return n;
    }

    @Override
    public float getAreaRatio() {
        if (this.m_root == null) {
            return 0.0f;
        }
        DynamicTreeNode dynamicTreeNode = this.m_root;
        float f = dynamicTreeNode.aabb.getPerimeter();
        float f2 = 0.0f;
        int n = 0;
        while (n < this.m_nodeCapacity) {
            DynamicTreeNode dynamicTreeNode2 = this.m_nodes[n];
            if (dynamicTreeNode2.height >= 0) {
                f2 += dynamicTreeNode2.aabb.getPerimeter();
            }
            ++n;
        }
        return f2 / f;
    }

    public void rebuildBottomUp() {
        int[] nArray = new int[this.m_nodeCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_nodeCapacity) {
            if (this.m_nodes[n2].height >= 0) {
                DynamicTreeNode dynamicTreeNode = this.m_nodes[n2];
                if (dynamicTreeNode.child1 == null) {
                    dynamicTreeNode.parent = null;
                    nArray[n] = n2;
                    ++n;
                } else {
                    this.freeNode(dynamicTreeNode);
                }
            }
            ++n2;
        }
        AABB aABB = new AABB();
        while (n > 1) {
            Object object;
            float f = Float.MAX_VALUE;
            int n3 = -1;
            int n4 = -1;
            int n5 = 0;
            while (n5 < n) {
                AABB aABB2 = this.m_nodes[nArray[n5]].aabb;
                int n6 = n5 + 1;
                while (n6 < n) {
                    object = this.m_nodes[nArray[n6]].aabb;
                    aABB.combine(aABB2, (AABB)object);
                    float f2 = aABB.getPerimeter();
                    if (f2 < f) {
                        n3 = n5;
                        n4 = n6;
                        f = f2;
                    }
                    ++n6;
                }
                ++n5;
            }
            n5 = nArray[n3];
            int n7 = nArray[n4];
            DynamicTreeNode dynamicTreeNode = this.m_nodes[n5];
            object = this.m_nodes[n7];
            DynamicTreeNode dynamicTreeNode2 = this.allocateNode();
            dynamicTreeNode2.child1 = dynamicTreeNode;
            dynamicTreeNode2.child2 = object;
            dynamicTreeNode2.height = 1 + MathUtils.max(dynamicTreeNode.height, ((DynamicTreeNode)object).height);
            dynamicTreeNode2.aabb.combine(dynamicTreeNode.aabb, ((DynamicTreeNode)object).aabb);
            dynamicTreeNode2.parent = null;
            dynamicTreeNode.parent = dynamicTreeNode2;
            ((DynamicTreeNode)object).parent = dynamicTreeNode2;
            nArray[n4] = nArray[n - 1];
            nArray[n3] = dynamicTreeNode2.id;
            --n;
        }
        this.m_root = this.m_nodes[nArray[0]];
        this.validate();
    }

    private final DynamicTreeNode allocateNode() {
        if (this.m_freeList == -1) {
            assert (this.m_nodeCount == this.m_nodeCapacity);
            DynamicTreeNode[] dynamicTreeNodeArray = this.m_nodes;
            this.m_nodeCapacity *= 2;
            this.m_nodes = new DynamicTreeNode[this.m_nodeCapacity];
            System.arraycopy(dynamicTreeNodeArray, 0, this.m_nodes, 0, dynamicTreeNodeArray.length);
            int n = this.m_nodeCapacity - 1;
            while (n >= this.m_nodeCount) {
                this.m_nodes[n] = new DynamicTreeNode(n);
                this.m_nodes[n].parent = n == this.m_nodeCapacity - 1 ? null : this.m_nodes[n + 1];
                this.m_nodes[n].height = -1;
                --n;
            }
            this.m_freeList = this.m_nodeCount;
        }
        int n = this.m_freeList;
        DynamicTreeNode dynamicTreeNode = this.m_nodes[n];
        this.m_freeList = dynamicTreeNode.parent != null ? dynamicTreeNode.parent.id : -1;
        dynamicTreeNode.parent = null;
        dynamicTreeNode.child1 = null;
        dynamicTreeNode.child2 = null;
        dynamicTreeNode.height = 0;
        dynamicTreeNode.userData = null;
        ++this.m_nodeCount;
        return dynamicTreeNode;
    }

    private final void freeNode(DynamicTreeNode dynamicTreeNode) {
        assert (dynamicTreeNode != null);
        assert (this.m_nodeCount > 0);
        dynamicTreeNode.parent = this.m_freeList != -1 ? this.m_nodes[this.m_freeList] : null;
        dynamicTreeNode.height = -1;
        this.m_freeList = dynamicTreeNode.id;
        --this.m_nodeCount;
    }

    private final void insertLeaf(int n) {
        DynamicTreeNode dynamicTreeNode;
        DynamicTreeNode dynamicTreeNode2;
        DynamicTreeNode dynamicTreeNode3;
        DynamicTreeNode dynamicTreeNode4 = this.m_nodes[n];
        if (this.m_root == null) {
            this.m_root = dynamicTreeNode4;
            this.m_root.parent = null;
            return;
        }
        AABB aABB = dynamicTreeNode4.aabb;
        DynamicTreeNode dynamicTreeNode5 = this.m_root;
        while (dynamicTreeNode5.child1 != null) {
            float f;
            float f2;
            float f3;
            dynamicTreeNode3 = dynamicTreeNode5;
            dynamicTreeNode2 = dynamicTreeNode3.child1;
            dynamicTreeNode = dynamicTreeNode3.child2;
            float f4 = dynamicTreeNode3.aabb.getPerimeter();
            this.combinedAABB.combine(dynamicTreeNode3.aabb, aABB);
            float f5 = this.combinedAABB.getPerimeter();
            float f6 = 2.0f * f5;
            float f7 = 2.0f * (f5 - f4);
            if (dynamicTreeNode2.child1 == null) {
                this.combinedAABB.combine(aABB, dynamicTreeNode2.aabb);
                f3 = this.combinedAABB.getPerimeter() + f7;
            } else {
                this.combinedAABB.combine(aABB, dynamicTreeNode2.aabb);
                f2 = dynamicTreeNode2.aabb.getPerimeter();
                f = this.combinedAABB.getPerimeter();
                f3 = f - f2 + f7;
            }
            if (dynamicTreeNode.child1 == null) {
                this.combinedAABB.combine(aABB, dynamicTreeNode.aabb);
                f2 = this.combinedAABB.getPerimeter() + f7;
            } else {
                this.combinedAABB.combine(aABB, dynamicTreeNode.aabb);
                f = dynamicTreeNode.aabb.getPerimeter();
                float f8 = this.combinedAABB.getPerimeter();
                f2 = f8 - f + f7;
            }
            if (f6 < f3 && f6 < f2) break;
            dynamicTreeNode5 = f3 < f2 ? dynamicTreeNode2 : dynamicTreeNode;
        }
        dynamicTreeNode3 = dynamicTreeNode5;
        dynamicTreeNode2 = this.m_nodes[dynamicTreeNode3.id].parent;
        dynamicTreeNode = this.allocateNode();
        dynamicTreeNode.parent = dynamicTreeNode2;
        dynamicTreeNode.userData = null;
        dynamicTreeNode.aabb.combine(aABB, dynamicTreeNode3.aabb);
        dynamicTreeNode.height = dynamicTreeNode3.height + 1;
        if (dynamicTreeNode2 != null) {
            if (dynamicTreeNode2.child1 == dynamicTreeNode3) {
                dynamicTreeNode2.child1 = dynamicTreeNode;
            } else {
                dynamicTreeNode2.child2 = dynamicTreeNode;
            }
            dynamicTreeNode.child1 = dynamicTreeNode3;
            dynamicTreeNode.child2 = dynamicTreeNode4;
            dynamicTreeNode3.parent = dynamicTreeNode;
            dynamicTreeNode4.parent = dynamicTreeNode;
        } else {
            dynamicTreeNode.child1 = dynamicTreeNode3;
            dynamicTreeNode.child2 = dynamicTreeNode4;
            dynamicTreeNode3.parent = dynamicTreeNode;
            dynamicTreeNode4.parent = dynamicTreeNode;
            this.m_root = dynamicTreeNode;
        }
        dynamicTreeNode5 = dynamicTreeNode4.parent;
        while (dynamicTreeNode5 != null) {
            dynamicTreeNode5 = this.balance(dynamicTreeNode5);
            DynamicTreeNode dynamicTreeNode6 = dynamicTreeNode5.child1;
            DynamicTreeNode dynamicTreeNode7 = dynamicTreeNode5.child2;
            assert (dynamicTreeNode6 != null);
            assert (dynamicTreeNode7 != null);
            dynamicTreeNode5.height = 1 + MathUtils.max(dynamicTreeNode6.height, dynamicTreeNode7.height);
            dynamicTreeNode5.aabb.combine(dynamicTreeNode6.aabb, dynamicTreeNode7.aabb);
            dynamicTreeNode5 = dynamicTreeNode5.parent;
        }
    }

    private final void removeLeaf(DynamicTreeNode dynamicTreeNode) {
        if (dynamicTreeNode == this.m_root) {
            this.m_root = null;
            return;
        }
        DynamicTreeNode dynamicTreeNode2 = dynamicTreeNode.parent;
        DynamicTreeNode dynamicTreeNode3 = dynamicTreeNode2.parent;
        DynamicTreeNode dynamicTreeNode4 = dynamicTreeNode2.child1 == dynamicTreeNode ? dynamicTreeNode2.child2 : dynamicTreeNode2.child1;
        if (dynamicTreeNode3 != null) {
            if (dynamicTreeNode3.child1 == dynamicTreeNode2) {
                dynamicTreeNode3.child1 = dynamicTreeNode4;
            } else {
                dynamicTreeNode3.child2 = dynamicTreeNode4;
            }
            dynamicTreeNode4.parent = dynamicTreeNode3;
            this.freeNode(dynamicTreeNode2);
            DynamicTreeNode dynamicTreeNode5 = dynamicTreeNode3;
            while (dynamicTreeNode5 != null) {
                dynamicTreeNode5 = this.balance(dynamicTreeNode5);
                DynamicTreeNode dynamicTreeNode6 = dynamicTreeNode5.child1;
                DynamicTreeNode dynamicTreeNode7 = dynamicTreeNode5.child2;
                dynamicTreeNode5.aabb.combine(dynamicTreeNode6.aabb, dynamicTreeNode7.aabb);
                dynamicTreeNode5.height = 1 + MathUtils.max(dynamicTreeNode6.height, dynamicTreeNode7.height);
                dynamicTreeNode5 = dynamicTreeNode5.parent;
            }
        } else {
            this.m_root = dynamicTreeNode4;
            dynamicTreeNode4.parent = null;
            this.freeNode(dynamicTreeNode2);
        }
    }

    private DynamicTreeNode balance(DynamicTreeNode dynamicTreeNode) {
        assert (dynamicTreeNode != null);
        DynamicTreeNode dynamicTreeNode2 = dynamicTreeNode;
        if (dynamicTreeNode2.child1 == null || dynamicTreeNode2.height < 2) {
            return dynamicTreeNode;
        }
        DynamicTreeNode dynamicTreeNode3 = dynamicTreeNode2.child1;
        DynamicTreeNode dynamicTreeNode4 = dynamicTreeNode2.child2;
        assert (dynamicTreeNode3.id >= 0 && dynamicTreeNode3.id < this.m_nodeCapacity);
        assert (dynamicTreeNode4.id >= 0 && dynamicTreeNode4.id < this.m_nodeCapacity);
        DynamicTreeNode dynamicTreeNode5 = dynamicTreeNode3;
        DynamicTreeNode dynamicTreeNode6 = dynamicTreeNode4;
        int n = dynamicTreeNode6.height - dynamicTreeNode5.height;
        if (n > 1) {
            DynamicTreeNode dynamicTreeNode7 = dynamicTreeNode6.child1;
            DynamicTreeNode dynamicTreeNode8 = dynamicTreeNode6.child2;
            DynamicTreeNode dynamicTreeNode9 = dynamicTreeNode7;
            DynamicTreeNode dynamicTreeNode10 = dynamicTreeNode8;
            assert (dynamicTreeNode9 != null);
            assert (dynamicTreeNode10 != null);
            assert (dynamicTreeNode7.id >= 0 && dynamicTreeNode7.id < this.m_nodeCapacity);
            assert (dynamicTreeNode8.id >= 0 && dynamicTreeNode8.id < this.m_nodeCapacity);
            dynamicTreeNode6.child1 = dynamicTreeNode;
            dynamicTreeNode6.parent = dynamicTreeNode2.parent;
            dynamicTreeNode2.parent = dynamicTreeNode4;
            if (dynamicTreeNode6.parent != null) {
                if (dynamicTreeNode6.parent.child1 == dynamicTreeNode) {
                    dynamicTreeNode6.parent.child1 = dynamicTreeNode4;
                } else {
                    assert (dynamicTreeNode6.parent.child2 == dynamicTreeNode);
                    dynamicTreeNode6.parent.child2 = dynamicTreeNode4;
                }
            } else {
                this.m_root = dynamicTreeNode4;
            }
            if (dynamicTreeNode9.height > dynamicTreeNode10.height) {
                dynamicTreeNode6.child2 = dynamicTreeNode7;
                dynamicTreeNode2.child2 = dynamicTreeNode8;
                dynamicTreeNode10.parent = dynamicTreeNode;
                dynamicTreeNode2.aabb.combine(dynamicTreeNode5.aabb, dynamicTreeNode10.aabb);
                dynamicTreeNode6.aabb.combine(dynamicTreeNode2.aabb, dynamicTreeNode9.aabb);
                dynamicTreeNode2.height = 1 + MathUtils.max(dynamicTreeNode5.height, dynamicTreeNode10.height);
                dynamicTreeNode6.height = 1 + MathUtils.max(dynamicTreeNode2.height, dynamicTreeNode9.height);
            } else {
                dynamicTreeNode6.child2 = dynamicTreeNode8;
                dynamicTreeNode2.child2 = dynamicTreeNode7;
                dynamicTreeNode9.parent = dynamicTreeNode;
                dynamicTreeNode2.aabb.combine(dynamicTreeNode5.aabb, dynamicTreeNode9.aabb);
                dynamicTreeNode6.aabb.combine(dynamicTreeNode2.aabb, dynamicTreeNode10.aabb);
                dynamicTreeNode2.height = 1 + MathUtils.max(dynamicTreeNode5.height, dynamicTreeNode9.height);
                dynamicTreeNode6.height = 1 + MathUtils.max(dynamicTreeNode2.height, dynamicTreeNode10.height);
            }
            return dynamicTreeNode4;
        }
        if (n < -1) {
            DynamicTreeNode dynamicTreeNode11 = dynamicTreeNode5.child1;
            DynamicTreeNode dynamicTreeNode12 = dynamicTreeNode5.child2;
            DynamicTreeNode dynamicTreeNode13 = dynamicTreeNode11;
            DynamicTreeNode dynamicTreeNode14 = dynamicTreeNode12;
            assert (dynamicTreeNode11.id >= 0 && dynamicTreeNode11.id < this.m_nodeCapacity);
            assert (dynamicTreeNode12.id >= 0 && dynamicTreeNode12.id < this.m_nodeCapacity);
            dynamicTreeNode5.child1 = dynamicTreeNode;
            dynamicTreeNode5.parent = dynamicTreeNode2.parent;
            dynamicTreeNode2.parent = dynamicTreeNode3;
            if (dynamicTreeNode5.parent != null) {
                if (dynamicTreeNode5.parent.child1 == dynamicTreeNode) {
                    dynamicTreeNode5.parent.child1 = dynamicTreeNode3;
                } else {
                    assert (dynamicTreeNode5.parent.child2 == dynamicTreeNode);
                    dynamicTreeNode5.parent.child2 = dynamicTreeNode3;
                }
            } else {
                this.m_root = dynamicTreeNode3;
            }
            if (dynamicTreeNode13.height > dynamicTreeNode14.height) {
                dynamicTreeNode5.child2 = dynamicTreeNode11;
                dynamicTreeNode2.child1 = dynamicTreeNode12;
                dynamicTreeNode14.parent = dynamicTreeNode;
                dynamicTreeNode2.aabb.combine(dynamicTreeNode6.aabb, dynamicTreeNode14.aabb);
                dynamicTreeNode5.aabb.combine(dynamicTreeNode2.aabb, dynamicTreeNode13.aabb);
                dynamicTreeNode2.height = 1 + MathUtils.max(dynamicTreeNode6.height, dynamicTreeNode14.height);
                dynamicTreeNode5.height = 1 + MathUtils.max(dynamicTreeNode2.height, dynamicTreeNode13.height);
            } else {
                dynamicTreeNode5.child2 = dynamicTreeNode12;
                dynamicTreeNode2.child1 = dynamicTreeNode11;
                dynamicTreeNode13.parent = dynamicTreeNode;
                dynamicTreeNode2.aabb.combine(dynamicTreeNode6.aabb, dynamicTreeNode13.aabb);
                dynamicTreeNode5.aabb.combine(dynamicTreeNode2.aabb, dynamicTreeNode14.aabb);
                dynamicTreeNode2.height = 1 + MathUtils.max(dynamicTreeNode6.height, dynamicTreeNode13.height);
                dynamicTreeNode5.height = 1 + MathUtils.max(dynamicTreeNode2.height, dynamicTreeNode14.height);
            }
            return dynamicTreeNode3;
        }
        return dynamicTreeNode;
    }

    private void validateStructure(DynamicTreeNode dynamicTreeNode) {
        if (dynamicTreeNode == null) {
            return;
        }
        assert (dynamicTreeNode == this.m_nodes[dynamicTreeNode.id]);
        if (dynamicTreeNode == this.m_root) assert (dynamicTreeNode.parent == null);
        DynamicTreeNode dynamicTreeNode2 = dynamicTreeNode.child1;
        DynamicTreeNode dynamicTreeNode3 = dynamicTreeNode.child2;
        if (dynamicTreeNode.child1 == null) {
            assert (dynamicTreeNode2 == null);
            assert (dynamicTreeNode3 == null);
            assert (dynamicTreeNode.height == 0);
            return;
        }
        assert (dynamicTreeNode2 != null && dynamicTreeNode2.id >= 0 && dynamicTreeNode2.id < this.m_nodeCapacity);
        assert (dynamicTreeNode3 != null && dynamicTreeNode3.id >= 0 && dynamicTreeNode3.id < this.m_nodeCapacity);
        assert (dynamicTreeNode2.parent == dynamicTreeNode);
        assert (dynamicTreeNode3.parent == dynamicTreeNode);
        this.validateStructure(dynamicTreeNode2);
        this.validateStructure(dynamicTreeNode3);
    }

    private void validateMetrics(DynamicTreeNode dynamicTreeNode) {
        if (dynamicTreeNode == null) {
            return;
        }
        DynamicTreeNode dynamicTreeNode2 = dynamicTreeNode.child1;
        DynamicTreeNode dynamicTreeNode3 = dynamicTreeNode.child2;
        if (dynamicTreeNode.child1 == null) {
            assert (dynamicTreeNode2 == null);
            assert (dynamicTreeNode3 == null);
            assert (dynamicTreeNode.height == 0);
            return;
        }
        assert (dynamicTreeNode2 != null && dynamicTreeNode2.id >= 0 && dynamicTreeNode2.id < this.m_nodeCapacity);
        assert (dynamicTreeNode3 != null && dynamicTreeNode3.id >= 0 && dynamicTreeNode3.id < this.m_nodeCapacity);
        int n = dynamicTreeNode2.height;
        int n2 = dynamicTreeNode3.height;
        int n3 = 1 + MathUtils.max(n, n2);
        assert (dynamicTreeNode.height == n3);
        AABB aABB = new AABB();
        aABB.combine(dynamicTreeNode2.aabb, dynamicTreeNode3.aabb);
        assert (aABB.lowerBound.equals(dynamicTreeNode.aabb.lowerBound));
        assert (aABB.upperBound.equals(dynamicTreeNode.aabb.upperBound));
        this.validateMetrics(dynamicTreeNode2);
        this.validateMetrics(dynamicTreeNode3);
    }

    @Override
    public void drawTree(DebugDraw debugDraw) {
        if (this.m_root == null) {
            return;
        }
        int n = this.computeHeight();
        this.drawTree(debugDraw, this.m_root, 0, n);
    }

    public void drawTree(DebugDraw debugDraw, DynamicTreeNode dynamicTreeNode, int n, int n2) {
        dynamicTreeNode.aabb.getVertices(this.drawVecs);
        this.color.set(1.0f, (float)(n2 - n) * 1.0f / (float)n2, (float)(n2 - n) * 1.0f / (float)n2);
        debugDraw.drawPolygon(this.drawVecs, 4, this.color);
        debugDraw.getViewportTranform().getWorldToScreen(dynamicTreeNode.aabb.upperBound, this.textVec);
        debugDraw.drawString(this.textVec.x, this.textVec.y, dynamicTreeNode.id + "-" + (n + 1) + "/" + n2, this.color);
        if (dynamicTreeNode.child1 != null) {
            this.drawTree(debugDraw, dynamicTreeNode.child1, n + 1, n2);
        }
        if (dynamicTreeNode.child2 != null) {
            this.drawTree(debugDraw, dynamicTreeNode.child2, n + 1, n2);
        }
    }
}

