/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.dispatch.CollisionObjectType;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public class CollisionObject {
    public static final int ACTIVE_TAG = 1;
    public static final int ISLAND_SLEEPING = 2;
    public static final int WANTS_DEACTIVATION = 3;
    public static final int DISABLE_DEACTIVATION = 4;
    public static final int DISABLE_SIMULATION = 5;
    protected Transform worldTransform = new Transform();
    protected final Transform interpolationWorldTransform = new Transform();
    protected final Vector3f interpolationLinearVelocity = new Vector3f();
    protected final Vector3f interpolationAngularVelocity = new Vector3f();
    protected BroadphaseProxy broadphaseHandle;
    protected CollisionShape collisionShape;
    protected CollisionShape rootCollisionShape;
    protected int collisionFlags = 1;
    protected int islandTag1 = -1;
    protected int companionId = -1;
    protected int activationState1 = 1;
    protected float deactivationTime;
    protected float friction = 0.5f;
    protected float restitution;
    protected Object userObjectPointer;
    protected CollisionObjectType internalType = CollisionObjectType.COLLISION_OBJECT;
    protected float hitFraction = 1.0f;
    protected float ccdSweptSphereRadius;
    protected float ccdMotionThreshold = 0.0f;
    protected boolean checkCollideWith;

    public boolean checkCollideWithOverride(CollisionObject collisionObject) {
        return true;
    }

    public boolean mergesSimulationIslands() {
        return (this.collisionFlags & 7) == 0;
    }

    public boolean isStaticObject() {
        return (this.collisionFlags & 1) != 0;
    }

    public boolean isKinematicObject() {
        return (this.collisionFlags & 2) != 0;
    }

    public boolean isStaticOrKinematicObject() {
        return (this.collisionFlags & 3) != 0;
    }

    public boolean hasContactResponse() {
        return (this.collisionFlags & 4) == 0;
    }

    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public void setCollisionShape(CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
        this.rootCollisionShape = collisionShape;
    }

    public CollisionShape getRootCollisionShape() {
        return this.rootCollisionShape;
    }

    public void internalSetTemporaryCollisionShape(CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
    }

    public int getActivationState() {
        return this.activationState1;
    }

    public void setActivationState(int n) {
        if (this.activationState1 != 4 && this.activationState1 != 5) {
            this.activationState1 = n;
        }
    }

    public float getDeactivationTime() {
        return this.deactivationTime;
    }

    public void setDeactivationTime(float f) {
        this.deactivationTime = f;
    }

    public void forceActivationState(int n) {
        this.activationState1 = n;
    }

    public void activate() {
        this.activate(false);
    }

    public void activate(boolean bl) {
        if (bl || (this.collisionFlags & 3) == 0) {
            this.setActivationState(1);
            this.deactivationTime = 0.0f;
        }
    }

    public boolean isActive() {
        return this.getActivationState() != 2 && this.getActivationState() != 5;
    }

    public float getRestitution() {
        return this.restitution;
    }

    public void setRestitution(float f) {
        this.restitution = f;
    }

    public float getFriction() {
        return this.friction;
    }

    public void setFriction(float f) {
        this.friction = f;
    }

    public CollisionObjectType getInternalType() {
        return this.internalType;
    }

    public Transform getWorldTransform(Transform transform) {
        transform.set(this.worldTransform);
        return transform;
    }

    public void setWorldTransform(Transform transform) {
        this.worldTransform.set(transform);
    }

    public BroadphaseProxy getBroadphaseHandle() {
        return this.broadphaseHandle;
    }

    public void setBroadphaseHandle(BroadphaseProxy broadphaseProxy) {
        this.broadphaseHandle = broadphaseProxy;
    }

    public Transform getInterpolationWorldTransform(Transform transform) {
        transform.set(this.interpolationWorldTransform);
        return transform;
    }

    public void setInterpolationWorldTransform(Transform transform) {
        this.interpolationWorldTransform.set(transform);
    }

    public void setInterpolationLinearVelocity(Vector3f vector3f) {
        this.interpolationLinearVelocity.set(vector3f);
    }

    public void setInterpolationAngularVelocity(Vector3f vector3f) {
        this.interpolationAngularVelocity.set(vector3f);
    }

    public Vector3f getInterpolationLinearVelocity(Vector3f vector3f) {
        vector3f.set(this.interpolationLinearVelocity);
        return vector3f;
    }

    public Vector3f getInterpolationAngularVelocity(Vector3f vector3f) {
        vector3f.set(this.interpolationAngularVelocity);
        return vector3f;
    }

    public int getIslandTag() {
        return this.islandTag1;
    }

    public void setIslandTag(int n) {
        this.islandTag1 = n;
    }

    public int getCompanionId() {
        return this.companionId;
    }

    public void setCompanionId(int n) {
        this.companionId = n;
    }

    public float getHitFraction() {
        return this.hitFraction;
    }

    public void setHitFraction(float f) {
        this.hitFraction = f;
    }

    public int getCollisionFlags() {
        return this.collisionFlags;
    }

    public void setCollisionFlags(int n) {
        this.collisionFlags = n;
    }

    public float getCcdSweptSphereRadius() {
        return this.ccdSweptSphereRadius;
    }

    public void setCcdSweptSphereRadius(float f) {
        this.ccdSweptSphereRadius = f;
    }

    public float getCcdMotionThreshold() {
        return this.ccdMotionThreshold;
    }

    public float getCcdSquareMotionThreshold() {
        return this.ccdMotionThreshold * this.ccdMotionThreshold;
    }

    public void setCcdMotionThreshold(float f) {
        this.ccdMotionThreshold = f;
    }

    public Object getUserPointer() {
        return this.userObjectPointer;
    }

    public void setUserPointer(Object object) {
        this.userObjectPointer = object;
    }

    public boolean checkCollideWith(CollisionObject collisionObject) {
        if (this.checkCollideWith) {
            return this.checkCollideWithOverride(collisionObject);
        }
        return true;
    }
}

