/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public class CylinderShape
extends BoxShape {
    protected int upAxis;

    public CylinderShape(Vector3f vector3f) {
        super(vector3f);
        this.upAxis = 1;
        this.recalcLocalAabb();
    }

    protected CylinderShape(Vector3f vector3f, boolean bl) {
        super(vector3f);
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        this._PolyhedralConvexShape_getAabb(transform, vector3f, vector3f2);
    }

    protected Vector3f cylinderLocalSupportX(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        return this.cylinderLocalSupport(vector3f, vector3f2, 0, 1, 0, 2, vector3f3);
    }

    protected Vector3f cylinderLocalSupportY(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        return this.cylinderLocalSupport(vector3f, vector3f2, 1, 0, 1, 2, vector3f3);
    }

    protected Vector3f cylinderLocalSupportZ(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        return this.cylinderLocalSupport(vector3f, vector3f2, 2, 0, 2, 1, vector3f3);
    }

    private Vector3f cylinderLocalSupport(Vector3f vector3f, Vector3f vector3f2, int n, int n2, int n3, int n4, Vector3f vector3f3) {
        float f = VectorUtil.getCoord(vector3f, n2);
        float f2 = VectorUtil.getCoord(vector3f, n);
        float f3 = (float)Math.sqrt(VectorUtil.getCoord(vector3f2, n2) * VectorUtil.getCoord(vector3f2, n2) + VectorUtil.getCoord(vector3f2, n4) * VectorUtil.getCoord(vector3f2, n4));
        if (f3 != 0.0f) {
            float f4 = f / f3;
            VectorUtil.setCoord(vector3f3, n2, VectorUtil.getCoord(vector3f2, n2) * f4);
            VectorUtil.setCoord(vector3f3, n3, VectorUtil.getCoord(vector3f2, n3) < 0.0f ? -f2 : f2);
            VectorUtil.setCoord(vector3f3, n4, VectorUtil.getCoord(vector3f2, n4) * f4);
            return vector3f3;
        }
        VectorUtil.setCoord(vector3f3, n2, f);
        VectorUtil.setCoord(vector3f3, n3, VectorUtil.getCoord(vector3f2, n3) < 0.0f ? -f2 : f2);
        VectorUtil.setCoord(vector3f3, n4, 0.0f);
        return vector3f3;
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = this.getHalfExtentsWithoutMargin((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f4 = this.cylinderLocalSupportY(vector3f3, vector3f, vector3f2);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
        return vector3f4;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            Vector3f vector3f = this.getHalfExtentsWithoutMargin((Vector3f)Pools.VECTORS.get());
            this.cylinderLocalSupportY(vector3f, vector3fArray[n2], vector3fArray2[n2]);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
            ++n2;
        }
    }

    @Override
    public Vector3f localGetSupportingVertex(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = vector3f2;
        this.localGetSupportingVertexWithoutMargin(vector3f, vector3f3);
        if (this.getMargin() != 0.0f) {
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            if (vector3f4.lengthSquared() < 1.4210855E-14f) {
                vector3f4.set(-1.0f, -1.0f, -1.0f);
            }
            vector3f4.normalize();
            vector3f3.scaleAdd(this.getMargin(), vector3f4, vector3f3);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4});
        }
        return vector3f2;
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.CYLINDER_SHAPE_PROXYTYPE;
    }

    public int getUpAxis() {
        return this.upAxis;
    }

    public float getRadius() {
        Vector3f vector3f = this.getHalfExtentsWithMargin((Vector3f)Pools.VECTORS.get());
        float f = vector3f.x;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        return f;
    }

    @Override
    public String getName() {
        return "CylinderY";
    }
}

