/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.PolyhedralConvexShape;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public class TriangleShape
extends PolyhedralConvexShape {
    public final Vector3f[] vertices1 = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};

    public TriangleShape() {
    }

    public TriangleShape(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.vertices1[0].set(vector3f);
        this.vertices1[1].set(vector3f2);
        this.vertices1[2].set(vector3f3);
    }

    public void init(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.vertices1[0].set(vector3f);
        this.vertices1[1].set(vector3f2);
        this.vertices1[2].set(vector3f3);
    }

    @Override
    public int getNumVertices() {
        return 3;
    }

    public Vector3f getVertexPtr(int n) {
        return this.vertices1[n];
    }

    @Override
    public void getVertex(int n, Vector3f vector3f) {
        vector3f.set(this.vertices1[n]);
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.TRIANGLE_SHAPE_PROXYTYPE;
    }

    @Override
    public int getNumEdges() {
        return 3;
    }

    @Override
    public void getEdge(int n, Vector3f vector3f, Vector3f vector3f2) {
        this.getVertex(n, vector3f);
        this.getVertex((n + 1) % 3, vector3f2);
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        this.getAabbSlow(transform, vector3f, vector3f2);
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.set(vector3f.dot(this.vertices1[0]), vector3f.dot(this.vertices1[1]), vector3f.dot(this.vertices1[2]));
        vector3f2.set(this.vertices1[VectorUtil.maxAxis(vector3f3)]);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
        return vector3f2;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        int n2 = 0;
        while (n2 < n) {
            Vector3f vector3f2 = vector3fArray[n2];
            vector3f.set(vector3f2.dot(this.vertices1[0]), vector3f2.dot(this.vertices1[1]), vector3f2.dot(this.vertices1[2]));
            vector3fArray2[n2].set(this.vertices1[VectorUtil.maxAxis(vector3f)]);
            ++n2;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }

    @Override
    public void getPlane(Vector3f vector3f, Vector3f vector3f2, int n) {
        this.getPlaneEquation(n, vector3f, vector3f2);
    }

    @Override
    public int getNumPlanes() {
        return 1;
    }

    public void calcNormal(Vector3f vector3f) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f2.sub(this.vertices1[1], this.vertices1[0]);
        vector3f3.sub(this.vertices1[2], this.vertices1[0]);
        vector3f.cross(vector3f2, vector3f3);
        vector3f.normalize();
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3});
    }

    public void getPlaneEquation(int n, Vector3f vector3f, Vector3f vector3f2) {
        this.calcNormal(vector3f);
        vector3f2.set(this.vertices1[0]);
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        assert (false);
        vector3f.set(0.0f, 0.0f, 0.0f);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isInside(Vector3f var1_1, float var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getName() {
        return "Triangle";
    }

    @Override
    public int getNumPreferredPenetrationDirections() {
        return 2;
    }

    @Override
    public void getPreferredPenetrationDirection(int n, Vector3f vector3f) {
        this.calcNormal(vector3f);
        if (n != 0) {
            vector3f.scale(-1.0f);
        }
    }
}

