/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import com.bulletphysics.Pools;
import com.bulletphysics.linearmath.VectorUtil;
import com.bulletphysics.util.ObjectArrayList;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class GeometryUtil {
    public static boolean isPointInsidePlanes(ObjectArrayList<Vector4f> objectArrayList, Vector3f vector3f, float f) {
        int n = objectArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Vector4f vector4f = objectArrayList.getQuick(n2);
            float f2 = VectorUtil.dot3(vector4f, vector3f) + vector4f.w - f;
            if (f2 > 0.0f) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean areVerticesBehindPlane(Vector4f vector4f, ObjectArrayList<Vector3f> objectArrayList, float f) {
        int n = objectArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Vector3f vector3f = objectArrayList.getQuick(n2);
            float f2 = VectorUtil.dot3(vector4f, vector3f) + vector4f.w - f;
            if (f2 > 0.0f) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean notExist(Vector4f vector4f, ObjectArrayList<Vector4f> objectArrayList) {
        int n = objectArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Vector4f vector4f2 = objectArrayList.getQuick(n2);
            if (VectorUtil.dot3(vector4f, vector4f2) > 0.999f) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void getPlaneEquationsFromVertices(ObjectArrayList<Vector3f> objectArrayList, ObjectArrayList<Vector4f> objectArrayList2) {
        Vector4f vector4f = (Vector4f)Pools.VECTORS4.get();
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        int n = objectArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Vector3f vector3f4 = objectArrayList.getQuick(n2);
            int n3 = n2 + 1;
            while (n3 < n) {
                Vector3f vector3f5 = objectArrayList.getQuick(n3);
                int n4 = n3 + 1;
                while (n4 < n) {
                    Vector3f vector3f6 = objectArrayList.getQuick(n4);
                    vector3f.sub(vector3f5, vector3f4);
                    vector3f2.sub(vector3f6, vector3f4);
                    float f = 1.0f;
                    int n5 = 0;
                    while (n5 < 2) {
                        vector3f3.cross(vector3f, vector3f2);
                        vector4f.x = f * vector3f3.x;
                        vector4f.y = f * vector3f3.y;
                        vector4f.z = f * vector3f3.z;
                        if (VectorUtil.lengthSquared3(vector4f) > 1.0E-4f) {
                            VectorUtil.normalize3(vector4f);
                            if (GeometryUtil.notExist(vector4f, objectArrayList2)) {
                                vector4f.w = -VectorUtil.dot3(vector4f, vector3f4);
                                if (GeometryUtil.areVerticesBehindPlane(vector4f, objectArrayList, 0.01f)) {
                                    objectArrayList2.add(new Vector4f(vector4f));
                                }
                            }
                        }
                        f = -1.0f;
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        Pools.VECTORS4.release((Object[])new Vector4f[]{vector4f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f, vector3f2});
    }

    public static void getVerticesFromPlaneEquations(ObjectArrayList<Vector4f> objectArrayList, ObjectArrayList<Vector3f> objectArrayList2) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        int n = objectArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Vector4f vector4f = objectArrayList.getQuick(n2);
            int n3 = n2 + 1;
            while (n3 < n) {
                Vector4f vector4f2 = objectArrayList.getQuick(n3);
                int n4 = n3 + 1;
                while (n4 < n) {
                    float f;
                    Vector4f vector4f3 = objectArrayList.getQuick(n4);
                    VectorUtil.cross3(vector3f, vector4f2, vector4f3);
                    VectorUtil.cross3(vector3f2, vector4f3, vector4f);
                    VectorUtil.cross3(vector3f3, vector4f, vector4f2);
                    if (vector3f.lengthSquared() > 1.0E-4f && vector3f2.lengthSquared() > 1.0E-4f && vector3f3.lengthSquared() > 1.0E-4f && Math.abs(f = VectorUtil.dot3(vector4f, vector3f)) > 1.0E-6f) {
                        f = -1.0f / f;
                        vector3f.scale(vector4f.w);
                        vector3f2.scale(vector4f2.w);
                        vector3f3.scale(vector4f3.w);
                        vector3f4.set(vector3f);
                        vector3f4.add(vector3f2);
                        vector3f4.add(vector3f3);
                        vector3f4.scale(f);
                        if (GeometryUtil.isPointInsidePlanes(objectArrayList, vector3f4, 0.01f)) {
                            objectArrayList2.add(new Vector3f(vector3f4));
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, vector3f4});
    }
}

