/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.util.FSTIdentity2IdMap;
import org.nustaq.serialization.util.FSTObject2IntMap;
import org.nustaq.serialization.util.FSTUtil;

public class FSTClazzNameRegistry {
    public static final int LOWEST_CLZ_ID = 3;
    public static final int FIRST_USER_CLZ_ID = 1000;
    FSTIdentity2IdMap clzToId;
    FSTClazzInfo[] idToClz;
    FSTClazzNameRegistry parent;
    int classIdCount = 3;
    HashMap<String, Class> classCache = new HashMap(200);
    AtomicBoolean classCacheLock = new AtomicBoolean(false);

    public FSTClazzNameRegistry(FSTClazzNameRegistry fSTClazzNameRegistry) {
        this.parent = fSTClazzNameRegistry;
        if (this.parent != null) {
            this.classIdCount = Math.max(1000, this.parent.classIdCount + 1);
            this.clzToId = new FSTIdentity2IdMap(13);
            this.idToClz = new FSTClazzInfo[31];
        } else {
            this.clzToId = new FSTIdentity2IdMap(FSTObject2IntMap.adjustSize(400));
            this.idToClz = new FSTClazzInfo[200];
        }
    }

    public void clear() {
        if (this.clzToId.size() > 0) {
            this.clzToId.clear();
        }
        this.classIdCount = 3;
        if (this.parent != null) {
            this.classIdCount = Math.max(1000, this.parent.classIdCount + 1);
        }
    }

    public void registerClass(Class clazz, FSTConfiguration fSTConfiguration) {
        if (this.getIdFromClazz(clazz) != Integer.MIN_VALUE) {
            return;
        }
        this.registerClassNoLookup(clazz, null, fSTConfiguration);
    }

    private void registerClassNoLookup(Class clazz, FSTClazzInfo fSTClazzInfo, FSTConfiguration fSTConfiguration) {
        this.addClassMapping(clazz, this.classIdCount++, fSTClazzInfo, fSTConfiguration);
    }

    public void registerClass(Class clazz, int n, FSTConfiguration fSTConfiguration) {
        if (this.getIdFromClazz(clazz) != Integer.MIN_VALUE) {
            return;
        }
        this.addClassMapping(clazz, n, null, fSTConfiguration);
    }

    protected void addClassMapping(Class clazz, int n, FSTClazzInfo fSTClazzInfo, FSTConfiguration fSTConfiguration) {
        this.clzToId.put(clazz, n);
        if (fSTClazzInfo == null) {
            fSTClazzInfo = fSTConfiguration.getCLInfoRegistry().getCLInfo(clazz, fSTConfiguration);
        }
        if (this.idToClz.length <= n) {
            FSTClazzInfo[] fSTClazzInfoArray = new FSTClazzInfo[n + 100];
            System.arraycopy(this.idToClz, 0, fSTClazzInfoArray, 0, this.idToClz.length);
            this.idToClz = fSTClazzInfoArray;
        }
        this.idToClz[n] = fSTClazzInfo;
        if (this.parent == null) {
            fSTClazzInfo.setClzId(n);
        }
    }

    public int getIdFromClazz(Class clazz) {
        int n = Integer.MIN_VALUE;
        if (this.parent != null) {
            n = this.parent.getIdFromClazz(clazz);
        }
        if (n == Integer.MIN_VALUE) {
            n = this.clzToId.get(clazz);
        }
        return n;
    }

    public void encodeClass(FSTEncoder fSTEncoder, FSTClazzInfo fSTClazzInfo) throws IOException {
        int n = fSTClazzInfo.getClzId();
        if (n >= 0) {
            fSTEncoder.writeFShort((short)n);
        } else if (fSTClazzInfo.isAsciiNameShortString) {
            Class clazz = fSTClazzInfo.getClazz();
            int n2 = this.getIdFromClazz(clazz);
            if (n2 != Integer.MIN_VALUE) {
                fSTEncoder.writeFShort((short)n2);
            } else {
                byte[] byArray = fSTClazzInfo.getBufferedName();
                fSTEncoder.writeFShort((short)1);
                fSTEncoder.writeFInt((char)byArray.length);
                fSTEncoder.writeRawBytes(byArray, 0, byArray.length);
                this.registerClassNoLookup(clazz, fSTClazzInfo, fSTClazzInfo.conf);
            }
        } else {
            this.encodeClass(fSTEncoder, fSTClazzInfo.getClazz());
        }
    }

    public void encodeClass(FSTEncoder fSTEncoder, Class clazz) throws IOException {
        int n = this.getIdFromClazz(clazz);
        if (n != Integer.MIN_VALUE) {
            fSTEncoder.writeFShort((short)n);
        } else {
            this.encodeClassName(fSTEncoder, clazz, fSTEncoder.getConf());
        }
    }

    private void encodeClassName(FSTEncoder fSTEncoder, Class clazz, FSTConfiguration fSTConfiguration) throws IOException {
        fSTEncoder.writeFShort((short)0);
        fSTEncoder.writeStringUTF(clazz.getName());
        this.registerClassNoLookup(clazz, null, fSTConfiguration);
    }

    public FSTClazzInfo decodeClass(FSTDecoder fSTDecoder, FSTConfiguration fSTConfiguration) throws IOException, ClassNotFoundException {
        short s = fSTDecoder.readFShort();
        if (s < 3) {
            String string = s == 0 ? fSTDecoder.readStringUTF() : fSTDecoder.readStringAsc();
            Class clazz = this.classForName(string, fSTConfiguration);
            FSTClazzInfo fSTClazzInfo = fSTConfiguration.getCLInfoRegistry().getCLInfo(clazz, fSTConfiguration);
            this.registerClassNoLookup(clazz, fSTClazzInfo, fSTConfiguration);
            return fSTClazzInfo;
        }
        FSTClazzInfo fSTClazzInfo = this.getClazzFromId(s);
        if (fSTClazzInfo == null) {
            throw new RuntimeException("unable to find class for code " + s);
        }
        return fSTClazzInfo;
    }

    public Class classForName(String string, FSTConfiguration fSTConfiguration) throws ClassNotFoundException {
        if (this.parent != null) {
            return this.parent.classForName(string, fSTConfiguration);
        }
        try {
            while (!this.classCacheLock.compareAndSet(false, true)) {
            }
            Class<?> clazz = this.classCache.get(string);
            if (clazz == null) {
                try {
                    clazz = Class.forName(string, false, fSTConfiguration.getClassLoader());
                }
                catch (Throwable throwable) {
                    if (!string.endsWith("_ActorProxy")) {
                        throw new RuntimeException("class not found CLASSNAME:" + string + " loader:" + String.valueOf(fSTConfiguration.getClassLoader()), throwable);
                    }
                    Class<?> clazz2 = this.classCache.get(string = string.substring(0, string.length() - "_ActorProxy".length()));
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName(string, false, fSTConfiguration.getClassLoader());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            FSTUtil.rethrow(classNotFoundException);
                        }
                    }
                    Class<?> clazz3 = clazz2;
                    this.classCacheLock.set(false);
                    return clazz3;
                }
                if (clazz != null) {
                    this.classCache.put(string, clazz);
                }
            }
            Class<?> clazz4 = clazz;
            return clazz4;
        }
        finally {
            this.classCacheLock.set(false);
        }
    }

    public void registerClazzFromOtherLoader(Class clazz) {
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        this.classCache.put(clazz.getName(), clazz);
        this.classCacheLock.set(false);
    }

    public FSTClazzInfo getClazzFromId(int n) {
        FSTClazzInfo fSTClazzInfo = null;
        if (this.parent != null) {
            fSTClazzInfo = this.parent.getClazzFromId(n);
        }
        if (fSTClazzInfo != null) {
            return fSTClazzInfo;
        }
        if (n < 0 || n >= this.idToClz.length) {
            return null;
        }
        return this.idToClz[n];
    }
}

