/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.serialize.binary;

import gama.core.common.geometry.GamaCoordinateSequenceFactory;
import gama.core.common.geometry.GamaGeometryFactory;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.interfaces.ISerialisationConstants;
import gama.core.metamodel.agent.AgentReference;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.SerialisedAgent;
import gama.core.metamodel.population.SerialisedGrid;
import gama.core.metamodel.population.SerialisedPopulation;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.grid.IGrid;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaFont;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class BinarySerialiser
implements ISerialisationConstants {
    FSTConfiguration fst = this.initConfiguration(FSTConfiguration.createDefaultConfiguration());
    boolean inAgent;
    IScope scope;

    public void restoreAgentFromBytes(IAgent iAgent, byte[] byArray) {
        this.scope = iAgent.getScope();
        try {
            try {
                SerialisedAgent serialisedAgent = (SerialisedAgent)this.fst.asObject(byArray);
                serialisedAgent.restoreAs(this.scope, iAgent);
            }
            catch (Exception exception) {
                throw GamaRuntimeException.create((Throwable)exception, (IScope)this.scope);
            }
        }
        finally {
            this.scope = null;
        }
    }

    public byte[] saveObjectToBytes(IScope iScope, Object object) {
        Object object2;
        this.inAgent = false;
        if (object instanceof IAgent) {
            IAgent iAgent = (IAgent)object;
            object2 = SerialisedAgent.of((IAgent)iAgent, (boolean)true);
        } else {
            object2 = object;
        }
        return this.fst.asByteArray(object2);
    }

    public Object createObjectFromBytes(IScope iScope, byte[] byArray) {
        try {
            this.scope = iScope;
            Object object = this.fst.asObject(byArray);
            if (object instanceof SerialisedAgent) {
                SerialisedAgent serialisedAgent = (SerialisedAgent)object;
                IAgent iAgent = serialisedAgent.recreateIn(this.scope);
                return iAgent;
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create((Throwable)exception, (IScope)this.scope);
        }
        finally {
            this.scope = null;
        }
    }

    protected void registerSerialisers(FSTConfiguration fSTConfiguration) {
        this.register(fSTConfiguration, GamaShape.class, new FSTIndividualSerialiser<GamaShape>(this){

            @Override
            protected boolean shouldRegister() {
                return false;
            }

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, GamaShape gamaShape) throws Exception {
                Double d = gamaShape.getDepth();
                IShape.Type type = gamaShape.getGeometricalType();
                fSTObjectOutput.writeDouble(d == null ? 0.0 : d);
                fSTObjectOutput.writeInt(type.ordinal());
                fSTObjectOutput.writeObject(gamaShape.getInnerGeometry());
            }

            @Override
            public GamaShape deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                double d = fSTObjectInput.readDouble();
                IShape.Type type = IShape.Type.values()[fSTObjectInput.readInt()];
                GamaShape gamaShape = GamaShapeFactory.createFrom((Geometry)((Geometry)fSTObjectInput.readObject()));
                if (d > 0.0) {
                    gamaShape.setDepth(d);
                }
                if (type != IShape.Type.NULL) {
                    gamaShape.setGeometricalType(type);
                }
                return gamaShape;
            }
        });
        this.register(fSTConfiguration, IAgent.class, new FSTIndividualSerialiser<IAgent>(this){

            @Override
            protected boolean shouldRegister() {
                return false;
            }

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, IAgent iAgent) throws Exception {
                if (inAgent) {
                    fSTObjectOutput.writeBoolean(true);
                    fSTObjectOutput.writeObject(AgentReference.of((IAgent)iAgent));
                } else {
                    inAgent = true;
                    fSTObjectOutput.writeBoolean(false);
                    fSTObjectOutput.writeObject(SerialisedAgent.of((IAgent)iAgent, (boolean)true));
                    inAgent = false;
                }
            }

            @Override
            public IAgent deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                boolean bl = fSTObjectInput.readBoolean();
                if (bl) {
                    AgentReference agentReference = (AgentReference)fSTObjectInput.readObject(AgentReference.class);
                    return agentReference.getReferencedAgent(iScope);
                }
                SerialisedAgent serialisedAgent = (SerialisedAgent)fSTObjectInput.readObject(SerialisedAgent.class);
                return serialisedAgent.recreateIn(iScope);
            }
        });
        this.register(fSTConfiguration, IType.class, new FSTIndividualSerialiser<IType>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, IType iType) throws Exception {
                fSTObjectOutput.writeStringUTF(iType.getGamlType().getName());
                if (iType.isCompoundType()) {
                    fSTObjectOutput.writeObject(iType.getKeyType());
                    fSTObjectOutput.writeObject(iType.getContentType());
                }
            }

            @Override
            public IType deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                String string = fSTObjectInput.readStringUTF();
                IType iType = iScope.getType(string);
                if (iType.isCompoundType()) {
                    IType iType2 = (IType)fSTObjectInput.readObject();
                    IType iType3 = (IType)fSTObjectInput.readObject();
                    return GamaType.from((IType)iType, (IType)iType2, (IType)iType3);
                }
                return iType;
            }
        });
        this.register(fSTConfiguration, IScope.class, new FSTIndividualSerialiser<IScope>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, IScope iScope) throws Exception {
                fSTObjectOutput.writeStringUTF(iScope.getName());
            }

            @Override
            public IScope deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                String string = fSTObjectInput.readStringUTF();
                return iScope.copy(string);
            }
        });
        this.register(fSTConfiguration, ISpecies.class, new FSTIndividualSerialiser<ISpecies>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, ISpecies iSpecies) throws Exception {
                fSTObjectOutput.writeStringUTF(iSpecies.getName());
            }

            @Override
            public ISpecies deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                String string = fSTObjectInput.readStringUTF();
                return iScope.getModel().getSpecies(string);
            }
        });
        this.register(fSTConfiguration, AgentReference.class, new FSTIndividualSerialiser<AgentReference>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, AgentReference agentReference) throws Exception {
                fSTObjectOutput.writeObject(agentReference.species());
                fSTObjectOutput.writeObject(agentReference.index());
            }

            @Override
            public AgentReference deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                return AgentReference.of((String[])((String[])fSTObjectInput.readObject()), (Integer[])((Integer[])fSTObjectInput.readObject()));
            }
        });
        this.register(fSTConfiguration, SerialisedAgent.class, new FSTIndividualSerialiser<SerialisedAgent>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, SerialisedAgent serialisedAgent) throws Exception {
                fSTObjectOutput.writeInt(serialisedAgent.index());
                fSTObjectOutput.writeStringUTF(serialisedAgent.species());
                fSTObjectOutput.writeObject(serialisedAgent.attributes());
                fSTObjectOutput.writeObject(serialisedAgent.innerPopulations());
            }

            @Override
            public SerialisedAgent deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                return new SerialisedAgent(fSTObjectInput.readInt(), fSTObjectInput.readStringUTF(), (Map)fSTObjectInput.readObject(), (Map)fSTObjectInput.readObject());
            }
        });
        this.register(fSTConfiguration, SerialisedPopulation.class, new FSTIndividualSerialiser<SerialisedPopulation>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, SerialisedPopulation serialisedPopulation) throws Exception {
                fSTObjectOutput.writeStringUTF(serialisedPopulation.speciesName());
                fSTObjectOutput.writeObject(serialisedPopulation.agents());
            }

            @Override
            public SerialisedPopulation deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                return new SerialisedPopulation(fSTObjectInput.readStringUTF(), (List)fSTObjectInput.readObject());
            }
        });
        this.register(fSTConfiguration, SerialisedGrid.class, new FSTIndividualSerialiser<SerialisedGrid>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, SerialisedGrid serialisedGrid) throws Exception {
                fSTObjectOutput.writeStringUTF(serialisedGrid.speciesName());
                fSTObjectOutput.writeObject(serialisedGrid.agents());
                fSTObjectOutput.writeObject(serialisedGrid.matrix());
            }

            @Override
            public SerialisedGrid deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                return new SerialisedGrid(fSTObjectInput.readStringUTF(), (List)fSTObjectInput.readObject(), (IGrid)fSTObjectInput.readObject());
            }
        });
        this.register(fSTConfiguration, GamaGeometryFactory.class, new FSTIndividualSerialiser<GamaGeometryFactory>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, GamaGeometryFactory gamaGeometryFactory) throws Exception {
                fSTObjectOutput.writeStringUTF("*GGF*");
            }

            @Override
            public GamaGeometryFactory deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                fSTObjectInput.readStringUTF();
                return GeometryUtils.GEOMETRY_FACTORY;
            }
        });
        this.register(fSTConfiguration, GamaFont.class, new FSTIndividualSerialiser<GamaFont>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, GamaFont gamaFont) throws Exception {
                fSTObjectOutput.writeStringUTF(gamaFont.getName());
                fSTObjectOutput.writeInt(gamaFont.getStyle());
                fSTObjectOutput.writeInt(gamaFont.getSize());
            }

            @Override
            public GamaFont deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                return new GamaFont(fSTObjectInput.readStringUTF(), fSTObjectInput.readInt(), fSTObjectInput.readInt());
            }
        });
        this.register(fSTConfiguration, IMap.class, new FSTIndividualSerialiser<IMap>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, IMap iMap) throws Exception {
                fSTObjectOutput.writeObject(iMap.getGamlType().getKeyType());
                fSTObjectOutput.writeObject(iMap.getGamlType().getContentType());
                fSTObjectOutput.writeBoolean(iMap.isOrdered());
                fSTObjectOutput.writeInt(iMap.size());
                iMap.forEach((object, object2) -> {
                    try {
                        fSTObjectOutput.writeObject(object);
                        fSTObjectOutput.writeObject(object2);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                });
            }

            @Override
            public IMap deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                IType iType = (IType)fSTObjectInput.readObject();
                IType iType2 = (IType)fSTObjectInput.readObject();
                boolean bl = fSTObjectInput.readBoolean();
                IMap iMap = GamaMapFactory.create((IType)iType, (IType)iType2, (boolean)bl);
                int n = fSTObjectInput.readInt();
                int n2 = 0;
                while (n2 < n) {
                    iMap.put(fSTObjectInput.readObject(), fSTObjectInput.readObject());
                    ++n2;
                }
                return iMap;
            }
        });
        this.register(fSTConfiguration, IList.class, new FSTIndividualSerialiser<IList>(this){

            @Override
            protected boolean shouldRegister() {
                return false;
            }

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, IList iList) throws Exception {
                fSTObjectOutput.writeObject(iList.getGamlType().getContentType());
                fSTObjectOutput.writeInt(iList.size());
                iList.forEach(object -> {
                    try {
                        fSTObjectOutput.writeObject(object);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                });
            }

            @Override
            public IList deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                IType iType = (IType)fSTObjectInput.readObject();
                IList iList = GamaListFactory.create((IType)iType);
                int n = fSTObjectInput.readInt();
                int n2 = 0;
                while (n2 < n) {
                    iList.add(fSTObjectInput.readObject());
                    ++n2;
                }
                return iList;
            }
        });
        this.register(fSTConfiguration, GamaCoordinateSequenceFactory.class, new FSTIndividualSerialiser<GamaCoordinateSequenceFactory>(this){

            @Override
            public void serialise(FSTObjectOutput fSTObjectOutput, GamaCoordinateSequenceFactory gamaCoordinateSequenceFactory) throws Exception {
                fSTObjectOutput.writeStringUTF("*GCSF*");
            }

            @Override
            public GamaCoordinateSequenceFactory deserialise(IScope iScope, FSTObjectInput fSTObjectInput) throws Exception {
                fSTObjectInput.readStringUTF();
                return GeometryUtils.GEOMETRY_FACTORY.getCoordinateSequenceFactory();
            }
        });
    }

    public <T> void register(FSTConfiguration fSTConfiguration, Class<T> clazz, FSTIndividualSerialiser<T> fSTIndividualSerialiser) {
        fSTConfiguration.registerSerializer(clazz, fSTIndividualSerialiser, true);
    }

    public FSTConfiguration initConfiguration(FSTConfiguration fSTConfiguration) {
        this.registerSerialisers(fSTConfiguration);
        return fSTConfiguration;
    }

    abstract class FSTIndividualSerialiser<T>
    extends FSTBasicObjectSerializer {
        FSTIndividualSerialiser() {
        }

        protected boolean shouldRegister() {
            return true;
        }

        public final T instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
            T t = this.deserialise(BinarySerialiser.this.scope, fSTObjectInput);
            if (this.shouldRegister()) {
                fSTObjectInput.registerObject(t, n, fSTClazzInfo, fSTFieldInfo);
            }
            return t;
        }

        @Override
        public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
            try {
                this.serialise(fSTObjectOutput, object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void serialise(FSTObjectOutput fSTObjectOutput, T t) throws Exception {
        }

        public abstract T deserialise(IScope var1, FSTObjectInput var2) throws Exception;
    }
}

