/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import gama.dev.DEBUG;
import java.io.IOException;
import java.io.InputStream;

public final class FSTInputStream
extends InputStream {
    public static boolean REPORT_READ_FAILS = false;
    public int chunk_size = 8000;
    public static ThreadLocal<byte[]> cachedBuffer = new ThreadLocal();
    public byte[] buf;
    public int pos;
    public int count;
    InputStream in;
    boolean fullyRead = false;
    public boolean byteBacked = false;

    public FSTInputStream(InputStream inputStream) {
        this.initFromStream(inputStream);
    }

    public void resetForReuse(byte[] byArray, int n) {
        this.reset();
        this.count = n;
        this.buf = byArray;
        this.pos = 0;
        this.byteBacked = true;
        this.fullyRead = true;
    }

    public void initFromStream(InputStream inputStream) {
        this.fullyRead = false;
        this.byteBacked = false;
        this.pos = 0;
        this.in = inputStream;
        if (this.buf == null) {
            this.buf = cachedBuffer.get();
            if (this.buf == null) {
                this.buf = new byte[this.chunk_size];
                cachedBuffer.set(this.buf);
            }
        }
        this.readNextChunk(inputStream);
    }

    public boolean isFullyRead() {
        return this.fullyRead && this.pos >= this.count;
    }

    public void readNextChunk(InputStream inputStream) {
        try {
            int n;
            if (this.buf.length < this.count + this.chunk_size) {
                this.ensureCapacity(Math.max(Math.min(0x7FFFFFFE, this.buf.length * 2), this.count + this.chunk_size));
            }
            if ((n = inputStream.read(this.buf, this.count, this.chunk_size)) > 0) {
                this.count += n;
            } else {
                this.fullyRead = true;
            }
        }
        catch (IOException iOException) {
            if (REPORT_READ_FAILS) {
                DEBUG.ERR((Object)"Failed to read next chunk from InputStream", (Throwable)iOException);
                throw new RuntimeException("Failed to read next chunk from InputStream", iOException);
            }
            this.fullyRead = true;
        }
    }

    public void ensureCapacity(int n) {
        if (this.buf.length < n && !this.fullyRead) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
            if (n < 0xA00000) {
                cachedBuffer.set(this.buf);
            }
        }
    }

    public FSTInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public FSTInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
    }

    @Override
    public int read() {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        this.readNextChunk(this.in);
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] var1_1, int var2_2, int var3_3) {
        if (!this.isFullyRead()) ** GOTO lbl4
        return -1;
lbl-1000:
        // 1 sources

        {
            this.readNextChunk(this.in);
lbl4:
            // 2 sources

            ** while (!this.fullyRead && this.pos + var3_3 >= this.count)
        }
lbl5:
        // 1 sources

        var4_4 = this.count - this.pos;
        if (var3_3 > var4_4) {
            var3_3 = var4_4;
        }
        if (var3_3 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, var1_1, var2_2, var3_3);
        this.pos += var3_3;
        return var3_3;
    }

    @Override
    public long skip(long l) {
        long l2 = this.count - this.pos;
        if (l < l2) {
            l2 = l < 0L ? 0L : l;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() {
        this.count = 0;
        this.pos = 0;
        this.fullyRead = false;
        this.byteBacked = false;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public void ensureReadAhead(int n) {
        if (this.byteBacked) {
            return;
        }
        int n2 = this.pos + n;
        while (!this.fullyRead && this.count < n2) {
            this.readNextChunk(this.in);
        }
    }
}

