/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.sound;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.sound.GamaSoundPlayer;
import gama.extension.sound.SoundPlayerBroker;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IExecutable;
import java.io.File;

@GamlAnnotations.inside(kinds={3, 11, 6, 5})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="source", type={4}, optional=false, doc={@GamlAnnotations.doc(value="The path to music file. This path is relative to the path of the model.")}), @GamlAnnotations.facet(name="mode", type={-201}, values={"overwrite", "ignore"}, optional=true, doc={@GamlAnnotations.doc(value="Mode of playing the sound")}), @GamlAnnotations.facet(name="repeat", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Should the sound be repeated or not ?")})})
@validator(value=StartSoundValidator.class)
@GamlAnnotations.doc(value="Allows to start the sound output")
public class StartSoundStatement
extends AbstractStatementSequence {
    private final IExpression source = this.getFacet(new String[]{"source"});
    private final IExpression mode = this.getFacet(new String[]{"mode"});
    private final IExpression repeat = this.getFacet(new String[]{"repeat"});
    private AbstractStatementSequence sequence = null;

    public StartSoundStatement(IDescription iDescription) {
        super(iDescription);
    }

    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence = new AbstractStatementSequence(this.description);
        this.sequence.setName("commands of " + this.getName());
        this.sequence.setChildren(iterable);
    }

    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        GamaSoundPlayer gamaSoundPlayer = SoundPlayerBroker.getInstance().getSoundPlayer(iAgent);
        String string = FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)((String)this.source.value(iScope)), (boolean)false);
        if (gamaSoundPlayer != null) {
            gamaSoundPlayer.play(iScope, new File(string), this.mode != null ? (String)this.mode.value(iScope) : "overwrite", this.repeat != null ? (Boolean)this.repeat.value(iScope) : false);
        }
        if (this.sequence != null) {
            iScope.execute((IExecutable)this.sequence, iAgent, null);
        }
        return null;
    }

    public static class StartSoundValidator
    implements IDescriptionValidator {
        public void validate(IDescription iDescription) {
        }
    }
}

