/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.sound.music;

import gama.annotations.precompiler.GamlAnnotations;
import gama.dev.DEBUG;
import gama.extension.sound.music.IPlayMusic;
import gama.gaml.skills.Skill;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;

@GamlAnnotations.skill(name="music", concept={"network", "communication", "skill"}, doc={@GamlAnnotations.doc(value="Skill allowing agents to output sounds")})
public class PlayMusicSkill
extends Skill
implements IPlayMusic {
    public int volume = 200;
    private Synthesizer synthetiseur;
    private final MidiChannel canal;

    public PlayMusicSkill() {
        try {
            this.synthetiseur = MidiSystem.getSynthesizer();
            this.synthetiseur.open();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            DEBUG.OUT((Object)midiUnavailableException);
        }
        this.canal = this.synthetiseur.getChannels()[0];
        this.canal.programChange(0);
    }

    public void note_on(int n) {
        this.canal.noteOn(n, this.volume);
    }

    public void note_off(int n) {
        this.canal.noteOff(n);
    }

    public void set_instrument(int n) {
        this.canal.programChange(n);
    }
}

