/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.basicplayer;

import gama.dev.DEBUG;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayerEventLauncher;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import javazoom.jlgui.basicplayer.BasicPlayerListener;
import javazoom.spi.PropertiesContainer;
import org.tritonus.share.sampled.TAudioFormat;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class BasicPlayer
implements BasicController,
Runnable {
    public static final int EXTERNAL_BUFFER_SIZE = 16000;
    public static final int SKIP_INACCURACY_SIZE = 1200;
    protected Thread m_thread = null;
    protected Object m_dataSource = null;
    protected AudioInputStream m_encodedaudioInputStream;
    protected int encodedLength = -1;
    protected AudioInputStream m_audioInputStream;
    protected AudioFileFormat m_audioFileFormat;
    protected SourceDataLine m_line;
    protected FloatControl m_gainControl;
    protected FloatControl m_panControl;
    protected String m_mixerName = null;
    private int m_lineCurrentBufferSize = -1;
    private int lineBufferSize = -1;
    private long threadSleep = -1L;
    public static final int UNKNOWN = -1;
    public static final int PLAYING = 0;
    public static final int PAUSED = 1;
    public static final int STOPPED = 2;
    public static final int OPENED = 3;
    public static final int SEEKING = 4;
    private int m_status = -1;
    private Collection<BasicPlayerListener> m_listeners = null;
    private final Map<?, ?> empty_map = new HashMap();

    public BasicPlayer() {
        this.m_listeners = new ArrayList<BasicPlayerListener>();
        this.reset();
    }

    protected void reset() {
        this.m_status = -1;
        if (this.m_audioInputStream != null) {
            this.closeStream();
        }
        this.m_audioInputStream = null;
        this.m_audioFileFormat = null;
        this.m_encodedaudioInputStream = null;
        this.encodedLength = -1;
        if (this.m_line != null) {
            this.m_line.stop();
            this.m_line.close();
            this.m_line = null;
        }
        this.m_gainControl = null;
        this.m_panControl = null;
    }

    public void addBasicPlayerListener(BasicPlayerListener basicPlayerListener) {
        this.m_listeners.add(basicPlayerListener);
    }

    public Collection<BasicPlayerListener> getListeners() {
        return this.m_listeners;
    }

    public void removeBasicPlayerListener(BasicPlayerListener basicPlayerListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(basicPlayerListener);
        }
    }

    public void setLineBufferSize(int n) {
        this.lineBufferSize = n;
    }

    public int getLineBufferSize() {
        return this.lineBufferSize;
    }

    public int getLineCurrentBufferSize() {
        return this.m_lineCurrentBufferSize;
    }

    public void setSleepTime(long l) {
        this.threadSleep = l;
    }

    public long getSleepTime() {
        return this.threadSleep;
    }

    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void open(File file) throws BasicPlayerException {
        DEBUG.OUT((Object)("open(" + String.valueOf(file) + ")"));
        if (file != null) {
            this.m_dataSource = file;
            this.initAudioInputStream();
        }
    }

    @Override
    public void open(URL uRL) throws BasicPlayerException {
        DEBUG.OUT((Object)("open(" + String.valueOf(uRL) + ")"));
        if (uRL != null) {
            this.m_dataSource = uRL;
            this.initAudioInputStream();
        }
    }

    @Override
    public void open(InputStream inputStream) throws BasicPlayerException {
        DEBUG.OUT((Object)("open(" + String.valueOf(inputStream) + ")"));
        if (inputStream != null) {
            this.m_dataSource = inputStream;
            this.initAudioInputStream();
        }
    }

    protected void initAudioInputStream() throws BasicPlayerException {
        try {
            AudioFormat audioFormat;
            this.reset();
            this.notifyEvent(0, this.getEncodedStreamPosition(), -1.0, this.m_dataSource);
            if (this.m_dataSource instanceof URL) {
                this.initAudioInputStream((URL)this.m_dataSource);
            } else if (this.m_dataSource instanceof File) {
                this.initAudioInputStream((File)this.m_dataSource);
            } else if (this.m_dataSource instanceof InputStream) {
                this.initAudioInputStream((InputStream)this.m_dataSource);
            }
            this.createLine();
            Map<Object, Object> map = null;
            if (this.m_audioFileFormat instanceof TAudioFileFormat) {
                map = ((TAudioFileFormat)this.m_audioFileFormat).properties();
                map = this.deepCopy(map);
            } else {
                map = new HashMap();
            }
            if (this.m_audioFileFormat.getByteLength() > 0) {
                map.put("audio.length.bytes", this.m_audioFileFormat.getByteLength());
            }
            if (this.m_audioFileFormat.getFrameLength() > 0) {
                map.put("audio.length.frames", this.m_audioFileFormat.getFrameLength());
            }
            if (this.m_audioFileFormat.getType() != null) {
                map.put("audio.type", this.m_audioFileFormat.getType().toString());
            }
            if ((audioFormat = this.m_audioFileFormat.getFormat()).getFrameRate() > 0.0f) {
                map.put("audio.framerate.fps", Float.valueOf(audioFormat.getFrameRate()));
            }
            if (audioFormat.getFrameSize() > 0) {
                map.put("audio.framesize.bytes", audioFormat.getFrameSize());
            }
            if (audioFormat.getSampleRate() > 0.0f) {
                map.put("audio.samplerate.hz", Float.valueOf(audioFormat.getSampleRate()));
            }
            if (audioFormat.getSampleSizeInBits() > 0) {
                map.put("audio.samplesize.bits", audioFormat.getSampleSizeInBits());
            }
            if (audioFormat.getChannels() > 0) {
                map.put("audio.channels", audioFormat.getChannels());
            }
            if (audioFormat instanceof TAudioFormat) {
                Map map2 = ((TAudioFormat)audioFormat).properties();
                map.putAll(map2);
            }
            map.put("basicplayer.sourcedataline", this.m_line);
            for (BasicPlayerListener basicPlayerListener : this.m_listeners) {
                basicPlayerListener.opened(this.m_dataSource, map);
            }
            this.m_status = 3;
            this.notifyEvent(1, this.getEncodedStreamPosition(), -1.0, null);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException exception) {
            throw new BasicPlayerException(exception);
        }
    }

    protected void initAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(file);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(file);
    }

    protected void initAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(uRL);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(uRL);
    }

    protected void initAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(inputStream);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(inputStream);
    }

    protected void initLine() throws LineUnavailableException {
        DEBUG.OUT((Object)"initLine()");
        if (this.m_line == null) {
            this.createLine();
        }
        if (!this.m_line.isOpen()) {
            this.openLine();
        } else {
            AudioFormat audioFormat;
            AudioFormat audioFormat2 = this.m_line.getFormat();
            AudioFormat audioFormat3 = audioFormat = this.m_audioInputStream == null ? null : this.m_audioInputStream.getFormat();
            if (!audioFormat2.equals(audioFormat)) {
                this.m_line.close();
                this.openLine();
            }
        }
    }

    protected void createLine() throws LineUnavailableException {
        DEBUG.OUT((Object)"Create Line");
        if (this.m_line == null) {
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            DEBUG.OUT((Object)("Create Line : Source format : " + audioFormat.toString()));
            int n = audioFormat.getSampleSizeInBits();
            if (n <= 0) {
                n = 16;
            }
            if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW || audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
                n = 16;
            }
            if (n != 8) {
                n = 16;
            }
            AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getChannels() * (n / 8), audioFormat.getSampleRate(), false);
            DEBUG.OUT((Object)("Create Line : Target format: " + String.valueOf(audioFormat2)));
            this.m_encodedaudioInputStream = this.m_audioInputStream;
            try {
                this.encodedLength = this.m_encodedaudioInputStream.available();
            }
            catch (IOException iOException) {
                DEBUG.ERR((Object)"Cannot get m_encodedaudioInputStream.available()", (Throwable)iOException);
            }
            this.m_audioInputStream = AudioSystem.getAudioInputStream(audioFormat2, this.m_audioInputStream);
            AudioFormat audioFormat3 = this.m_audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat3, -1);
            Mixer mixer = this.getMixer(this.m_mixerName);
            if (mixer != null) {
                DEBUG.OUT((Object)("Mixer : " + mixer.getMixerInfo().toString()));
                this.m_line = (SourceDataLine)mixer.getLine(info);
            } else {
                this.m_line = (SourceDataLine)AudioSystem.getLine(info);
                this.m_mixerName = null;
            }
            DEBUG.OUT((Object)("Line : " + this.m_line.toString()));
            DEBUG.OUT((Object)("Line Info : " + this.m_line.getLineInfo().toString()));
            DEBUG.OUT((Object)("Line AudioFormat: " + this.m_line.getFormat().toString()));
        }
    }

    protected void openLine() throws LineUnavailableException {
        if (this.m_line != null) {
            Control[] controlArray;
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            int n = this.lineBufferSize;
            if (n <= 0) {
                n = this.m_line.getBufferSize();
            }
            this.m_lineCurrentBufferSize = n;
            this.m_line.open(audioFormat, n);
            DEBUG.OUT((Object)("Open Line : BufferSize=" + n));
            Control[] controlArray2 = controlArray = this.m_line.getControls();
            int n2 = controlArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Control control = controlArray2[n3];
                DEBUG.OUT((Object)("Controls : " + control.toString()));
                ++n3;
            }
            if (this.m_line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                this.m_gainControl = (FloatControl)this.m_line.getControl(FloatControl.Type.MASTER_GAIN);
                DEBUG.OUT((Object)("Master Gain Control : [" + this.m_gainControl.getMinimum() + "," + this.m_gainControl.getMaximum() + "] " + this.m_gainControl.getPrecision()));
            }
            if (this.m_line.isControlSupported(FloatControl.Type.PAN)) {
                this.m_panControl = (FloatControl)this.m_line.getControl(FloatControl.Type.PAN);
                DEBUG.OUT((Object)("Pan Control : [" + this.m_panControl.getMinimum() + "," + this.m_panControl.getMaximum() + "] " + this.m_panControl.getPrecision()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPlayback() {
        if (this.m_status == 0 || this.m_status == 1) {
            if (this.m_line != null) {
                this.m_line.flush();
                this.m_line.stop();
            }
            this.m_status = 2;
            this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
            AudioInputStream audioInputStream = this.m_audioInputStream;
            synchronized (audioInputStream) {
                this.closeStream();
            }
            DEBUG.OUT((Object)"stopPlayback() completed");
        }
    }

    protected void pausePlayback() {
        if (this.m_line != null && this.m_status == 0) {
            this.m_line.flush();
            this.m_line.stop();
            this.m_status = 1;
            DEBUG.OUT((Object)"pausePlayback() completed");
            this.notifyEvent(4, this.getEncodedStreamPosition(), -1.0, null);
        }
    }

    protected void resumePlayback() {
        if (this.m_line != null && this.m_status == 1) {
            this.m_line.start();
            this.m_status = 0;
            DEBUG.OUT((Object)"resumePlayback() completed");
            this.notifyEvent(5, this.getEncodedStreamPosition(), -1.0, null);
        }
    }

    protected void startPlayback() throws BasicPlayerException {
        if (this.m_status == 2) {
            this.initAudioInputStream();
        }
        if (this.m_status == 3) {
            DEBUG.OUT((Object)"startPlayback called");
            if (this.m_thread != null && this.m_thread.isAlive()) {
                DEBUG.OUT((Object)"WARNING: old thread still running!!");
                int n = 0;
                while (this.m_status != 3) {
                    try {
                        if (this.m_thread == null) continue;
                        DEBUG.OUT((Object)("Waiting ... " + n));
                        Thread.sleep(1000L);
                        if (++n <= 2) continue;
                        this.m_thread.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BasicPlayerException("Wait error", interruptedException);
                    }
                }
            }
            try {
                this.initLine();
            }
            catch (LineUnavailableException lineUnavailableException) {
                throw new BasicPlayerException("Cannot init line", lineUnavailableException);
            }
            DEBUG.OUT((Object)"Creating new thread");
            this.m_thread = new Thread((Runnable)this, "BasicPlayer");
            this.m_thread.start();
            if (this.m_line != null) {
                this.m_line.start();
                this.m_status = 0;
                this.notifyEvent(2, this.getEncodedStreamPosition(), -1.0, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DEBUG.OUT((Object)"Thread Running");
        int n = 1;
        byte[] byArray = new byte[16000];
        AudioInputStream audioInputStream = this.m_audioInputStream;
        synchronized (audioInputStream) {
            while (true) {
                if (n == -1 || this.m_status == 2 || this.m_status == 4 || this.m_status == -1) {
                    if (this.m_line != null) {
                        this.m_line.drain();
                        this.m_line.stop();
                        this.m_line.close();
                        this.m_line = null;
                    }
                    if (n == -1) {
                        this.notifyEvent(8, this.getEncodedStreamPosition(), -1.0, null);
                    }
                    this.closeStream();
                    break;
                }
                if (this.m_status == 0) {
                    try {
                        n = this.m_audioInputStream.read(byArray, 0, byArray.length);
                        if (n >= 0) {
                            byte[] byArray2 = new byte[n];
                            System.arraycopy(byArray, 0, byArray2, 0, n);
                            if (this.m_line.available() >= this.m_line.getBufferSize()) {
                                DEBUG.ERR((Object)("Underrun : " + this.m_line.available() + "/" + this.m_line.getBufferSize()));
                            }
                            this.m_line.write(byArray, 0, n);
                            int n2 = this.getEncodedStreamPosition();
                            for (BasicPlayerListener basicPlayerListener : this.m_listeners) {
                                if (this.m_audioInputStream instanceof PropertiesContainer) {
                                    Map map = ((PropertiesContainer)this.m_audioInputStream).properties();
                                    basicPlayerListener.progress(n2, this.m_line.getMicrosecondPosition(), byArray2, map);
                                    continue;
                                }
                                basicPlayerListener.progress(n2, this.m_line.getMicrosecondPosition(), byArray2, this.empty_map);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        DEBUG.ERR((Object)"Thread cannot run()", (Throwable)iOException);
                        this.m_status = 2;
                        this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
                    }
                    if (this.threadSleep <= 0L) continue;
                    try {
                        Thread.sleep(this.threadSleep);
                    }
                    catch (InterruptedException interruptedException) {
                        DEBUG.ERR((Object)("Thread cannot sleep(" + this.threadSleep + ")"), (Throwable)interruptedException);
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    DEBUG.ERR((Object)"Thread cannot sleep(1000)", (Throwable)interruptedException);
                }
            }
        }
        this.m_status = 2;
        this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
        DEBUG.OUT((Object)"Thread completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long skipBytes(long l) throws BasicPlayerException {
        long l2 = 0L;
        if (this.m_dataSource instanceof File) {
            DEBUG.OUT((Object)("Bytes to skip : " + l));
            int n = this.m_status;
            this.m_status = 4;
            long l3 = 0L;
            try {
                AudioInputStream audioInputStream = this.m_audioInputStream;
                synchronized (audioInputStream) {
                    this.notifyEvent(6, this.getEncodedStreamPosition(), -1.0, null);
                    this.initAudioInputStream();
                    if (this.m_audioInputStream != null) {
                        while (l2 < l - 1200L) {
                            l3 = this.m_audioInputStream.skip(l - l2);
                            if (l3 == 0L) break;
                            DEBUG.OUT((Object)("Skipped : " + (l2 += l3) + "/" + l));
                            if (l2 != -1L) continue;
                            throw new BasicPlayerException("Skip not supported");
                        }
                    }
                }
                this.notifyEvent(7, this.getEncodedStreamPosition(), -1.0, null);
                this.m_status = 3;
                if (n == 0) {
                    this.startPlayback();
                } else if (n == 1) {
                    this.startPlayback();
                    this.pausePlayback();
                }
            }
            catch (IOException iOException) {
                throw new BasicPlayerException(iOException);
            }
        }
        return l2;
    }

    protected void notifyEvent(int n, int n2, double d, Object object) {
        BasicPlayerEventLauncher basicPlayerEventLauncher = new BasicPlayerEventLauncher(n, n2, d, object, new ArrayList<BasicPlayerListener>(this.m_listeners), this);
        basicPlayerEventLauncher.start();
    }

    protected int getEncodedStreamPosition() {
        int n = -1;
        if (this.m_dataSource instanceof File) {
            try {
                if (this.m_encodedaudioInputStream != null) {
                    n = this.encodedLength - this.m_encodedaudioInputStream.available();
                }
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    protected void closeStream() {
        try {
            if (this.m_audioInputStream != null) {
                this.m_audioInputStream.close();
                DEBUG.OUT((Object)"Stream closed");
            }
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Cannot close stream", (Throwable)iOException);
        }
    }

    public boolean hasGainControl() {
        if (this.m_gainControl == null && this.m_line != null && this.m_line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.m_gainControl = (FloatControl)this.m_line.getControl(FloatControl.Type.MASTER_GAIN);
        }
        return this.m_gainControl != null;
    }

    public float getGainValue() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getValue();
        }
        return 0.0f;
    }

    public float getMaximumGain() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMaximum();
        }
        return 0.0f;
    }

    public float getMinimumGain() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMinimum();
        }
        return 0.0f;
    }

    public boolean hasPanControl() {
        if (this.m_panControl == null && this.m_line != null && this.m_line.isControlSupported(FloatControl.Type.PAN)) {
            this.m_panControl = (FloatControl)this.m_line.getControl(FloatControl.Type.PAN);
        }
        return this.m_panControl != null;
    }

    public float getPrecision() {
        if (this.hasPanControl()) {
            return this.m_panControl.getPrecision();
        }
        return 0.0f;
    }

    public float getPan() {
        if (this.hasPanControl()) {
            return this.m_panControl.getValue();
        }
        return 0.0f;
    }

    protected Map<String, Object> deepCopy(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map != null) {
            for (String string : map.keySet()) {
                Object object = map.get(string);
                hashMap.put(string, object);
            }
        }
        return hashMap;
    }

    @Override
    public long seek(long l) throws BasicPlayerException {
        return this.skipBytes(l);
    }

    @Override
    public void play() throws BasicPlayerException {
        this.startPlayback();
    }

    @Override
    public void stop() throws BasicPlayerException {
        this.stopPlayback();
    }

    @Override
    public void pause() throws BasicPlayerException {
        this.pausePlayback();
    }

    @Override
    public void resume() throws BasicPlayerException {
        this.resumePlayback();
    }

    @Override
    public void setPan(double d) throws BasicPlayerException {
        if (!this.hasPanControl()) {
            throw new BasicPlayerException("Pan control not supported");
        }
        DEBUG.OUT((Object)("Pan : " + d));
        this.m_panControl.setValue((float)d);
        this.notifyEvent(9, this.getEncodedStreamPosition(), d, null);
    }

    @Override
    public void setGain(double d) throws BasicPlayerException {
        if (!this.hasGainControl()) {
            throw new BasicPlayerException("Gain control not supported");
        }
        double d2 = this.getMinimumGain();
        double d3 = 0.5f * this.getMaximumGain() - this.getMinimumGain();
        double d4 = Math.log(10.0) / 20.0;
        double d5 = d2 + 1.0 / d4 * Math.log(1.0 + (Math.exp(d4 * d3) - 1.0) * d);
        DEBUG.OUT((Object)("Gain : " + d5));
        this.m_gainControl.setValue((float)d5);
        this.notifyEvent(10, this.getEncodedStreamPosition(), d, null);
    }

    public List<String> getMixers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        if (infoArray != null) {
            Mixer.Info[] infoArray2 = infoArray;
            int n = infoArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mixer.Info info = infoArray2[n2];
                Line.Info info2 = new Line.Info(SourceDataLine.class);
                Mixer mixer = AudioSystem.getMixer(info);
                if (mixer.isLineSupported(info2)) {
                    arrayList.add(info.getName());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public Mixer getMixer(String string) {
        Mixer.Info[] infoArray;
        Mixer mixer = null;
        if (string != null && (infoArray = AudioSystem.getMixerInfo()) != null) {
            Mixer.Info[] infoArray2 = infoArray;
            int n = infoArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mixer.Info info = infoArray2[n2];
                if (info.getName().equals(string)) {
                    mixer = AudioSystem.getMixer(info);
                    break;
                }
                ++n2;
            }
        }
        return mixer;
    }

    public String getMixerName() {
        return this.m_mixerName;
    }

    public void setMixerName(String string) {
        this.m_mixerName = string;
    }
}

