/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.batch.documentation;

import gama.annotations.precompiler.IConcept;
import gama.headless.batch.documentation.Utils;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ConceptManager {
    public static String[] CONCEPTS_NOT_FOR_GAML_REF = new String[]{"autosave", "background", "distribution", "enumeration", "facet", "global", "halt", "import", "inheritance", "init", "layer", "model", "opengl", "operator", "output", "pause", "permanent", "probability", "pseudo_variable", "reflex", "refresh", "sport", "torus", "update", "write", "world"};
    public static String[] CONCEPTS_NOT_FOR_MODEL_LIBRARY = new String[]{"action", "attribute", "autosave", "background", "behavior", "constant", "cycle", "dimension", "display", "distribution", "enumeration", "experiment", "facet", "file", "global", "graphic_unit", "halt", "import", "init", "layer", "length_unit", "model", "opengl", "operator", "optimization", "output", "parameter", "pause", "permanent", "probability", "point", "pseudo_variable", "random", "random_operator", "reflex", "refresh", "species", "surface_unit", "time", "time_unit", "torus", "type", "update", "volume_unit", "weight_unit", "write", "world"};
    public static String[] CONCEPTS_DEDICATED_TO_SYNTAX = new String[]{"arithmetic", "attribute", "cast", "condition", "container", "filter", "list", "logical", "loop", "map", "matrix", "string", "ternary"};
    private static ArrayList<String> m_concepts;
    static HashMap<String, Integer> m_occurrence_of_concept;
    static HashMap<String, Integer> m_occurrence_of_concept_in_model_library;
    static HashMap<String, Integer> m_occurrence_of_concept_in_gaml_ref;
    static HashMap<String, Integer> m_occurrence_of_concept_in_documentation;

    public static void loadConcepts() throws IllegalArgumentException, IllegalAccessException {
        Field[] fieldArray;
        m_concepts = new ArrayList();
        m_occurrence_of_concept = new HashMap();
        m_occurrence_of_concept_in_model_library = new HashMap();
        m_occurrence_of_concept_in_gaml_ref = new HashMap();
        m_occurrence_of_concept_in_documentation = new HashMap();
        Field[] fieldArray2 = fieldArray = IConcept.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            String string = field.get(new Object()).toString();
            m_concepts.add(string);
            m_occurrence_of_concept.put(string, 0);
            m_occurrence_of_concept_in_model_library.put(string, 0);
            m_occurrence_of_concept_in_gaml_ref.put(string, 0);
            m_occurrence_of_concept_in_documentation.put(string, 0);
            ++n2;
        }
    }

    public static boolean conceptIsPossibleToAdd(String string) {
        return m_concepts.contains(string);
    }

    public static void addOccurrenceOfConcept(String string) {
        ConceptManager.addOccurrenceOfConcept(string, "");
    }

    public static void addOccurrenceOfConcept(String string, String string2) {
        if (m_concepts.contains(string)) {
            int n = m_occurrence_of_concept.get(string);
            m_occurrence_of_concept.put(string, ++n);
            if (string2.equals(WebsitePart.DOCUMENTATION.toString())) {
                n = m_occurrence_of_concept_in_documentation.get(string);
                m_occurrence_of_concept_in_documentation.put(string, ++n);
            }
            if (string2.equals(WebsitePart.GAML_REFERENCES.toString())) {
                n = m_occurrence_of_concept_in_gaml_ref.get(string);
                m_occurrence_of_concept_in_gaml_ref.put(string, ++n);
                if (Utils.isInList(string, CONCEPTS_NOT_FOR_GAML_REF)) {
                    System.out.println("WARNING : The concept " + string + " is not supposed to be for GAML References !!");
                }
            }
            if (string2.equals(WebsitePart.MODEL_LIBRARY.toString())) {
                n = m_occurrence_of_concept_in_model_library.get(string);
                m_occurrence_of_concept_in_model_library.put(string, ++n);
                if (Utils.isInList(string, CONCEPTS_NOT_FOR_MODEL_LIBRARY)) {
                    System.out.println("WARNING : The concept " + string + " is not supposed to be for the model library !!");
                }
            }
        }
    }

    public static void printStatistics() {
        Iterator<String> iterator = m_occurrence_of_concept.keySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            int n = m_occurrence_of_concept.get(string);
            System.out.println("concept " + string + " : " + n + " occurrences.");
            if (n == 0) {
                arrayList.add(string);
            }
            if (n <= 20) continue;
            arrayList2.add(string);
        }
        System.out.println("_____________________________");
        for (String string : arrayList) {
            System.out.println("WARNING : No occurrence for concept " + string + ".");
        }
        for (String string : arrayList2) {
            System.out.println("WARNING : Too much occurrences (" + Integer.toString(m_occurrence_of_concept.get(string)) + ") for concept " + string + ".");
        }
    }

    public static String getExtendedStatistics() {
        Object object = "";
        Collections.sort(m_concepts, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        object = (String)object + "\n\n_The following text has been automatically generated from \"mainCheckConcepts\"_\n\n";
        object = (String)object + "______________ _last update : " + simpleDateFormat.format(date) + "_\n\n";
        object = (String)object + "**List of concepts to use for model library (except Syntax):**\n\n";
        boolean bl = true;
        for (String string : m_concepts) {
            if (Utils.isInList(string, CONCEPTS_DEDICATED_TO_SYNTAX) || Utils.isInList(string, CONCEPTS_NOT_FOR_MODEL_LIBRARY)) continue;
            if (bl) {
                object = (String)object + string;
                bl = false;
                continue;
            }
            object = (String)object + ", " + string;
        }
        object = (String)object + "\n\n";
        object = (String)object + "**List of concepts to use exclusively in Syntax models:**\n\n";
        bl = true;
        for (String string : m_concepts) {
            if (!Utils.isInList(string, CONCEPTS_DEDICATED_TO_SYNTAX)) continue;
            if (bl) {
                object = (String)object + string;
                bl = false;
                continue;
            }
            object = (String)object + ", " + string;
        }
        object = (String)object + "\n\n";
        object = (String)object + "**List of concepts to use for GAML worlds:**\n\n";
        bl = true;
        for (String string : m_concepts) {
            if (Utils.isInList(string, CONCEPTS_NOT_FOR_GAML_REF)) continue;
            if (bl) {
                object = (String)object + string;
                bl = false;
                continue;
            }
            object = (String)object + ", " + string;
        }
        object = (String)object + "\n\n";
        object = (String)object + "| **Concept name** | **in Doc** | **in GAML Ref** | **in Model Lib** | **TOTAL** |\n";
        object = (String)object + "|:----------------------------|:-------------|:-------------|:-------------|:-------------|\n";
        int n = 0;
        while (n < m_concepts.size()) {
            String string = m_concepts.get(n);
            String string2 = Integer.toString(m_occurrence_of_concept.get(string));
            String string3 = Integer.toString(m_occurrence_of_concept_in_documentation.get(string));
            String string4 = Integer.toString(m_occurrence_of_concept_in_gaml_ref.get(string));
            if (Utils.isInList(string, CONCEPTS_NOT_FOR_GAML_REF)) {
                string4 = "_";
            }
            String string5 = Integer.toString(m_occurrence_of_concept_in_model_library.get(string));
            if (Utils.isInList(string, CONCEPTS_NOT_FOR_MODEL_LIBRARY)) {
                string5 = "_";
            }
            object = (String)object + "| " + (String)string + " | " + string3 + " | " + string4 + " | " + string5 + " | " + string2 + " |\n";
            ++n;
        }
        return object;
    }

    public static enum WebsitePart {
        DOCUMENTATION,
        GAML_REFERENCES,
        MODEL_LIBRARY;

    }
}

