/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.batch;

import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.kernel.experiment.TestAgent;
import gama.core.kernel.model.IModel;
import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.gaml.statements.test.TestState;
import gama.headless.batch.AbstractModelLibraryRunner;
import gama.headless.runtime.HeadlessApplication;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public class ModelLibraryTester
extends AbstractModelLibraryRunner {
    private static ModelLibraryTester instance;
    PrintStream original;
    PrintStream nullStream;

    private ModelLibraryTester() {
        DEBUG.ON();
    }

    @Override
    public int start() throws IOException {
        Injector injector = HeadlessApplication.getInjector();
        GamlModelBuilder gamlModelBuilder = this.createBuilder(injector);
        this.original = System.out;
        this.nullStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int n) {
            }
        });
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Multimap multimap = GamaBundleLoader.getPluginsWithTests();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Bundle bundle : multimap.keySet()) {
            for (String string : multimap.get((Object)bundle)) {
                Enumeration enumeration = bundle.findEntries(string, "*", true);
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    URL uRL2 = (URL)enumeration.nextElement();
                    if (!this.isTest(uRL2)) continue;
                    URL uRL3 = FileLocator.toFileURL((URL)uRL2);
                    arrayList.add(uRL3);
                }
            }
        }
        gamlModelBuilder.loadURLs(arrayList);
        arrayList.forEach(uRL -> this.test(gamlModelBuilder, nArray, nArray2, (URL)uRL));
        DEBUG.OUT((Object)(nArray[0] + " tests executed in built-in library and plugins. " + nArray2[0] + " failed or aborted"));
        DEBUG.OUT((Object)nArray2[0]);
        return nArray2[0];
    }

    public void test(GamlModelBuilder gamlModelBuilder, int[] nArray, int[] nArray2, URL uRL) {
        ArrayList arrayList = new ArrayList();
        try {
            IModel iModel = gamlModelBuilder.compile(uRL, arrayList);
            if (iModel == null || iModel.getDescription() == null) {
                return;
            }
            List<String> list = iModel.getDescription().getExperimentNames().stream().filter(string -> iModel.getExperiment(string).isTest()).toList();
            if (list.isEmpty()) {
                return;
            }
            for (String string2 : list) {
                IExperimentPlan iExperimentPlan = GAMA.addHeadlessExperiment((IModel)iModel, (String)string2, (ParametersSet)new ParametersSet(), null);
                if (iExperimentPlan == null) continue;
                System.setOut(this.nullStream);
                TestAgent testAgent = (TestAgent)iExperimentPlan.getAgent();
                iExperimentPlan.setHeadless(true);
                iExperimentPlan.getAgent().step(testAgent.getScope());
                nArray2[0] = nArray2[0] + testAgent.getSummary().countTestsWith(TestState.FAILED);
                nArray2[0] = nArray2[0] + testAgent.getSummary().countTestsWith(TestState.ABORTED);
                nArray[0] = nArray[0] + testAgent.getSummary().size();
                System.setOut(this.original);
                if (testAgent.getSummary().countTestsWith(TestState.FAILED) <= 0 && testAgent.getSummary().countTestsWith(TestState.ABORTED) <= 0) continue;
                DEBUG.OUT((Object)testAgent.getSummary().toString());
            }
        }
        catch (Exception exception) {
            DEBUG.OUT((Object)exception.getMessage());
        }
    }

    public static ModelLibraryTester getInstance() {
        if (instance == null) {
            instance = new ModelLibraryTester();
        }
        return instance;
    }
}

