/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.core;

import gama.core.kernel.experiment.ExperimentPlan;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.outputs.IOutput;
import gama.core.outputs.MonitorOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.gaml.compilation.GAML;
import gama.gaml.expressions.IExpression;
import gama.headless.core.IExperiment;
import gama.headless.server.GamaServerExperimentJob;

public class Experiment
implements IExperiment {
    public static final double DEFAULT_SEED_VALUE = 0.0;
    protected IExperimentPlan currentExperiment = null;
    protected ParametersSet params = new ParametersSet();
    protected final IModel model;
    protected String experimentName = null;
    protected double seed = 0.0;
    protected long currentStep;

    public Experiment(IModel iModel) {
        this.model = iModel;
    }

    @Override
    public SimulationAgent getSimulation() {
        return this.currentExperiment == null ? null : this.currentExperiment.getCurrentSimulation();
    }

    protected IScope getScope() {
        SimulationAgent simulationAgent = this.getSimulation();
        return simulationAgent == null ? null : simulationAgent.getScope();
    }

    @Override
    public synchronized void setup(String string, double d) {
        this.seed = d;
        this.loadCurrentExperiment(string);
    }

    @Override
    public synchronized void setup(String string, double d, IList iList, GamaServerExperimentJob gamaServerExperimentJob) {
        this.seed = d;
        this.loadCurrentExperiment(string, iList, gamaServerExperimentJob);
    }

    private void loadCurrentExperiment(String string, IList iList, GamaServerExperimentJob gamaServerExperimentJob) {
        this.experimentName = string;
        this.currentStep = 0L;
        ExperimentPlan experimentPlan = (ExperimentPlan)this.model.getExperiment(string);
        experimentPlan.setHeadless(true);
        experimentPlan.setController((IExperimentController)gamaServerExperimentJob.controller);
        experimentPlan.setParameterValues(iList);
        experimentPlan.open(Double.valueOf(this.seed));
        if (!GAMA.getControllers().contains(experimentPlan.getController())) {
            GAMA.getControllers().add(experimentPlan.getController());
        }
        this.currentExperiment = experimentPlan;
        this.currentExperiment.setHeadless(true);
    }

    private void loadCurrentExperiment(String string) {
        this.experimentName = string;
        this.currentStep = 0L;
        this.currentExperiment = GAMA.addHeadlessExperiment((IModel)this.model, (String)this.experimentName, (ParametersSet)this.params, (Double)this.seed);
        this.currentExperiment.setHeadless(true);
    }

    @Override
    public long step() {
        this.currentExperiment.getAgent().step(this.currentExperiment.getAgent().getScope());
        return this.currentStep++;
    }

    @Override
    public long backStep() {
        this.currentExperiment.getAgent().backward(this.currentExperiment.getAgent().getScope());
        return this.currentStep--;
    }

    @Override
    public void setParameter(String string, Object object) {
        this.params.put(string, object);
    }

    @Override
    public Object getOutput(String string) {
        IOutput iOutput = this.getSimulation().getOutputManager().getOutputWithOriginalName(string);
        if (iOutput == null) {
            throw GamaRuntimeException.error((String)("Output does not exist: " + string), (IScope)this.getScope());
        }
        if (!(iOutput instanceof MonitorOutput)) {
            throw GamaRuntimeException.error((String)("Output " + string + " is not an alphanumeric data."), (IScope)this.getScope());
        }
        iOutput.update();
        return ((MonitorOutput)iOutput).getLastValue();
    }

    @Override
    public Object getVariableOutput(String string) {
        Object object = this.getSimulation().getDirectVarValue(this.getScope(), string);
        if (object == null) {
            throw GamaRuntimeException.error((String)("Output unresolved: " + string), (IScope)this.getScope());
        }
        return object;
    }

    @Override
    public void dispose() {
        GAMA.closeExperiment((IExperimentPlan)this.currentExperiment);
        this.currentExperiment = null;
    }

    @Override
    public boolean isInterrupted() {
        SimulationAgent simulationAgent = this.currentExperiment.getCurrentSimulation();
        if (this.currentExperiment.isBatch() && simulationAgent == null) {
            return false;
        }
        return simulationAgent == null || simulationAgent.dead() || simulationAgent.getScope().interrupted();
    }

    @Override
    public IModel getModel() {
        return this.model;
    }

    @Override
    public IExperimentPlan getExperimentPlan() {
        return this.currentExperiment;
    }

    @Override
    public IExpression compileExpression(String string) {
        return GAML.compileExpression((String)string, (IAgent)this.getSimulation(), (boolean)false);
    }

    @Override
    public Object evaluateExpression(IExpression iExpression) {
        return iExpression.value(this.getSimulation().getScope());
    }

    @Override
    public Object evaluateExpression(String string) {
        IExpression iExpression = this.compileExpression(string);
        return this.evaluateExpression(iExpression);
    }
}

