/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.core;

import gama.core.kernel.model.IModel;
import gama.core.outputs.IOutput;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.MonitorOutput;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.headless.common.DataType;
import gama.headless.common.DataTypeFactory;
import gama.headless.core.Experiment;
import gama.headless.core.IRichExperiment;
import gama.headless.core.RichOutput;
import gama.headless.job.ExperimentJob;
import gama.headless.job.ListenedVariable;

public class RichExperiment
extends Experiment
implements IRichExperiment {
    public RichExperiment(IModel iModel) {
        super(iModel);
    }

    @Override
    public ExperimentJob.OutputType getTypeOf(String string) {
        if (this.currentExperiment == null) {
            return ExperimentJob.OutputType.OUTPUT;
        }
        if (this.currentExperiment.hasVar(string)) {
            return ExperimentJob.OutputType.EXPERIMENT_ATTRIBUTE;
        }
        if (this.currentExperiment.getModel().getSpecies().hasVar(string)) {
            return ExperimentJob.OutputType.SIMULATION_ATTRIBUTE;
        }
        return ExperimentJob.OutputType.OUTPUT;
    }

    @Override
    public RichOutput getRichOutput(ListenedVariable listenedVariable) {
        String string = listenedVariable.getName();
        if (this.getSimulation() == null || this.getSimulation().dead()) {
            return null;
        }
        IOutput iOutput = this.getSimulation().getOutputManager().getOutputWithOriginalName(string);
        if (iOutput == null) {
            throw GamaRuntimeException.error((String)"Output unresolved", (IScope)this.currentExperiment.getExperimentScope());
        }
        iOutput.update();
        Object object = null;
        DataType dataType = null;
        if (iOutput instanceof MonitorOutput) {
            object = ((MonitorOutput)iOutput).getLastValue();
            dataType = DataTypeFactory.getObjectMetaData(object);
        } else if (iOutput instanceof LayeredDisplayOutput) {
            object = ((LayeredDisplayOutput)iOutput).getImage(listenedVariable.width, listenedVariable.height);
            dataType = DataType.DISPLAY2D;
        }
        return new RichOutput(string, this.currentStep, object, dataType);
    }
}

