/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.runtime;

import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.runtime.server.CommandResponse;
import gama.core.runtime.server.GamaServerExperimentConfiguration;
import gama.core.runtime.server.GamaWebSocketServer;
import gama.core.runtime.server.IGamaServer;
import gama.core.runtime.server.ISocketCommand;
import gama.core.runtime.server.MessageType;
import gama.core.util.IMap;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.server.SSLParametersWebSocketServerFactory;

public class GamaHeadlessWebSocketServer
extends GamaWebSocketServer {
    static final String TLS = "TLS";
    static final String JKS = "JKS";
    static final String SUN_X509 = "SunX509";
    private final ThreadPoolExecutor executor;
    private final Map<String, Map<String, IExperimentPlan>> launchedExperiments = new ConcurrentHashMap<String, Map<String, IExperimentPlan>>();

    public static IGamaServer startForSecureHeadless(int n, ThreadPoolExecutor threadPoolExecutor, boolean bl, String string, String string2, String string3, int n2) {
        GamaHeadlessWebSocketServer gamaHeadlessWebSocketServer = new GamaHeadlessWebSocketServer(n, threadPoolExecutor, bl, string, string2, string3, n2);
        try {
            gamaHeadlessWebSocketServer.setReuseAddr(true);
            gamaHeadlessWebSocketServer.start();
            GamaHeadlessWebSocketServer gamaHeadlessWebSocketServer2 = gamaHeadlessWebSocketServer;
            return gamaHeadlessWebSocketServer2;
        }
        finally {
            gamaHeadlessWebSocketServer.infiniteLoop();
        }
    }

    public static GamaHeadlessWebSocketServer startForHeadless(int n, ThreadPoolExecutor threadPoolExecutor, int n2) {
        GamaHeadlessWebSocketServer gamaHeadlessWebSocketServer = new GamaHeadlessWebSocketServer(n, threadPoolExecutor, false, "", "", "", n2);
        try {
            gamaHeadlessWebSocketServer.setReuseAddr(true);
            gamaHeadlessWebSocketServer.start();
            GamaHeadlessWebSocketServer gamaHeadlessWebSocketServer2 = gamaHeadlessWebSocketServer;
            return gamaHeadlessWebSocketServer2;
        }
        finally {
            gamaHeadlessWebSocketServer.infiniteLoop();
        }
    }

    private GamaHeadlessWebSocketServer(int n, ThreadPoolExecutor threadPoolExecutor, boolean bl, String string, String string2, String string3, int n2) {
        super(n, n2);
        this.executor = threadPoolExecutor;
        if (bl) {
            this.configureWebSocketFactoryWithSSL(string, string2, string3);
        }
    }

    private void configureWebSocketFactoryWithSSL(String string, String string2, String string3) {
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream inputStream = Files.newInputStream(new File(string).toPath(), new OpenOption[0]);){
                KeyStore keyStore = KeyStore.getInstance(JKS);
                keyStore.load(inputStream, string2.toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SUN_X509);
                keyManagerFactory.init(keyStore, string3.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SUN_X509);
                trustManagerFactory.init(keyStore);
                SSLContext sSLContext = SSLContext.getInstance(TLS);
                sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                SSLParameters sSLParameters = new SSLParameters();
                sSLParameters.setNeedClientAuth(false);
                this.setWebSocketFactory((WebSocketServerFactory)new SSLParametersWebSocketServerFactory(sSLContext, sSLParameters));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void infiniteLoop() {
        try {
            while (true) {
                Thread.sleep(999999L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void onClose(WebSocket webSocket, int n, String string, boolean bl) {
        super.onClose(webSocket, n, string, bl);
        String string2 = GamaHeadlessWebSocketServer.getSocketId((WebSocket)webSocket);
        if (this.getLaunchedExperiments().get(string2) != null) {
            for (IExperimentPlan iExperimentPlan : this.getLaunchedExperiments().get(string2).values()) {
                iExperimentPlan.getController().processPause(true);
                iExperimentPlan.getController().close();
                iExperimentPlan.getController().dispose();
            }
            this.getLaunchedExperiments().get(string2).clear();
        }
    }

    public Map<String, Map<String, IExperimentPlan>> getAllExperiments() {
        return this.launchedExperiments;
    }

    public Map<String, IExperimentPlan> getExperimentsOf(String string) {
        return this.launchedExperiments.get(string);
    }

    public IExperimentPlan getExperiment(String string, String string2) {
        if (this.launchedExperiments.get(string) == null) {
            return null;
        }
        return this.launchedExperiments.get(string).get(string2);
    }

    public void execute(Runnable runnable) {
        if (this.executor == null) {
            runnable.run();
        } else {
            this.executor.execute(runnable);
        }
    }

    public Map<String, Map<String, IExperimentPlan>> getLaunchedExperiments() {
        return this.launchedExperiments;
    }

    public void addExperiment(String string, String string2, IExperimentPlan iExperimentPlan) {
        this.launchedExperiments.putIfAbsent(string, new ConcurrentHashMap());
        this.launchedExperiments.get(string).put(string2, iExperimentPlan);
    }

    public GamaServerExperimentConfiguration obtainGuiServerConfiguration() {
        return GamaServerExperimentConfiguration.NULL;
    }

    public IExperimentPlan retrieveExperimentPlan(WebSocket webSocket, IMap<String, Object> iMap) throws ISocketCommand.CommandException {
        Object object;
        String string = iMap.get((Object)"exp_id") != null ? iMap.get((Object)"exp_id").toString() : "";
        Object object2 = object = iMap.get((Object)"socket_id") != null ? iMap.get((Object)"socket_id").toString() : "" + webSocket.hashCode();
        if ("".equals(string)) {
            throw new ISocketCommand.CommandException(new CommandResponse(MessageType.MalformedRequest, (Object)("For " + String.valueOf(iMap.get((Object)"type")) + ", mandatory parameter is: exp_id"), iMap, false));
        }
        IExperimentPlan iExperimentPlan = this.getExperiment((String)object, string);
        if (iExperimentPlan == null || iExperimentPlan.getAgent() == null || iExperimentPlan.getAgent().dead()) {
            throw new ISocketCommand.CommandException(new CommandResponse(MessageType.UnableToExecuteRequest, (Object)"Unable to find the experiment or simulation", iMap, false));
        }
        return iExperimentPlan;
    }
}

