/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.batch;

import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.headless.batch.AbstractModelLibraryRunner;
import gama.headless.runtime.HeadlessApplication;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public class ModelLibraryValidator
extends AbstractModelLibraryRunner {
    private static ModelLibraryValidator instance;

    private ModelLibraryValidator() {
        DEBUG.ON();
    }

    @Override
    public int start() throws IOException {
        Injector injector = HeadlessApplication.getInjector();
        GamlModelBuilder gamlModelBuilder = this.createBuilder(injector);
        int[] nArray = new int[1];
        int[] nArray2 = new int[2];
        this.validatePluginsFromURLs((Multimap<Bundle, String>)GamaBundleLoader.getPluginsWithModels(), gamlModelBuilder, nArray, nArray2);
        DEBUG.OUT((Object)(nArray[0] + " GAMA models compiled in built-in library and plugins. " + nArray2[0] + " compilation errors found"));
        nArray2[1] = nArray2[0];
        nArray2[0] = 0;
        nArray[0] = 0;
        this.validatePluginsFromURLs((Multimap<Bundle, String>)GamaBundleLoader.getPluginsWithTests(), gamlModelBuilder, nArray, nArray2);
        DEBUG.OUT((Object)(nArray[0] + " GAMA tests compiled in built-in library and plugins. " + nArray2[0] + " compilation errors found"));
        DEBUG.OUT((Object)(nArray2[0] + nArray2[1]));
        return nArray2[0] + nArray2[1];
    }

    private void validatePluginsFromURLs(Multimap<Bundle, String> multimap, GamlModelBuilder gamlModelBuilder, int[] nArray, int[] nArray2) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Bundle bundle : multimap.keySet()) {
            for (String string : multimap.get((Object)bundle)) {
                Enumeration enumeration = bundle.findEntries(string, "*", true);
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    URL uRL2 = (URL)enumeration.nextElement();
                    if (!this.isModel(uRL2)) continue;
                    URL uRL3 = FileLocator.toFileURL((URL)uRL2);
                    arrayList.add(uRL3);
                }
            }
        }
        gamlModelBuilder.loadURLs(arrayList);
        arrayList.forEach(uRL -> this.validate(gamlModelBuilder, nArray, nArray2, (URL)uRL));
    }

    private void validate(GamlModelBuilder gamlModelBuilder, int[] nArray, int[] nArray2, URL uRL) {
        ArrayList arrayList = new ArrayList();
        gamlModelBuilder.compile(uRL, arrayList);
        nArray[0] = nArray[0] + 1;
        arrayList.stream().filter(GamlCompilationError::isError).forEach(gamlCompilationError -> {
            DEBUG.OUT((Object)("Error in " + String.valueOf(gamlCompilationError.getURI()) + ":\n " + gamlCompilationError.toString() + " \n " + gamlCompilationError.getStatement().toString() + "\n"));
            nArray[0] = nArray2[0] + 1;
        });
    }

    public static ModelLibraryValidator getInstance() {
        if (instance == null) {
            instance = new ModelLibraryValidator();
        }
        return instance;
    }
}

