/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class SymbolProcessor
extends ElementProcessor<GamlAnnotations.symbol> {
    Set<String> temp = new HashSet<String>();

    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, Element e, GamlAnnotations.symbol symbol2) {
        String clazz = SymbolProcessor.rawNameOf(context, e.asType());
        String name = symbol2.name().length == 0 ? e.getSimpleName().toString() : symbol2.name()[0];
        this.verifyDoc(context, e, "symbol " + name, (Annotation)symbol2);
        StringBuilder constants = new StringBuilder();
        sb.append("\n").append("_symbol(");
        SymbolProcessor.toArrayOfStrings(symbol2.name(), sb).append(',').append(SymbolProcessor.toClassObject(clazz));
        sb.append(",").append(symbol2.kind()).append(',').append(this.toBoolean(symbol2.breakable())).append(',').append(this.toBoolean(symbol2.continuable())).append(',').append(this.toBoolean(symbol2.remote_context())).append(',').append(this.toBoolean(symbol2.with_args())).append(',').append(this.toBoolean(symbol2.with_scope())).append(',');
        sb.append(this.toBoolean(symbol2.with_sequence())).append(',').append(this.toBoolean(symbol2.unique_in_context())).append(',').append(this.toBoolean(symbol2.unique_name())).append(',');
        GamlAnnotations.inside inside2 = e.getAnnotation(GamlAnnotations.inside.class);
        if (inside2 != null) {
            SymbolProcessor.toArrayOfStrings(inside2.symbols(), sb).append(',');
            SymbolProcessor.toArrayOfInts(inside2.kinds(), sb).append(',');
        } else {
            SymbolProcessor.toArrayOfStrings(null, sb).append(',');
            SymbolProcessor.toArrayOfInts(null, sb).append(',');
        }
        GamlAnnotations.facets facets2 = e.getAnnotation(GamlAnnotations.facets.class);
        String omissible = "";
        if (facets2 == null) {
            sb.append("null");
        } else {
            omissible = facets2.omissible();
            sb.append("P(");
            int i = 0;
            while (i < facets2.value().length) {
                GamlAnnotations.facet child = facets2.value()[i];
                String fName = child.name();
                if (this.temp.contains(fName)) {
                    context.emitError("Facet '" + fName + " is declared twice", e);
                } else {
                    this.temp.add(fName);
                }
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("_facet(").append(SymbolProcessor.toJavaString(fName)).append(',');
                SymbolProcessor.toArrayOfInts(child.type(), sb).append(',').append(child.of()).append(',').append(child.index()).append(',');
                String[] values = child.values();
                if (values != null && values.length > 0) {
                    SymbolProcessor.toArrayOfStrings(values, constants).append(',');
                }
                SymbolProcessor.toArrayOfStrings(values, sb).append(',').append(this.toBoolean(child.optional())).append(',').append(this.toBoolean(child.internal())).append(',').append(this.toBoolean(child.remote_context()));
                this.verifyDoc(context, e, "facet " + child.name(), (Annotation)child);
                sb.append(')');
                ++i;
            }
            this.temp.clear();
            sb.append(')');
        }
        sb.append(',').append(SymbolProcessor.toJavaString(omissible)).append(',').append("(x)->new ").append(clazz).append("(x)");
        sb.append(");");
        if (constants.length() > 0) {
            constants.setLength(constants.length() - 1);
            sb.append("\n").append("_constants(").append((CharSequence)constants).append(");");
        }
    }

    @Override
    protected Class<GamlAnnotations.symbol> getAnnotationClass() {
        return GamlAnnotations.symbol.class;
    }

    @Override
    protected boolean validateElement(ProcessorContext context, Element e) {
        boolean result = this.assertClassExtends(context, true, (TypeElement)e, context.getType("gama.gaml.compilation.ISymbol"));
        return result &= this.assertAnnotationPresent(context, false, e, GamlAnnotations.inside.class);
    }
}

