/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.view;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLContext;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.common.interfaces.ILayerManager;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.filter.Different;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.outputs.LayeredDisplayData;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.display.LayerManager;
import gama.core.outputs.layers.IEventLayerListener;
import gama.core.outputs.layers.OverlayLayer;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.extension.image.GamaImage;
import gama.extension.image.ImageHelper;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.ui.display.opengl.renderer.JOGLRenderer;
import gama.ui.display.opengl.view.GamaGLCanvas;
import gama.ui.experiment.menus.AgentsMenu;
import gama.ui.experiment.views.displays.DisplaySurfaceMenu;
import gama.ui.shared.menus.MenuAction;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.DPIHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

@GamlAnnotations.display(value={"opengl", "3d"})
@GamlAnnotations.doc(value="Displays that uses the OpenGL technology to display their layers in 3D")
public class SWTOpenGLDisplaySurface
implements IDisplaySurface.OpenGL {
    GLAnimatorControl animator;
    JOGLRenderer renderer;
    protected boolean zoomFit = true;
    Set<IEventLayerListener> listeners = new HashSet<IEventLayerListener>();
    final LayeredDisplayOutput output;
    final LayerManager layerManager;
    protected DisplaySurfaceMenu menuManager;
    IScope.IGraphicsScope scope;
    final Composite parent;
    volatile boolean disposed;
    private volatile boolean alreadyUpdating;
    private GamaPoint world_position;
    ByteBuffer buffer;
    DataBuffer dbuf;
    AffineTransform at;

    static {
        DEBUG.ON();
    }

    public SWTOpenGLDisplaySurface(Object ... objectArray) {
        this.output = (LayeredDisplayOutput)objectArray[0];
        this.parent = (Composite)objectArray[1];
        this.output.getData().addListener((LayeredDisplayData.DisplayDataListener)this);
        this.output.setSurface((IDisplaySurface)this);
        this.setDisplayScope(this.output.getScope().copyForGraphics("in opengl display"));
        this.layerManager = new LayerManager((IDisplaySurface)this, this.output);
        if (!this.layerManager.stayProportional()) {
            this.output.getData().setDrawEnv(false);
        }
        this.renderer = this.createRenderer();
        this.animator = new GamaGLCanvas(this.parent, this.renderer, this.getOutput().getName()).getAnimator();
        this.animator.start();
    }

    protected JOGLRenderer createRenderer() {
        return new JOGLRenderer((IDisplaySurface)this);
    }

    public void setMenuManager(Object object) {
        this.menuManager = (DisplaySurfaceMenu)object;
    }

    public GamaImage getImage(int n, int n2) {
        if (n == 0 || n2 == 0 || !this.renderer.hasDrawnOnce()) {
            return null;
        }
        Rectangle rectangle = this.getBoundsForRegularSnapshot();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        GamaGLCanvas gamaGLCanvas = this.renderer.getCanvas();
        if (gamaGLCanvas == null) {
            return null;
        }
        GL2 gL2 = gamaGLCanvas.getGL().getGL2();
        if (gL2 == null) {
            return null;
        }
        GLContext gLContext = gL2.getContext();
        if (gLContext == null) {
            return null;
        }
        boolean bl = gLContext.isCurrent();
        if (!bl) {
            gLContext.makeCurrent();
        }
        GamaImage[] gamaImageArray = new GamaImage[1];
        gamaGLCanvas.invoke(true, gLAutoDrawable -> {
            ByteBuffer byteBuffer = this.getBuffer(n3, n4);
            gL2.glReadBuffer(1029);
            gL2.glReadPixels(0, 0, n3, n4, 6408, 5121, (Buffer)byteBuffer);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8}, true, false, 3, 0);
            SampleModel sampleModel = ((ColorModel)componentColorModel).createCompatibleSampleModel(n3, n4);
            WritableRaster writableRaster = new WritableRaster(sampleModel, this.dbuf, new Point()){};
            GamaImage gamaImage = GamaImage.from((ColorModel)componentColorModel, (WritableRaster)writableRaster, (boolean)false);
            if (n != n3 || n2 != n4) {
                gamaImage = ImageHelper.scaleImage((Image)gamaImage, (int)n, (int)n2);
            }
            ImageHelper.flipImageVertically((GamaImage)gamaImage);
            gamaImageArray[0] = gamaImage;
            return true;
        });
        if (!bl) {
            gamaGLCanvas.getGL().getContext().release();
        }
        return gamaImageArray[0];
    }

    protected ByteBuffer getBuffer(int n, int n2) {
        if (this.buffer == null || this.buffer.capacity() != n * n2 * 4) {
            this.buffer = Buffers.newDirectByteBuffer((int)(n * n2 * 4));
            this.dbuf = new DataBuffer(0, n * n2 * 4){

                @Override
                public void setElem(int n, int n2, int n3) {
                    SWTOpenGLDisplaySurface.this.buffer.put(n2, (byte)n3);
                }

                @Override
                public int getElem(int n, int n2) {
                    return SWTOpenGLDisplaySurface.this.buffer.get(n2);
                }
            };
            this.at = new AffineTransform();
            this.at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
            this.at.concatenate(AffineTransform.getTranslateInstance(0.0, n2));
        } else {
            this.buffer.rewind();
        }
        return this.buffer;
    }

    public void updateDisplay(boolean bl, GeneralSynchronizer generalSynchronizer) {
        if (this.alreadyUpdating) {
            return;
        }
        try {
            this.alreadyUpdating = true;
            this.renderer.setSynchronizer(generalSynchronizer);
            this.layerManager.drawLayersOn((IGraphics)this.renderer);
        }
        finally {
            this.alreadyUpdating = false;
        }
    }

    public double getDisplayWidth() {
        return this.renderer.getWidth();
    }

    public double getDisplayHeight() {
        return this.renderer.getHeight();
    }

    public void zoomIn() {
        if (this.renderer.getData().isCameraLocked()) {
            return;
        }
        this.renderer.getCameraHelper().zoom(true);
    }

    public void zoomOut() {
        if (this.renderer.getData().isCameraLocked()) {
            return;
        }
        this.renderer.getCameraHelper().zoom(false);
    }

    public void zoomFit() {
        this.renderer.getCameraHelper().initialize();
        this.output.getData().resetRotation();
        this.output.getData().setZoomLevel(this.renderer.getCameraHelper().zoomLevel(), true);
        this.zoomFit = true;
    }

    public void toggleLock() {
        this.renderer.getCameraHelper().toggleCameraLock();
    }

    public ILayerManager getManager() {
        return this.layerManager;
    }

    public void focusOn(IShape iShape) {
        this.renderer.getCameraHelper().zoomFocus(iShape.getEnvelope().yNegated());
    }

    public void runAndUpdate(Runnable runnable) {
        runnable.run();
        if (this.getScope().isPaused()) {
            this.updateDisplay(true);
        }
        if (this.animator.isPaused()) {
            this.animator.resume();
            this.animator.pause();
        }
    }

    public int getWidth() {
        return this.renderer.getCanvas().getSurfaceWidth();
    }

    public int getHeight() {
        return this.renderer.getCanvas().getSurfaceHeight();
    }

    public void outputReloaded() {
        this.setDisplayScope(this.output.getScope().copyForGraphics("in opengl display"));
        if (!((Boolean)GamaPreferences.Runtime.ERRORS_IN_DISPLAYS.getValue()).booleanValue()) {
            this.getScope().disableErrorReporting();
        }
        this.renderer.initScene();
        this.layerManager.outputChanged();
        if (this.zoomFit) {
            this.zoomFit();
        }
    }

    public void addListener(IEventLayerListener iEventLayerListener) {
        this.listeners.add(iEventLayerListener);
    }

    public void removeListener(IEventLayerListener iEventLayerListener) {
        this.listeners.remove(iEventLayerListener);
    }

    public Collection<IEventLayerListener> getLayerListeners() {
        return this.listeners;
    }

    public double getEnvWidth() {
        return this.output.getData().getEnvWidth();
    }

    public double getEnvHeight() {
        return this.output.getData().getEnvHeight();
    }

    public GamaPoint getModelCoordinates() {
        return this.world_position;
    }

    public GamaPoint getWindowCoordinates() {
        return this.renderer.getCameraHelper().getMousePosition();
    }

    public void getModelCoordinatesInfo(StringBuilder stringBuilder) {
        boolean bl = this.getManager().isProvidingCoordinates();
        if (!bl) {
            stringBuilder.append("No world coordinates");
            return;
        }
        bl = this.getManager().isProvidingWorldCoordinates();
        if (!bl) {
            stringBuilder.append("No world coordinates");
            return;
        }
        GamaPoint gamaPoint = this.getModelCoordinates();
        String string = gamaPoint == null ? "N/A" : String.format("%5.2f", gamaPoint.getX());
        String string2 = gamaPoint == null ? "N/A" : String.format("%5.2f", gamaPoint.getY());
        stringBuilder.append(String.format("X%8s | Y%8s", string, string2));
    }

    public Envelope getVisibleRegionForLayer(ILayer iLayer) {
        if (iLayer instanceof OverlayLayer) {
            return this.getScope().getSimulation().getEnvelope();
        }
        Envelope envelope = iLayer.getData().getVisibleRegion();
        if (envelope == null) {
            envelope = new Envelope();
            Point point = new Point(0, 0);
            int n = -point.x;
            int n2 = -point.y;
            envelope.expandToInclude((Coordinate)iLayer.getModelCoordinatesFrom(n, n2, (IDisplaySurface)this));
            envelope.expandToInclude((Coordinate)iLayer.getModelCoordinatesFrom(n += this.renderer.getCanvas().getSurfaceWidth(), n2 += this.renderer.getCanvas().getSurfaceHeight(), (IDisplaySurface)this));
            iLayer.getData().setVisibleRegion(envelope);
        }
        return envelope;
    }

    public GamaPoint getModelCoordinatesFrom(int n, int n2, Point point, Point point2) {
        GamaPoint gamaPoint = new GamaPoint((double)n, (double)n2);
        GamaPoint gamaPoint2 = this.renderer.getRealWorldPointFromWindowPoint(gamaPoint);
        return new GamaPoint(gamaPoint2.x, -gamaPoint2.y);
    }

    public Collection<IAgent> selectAgent(int n, int n2) {
        GamaPoint gamaPoint = this.getModelCoordinatesFrom(n, n2, null, null);
        return this.scope.getRoot().getTopology().getNeighborsOf((IScope)this.scope, (IShape)new GamaPoint(gamaPoint.getX(), gamaPoint.getY()), Double.valueOf(this.renderer.getMaxEnvDim() / 100.0), (IAgentFilter)Different.with());
    }

    public double getZoomLevel() {
        if (this.output.getData().getZoomLevel() == null) {
            this.output.getData().setZoomLevel(this.computeInitialZoomLevel(), true);
        }
        return this.output.getData().getZoomLevel();
    }

    protected Double computeInitialZoomLevel() {
        return this.renderer.getCameraHelper().zoomLevel();
    }

    public IScope.IGraphicsScope getScope() {
        return this.scope;
    }

    public LayeredDisplayOutput getOutput() {
        return this.output;
    }

    public void setPaused(boolean bl) {
        if (bl) {
            this.animator.pause();
        } else {
            this.animator.resume();
        }
    }

    public void selectAgent(DrawingAttributes drawingAttributes) {
        Runnable runnable;
        IAgent iAgent = null;
        boolean bl = true;
        if (drawingAttributes != null) {
            if (drawingAttributes.getSpeciesName() != null) {
                bl = false;
                runnable = this.renderer.getRealWorldPointFromWindowPoint(this.renderer.getCameraHelper().getLastMousePressedPosition());
                iAgent = this.scope.getRoot().getPopulationFor(drawingAttributes.getSpeciesName()).getAgent((IScope)this.scope, new GamaPoint(((GamaPoint)runnable).x, -((GamaPoint)runnable).y));
            } else {
                iAgent = drawingAttributes.getAgentIdentifier();
            }
        }
        Runnable runnable2 = runnable = iAgent != null ? () -> this.renderer.getPickingHelper().setPicking(false) : () -> {
            this.renderer.getPickingHelper().setPicking(false);
            this.getManager().forceRedrawingLayers();
            this.updateDisplay(true);
        };
        if (bl) {
            this.menuManager.buildMenu((int)this.renderer.getCameraHelper().getMousePosition().x, (int)this.renderer.getCameraHelper().getMousePosition().y, iAgent, runnable, new MenuAction[]{AgentsMenu.getHighlightActionFor((IAgent)iAgent)});
        } else {
            this.menuManager.buildMenu((int)this.renderer.getCameraHelper().getMousePosition().x, (int)this.renderer.getCameraHelper().getMousePosition().y, iAgent, runnable, new MenuAction[0]);
        }
    }

    public void selectionIn(Envelope3D envelope3D) {
        Envelope3D envelope3D2 = Envelope3D.withYNegated((Envelope)envelope3D);
        Collection collection = this.scope.getTopology().getSpatialIndex().allInEnvelope((IScope)this.scope, (IShape)envelope3D2.centre(), (Envelope)envelope3D2, (IAgentFilter)new Different(), false);
        LinkedHashMap<String, Runnable> linkedHashMap = new LinkedHashMap<String, Runnable>();
        HashMap<String, org.eclipse.swt.graphics.Image> hashMap = new HashMap<String, org.eclipse.swt.graphics.Image>();
        hashMap.put(this.renderer.getCameraHelper().isStickyROI() ? "Hide region" : "Keep region visible", GamaIcon.named((String)"views/open.inspector").image());
        hashMap.put("Focus on region", GamaIcon.named((String)"display/zoom.fit").image());
        linkedHashMap.put(this.renderer.getCameraHelper().isStickyROI() ? "Hide region" : "Keep region visible", () -> this.renderer.getCameraHelper().toogleROI());
        linkedHashMap.put("Focus on region", () -> this.renderer.getCameraHelper().zoomFocus(envelope3D));
        WorkbenchHelper.run(() -> {
            Menu menu = this.menuManager.buildROIMenu((int)this.renderer.getCameraHelper().getMousePosition().x, (int)this.renderer.getCameraHelper().getMousePosition().y, collection, linkedHashMap, hashMap);
            menu.addMenuListener(new MenuListener(){

                public void menuHidden(MenuEvent menuEvent) {
                    SWTOpenGLDisplaySurface.this.animator.resume();
                    WorkbenchHelper.asyncRun(() -> SWTOpenGLDisplaySurface.this.renderer.getCameraHelper().cancelROI());
                }

                public void menuShown(MenuEvent menuEvent) {
                    SWTOpenGLDisplaySurface.this.animator.pause();
                }
            });
            menu.setVisible(true);
        });
    }

    protected void setDisplayScope(IScope.IGraphicsScope iGraphicsScope) {
        if (this.scope != null) {
            GAMA.releaseScope((IScope)this.scope);
        }
        this.scope = iGraphicsScope;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.layerManager != null) {
            this.layerManager.dispose();
        }
        if (this.animator != null && this.animator.isStarted()) {
            this.animator.stop();
        }
        this.menuManager = null;
        this.listeners.clear();
        this.renderer = null;
        GAMA.releaseScope((IScope)this.getScope());
        this.setDisplayScope(null);
    }

    public LayeredDisplayData getData() {
        return this.output.getData();
    }

    public void changed(LayeredDisplayData.Changes changes, Object object) {
        if (this.renderer == null) {
            return;
        }
        switch (changes) {
            case ZOOM: {
                this.renderer.getCameraHelper().zoom((Double)object);
                break;
            }
        }
    }

    public void setSize(int n, int n2) {
    }

    public void layersChanged() {
        this.renderer.getSceneHelper().layersChanged();
    }

    public void invalidateVisibleRegions() {
        for (ILayer iLayer : this.layerManager.getItems()) {
            iLayer.getData().setVisibleRegion(null);
        }
    }

    public int getFPS() {
        return Math.round(this.renderer.getCanvas().getLastFPS());
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Envelope3D getROIDimensions() {
        return this.renderer.getCameraHelper().getROIEnvelope();
    }

    public void dispatchKeyEvent(char c) {
        for (IEventLayerListener iEventLayerListener : this.listeners) {
            iEventLayerListener.keyPressed(String.valueOf(c));
        }
    }

    public void dispatchSpecialKeyEvent(int n) {
        DEBUG.OUT((Object)("Special key received by the surface " + n));
        for (IEventLayerListener iEventLayerListener : this.listeners) {
            iEventLayerListener.specialKeyPressed(n);
        }
    }

    public void dispatchMouseEvent(int n, int n2, int n3) {
        for (IEventLayerListener iEventLayerListener : this.listeners) {
            switch (n) {
                case 3: {
                    iEventLayerListener.mouseDown(n2, n3, 1);
                    break;
                }
                case 4: {
                    iEventLayerListener.mouseUp(n2, n3, 1);
                    break;
                }
                case 5: {
                    iEventLayerListener.mouseMove(n2, n3);
                    break;
                }
                case 29: {
                    iEventLayerListener.mouseDrag(n2, n3, 1);
                    break;
                }
                case 6: {
                    iEventLayerListener.mouseEnter(n2, n3);
                    break;
                }
                case 7: {
                    iEventLayerListener.mouseExit(n2, n3);
                    break;
                }
                case 35: {
                    iEventLayerListener.mouseMenu(n2, n3);
                }
            }
        }
    }

    public void setMousePosition(int n, int n2) {
        this.world_position = this.renderer.getCameraHelper().getWorldPositionFrom(new GamaPoint((double)n, (double)n2), new GamaPoint()).yNegated();
    }

    public void selectAgentsAroundMouse() {
    }

    public void draggedTo(int n, int n2) {
    }

    public boolean isVisible() {
        if (this.renderer == null) {
            return false;
        }
        return this.renderer.getCanvas().getVisibleStatus();
    }

    public IGraphics getIGraphics() {
        return this.renderer;
    }

    public Rectangle getBoundsForRobotSnapshot() {
        org.eclipse.swt.graphics.Rectangle rectangle = WorkbenchHelper.displaySizeOf((Control)this.renderer.getCanvas());
        if (PlatformHelper.isMac()) {
            rectangle = DPIHelper.autoScaleUp((Monitor)this.renderer.getCanvas().getMonitor(), (org.eclipse.swt.graphics.Rectangle)rectangle);
        }
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle getBoundsForRegularSnapshot() {
        org.eclipse.swt.graphics.Rectangle rectangle = WorkbenchHelper.displaySizeOf((Control)this.renderer.getCanvas());
        if (PlatformHelper.isMac() || PlatformHelper.isWindows()) {
            rectangle = DPIHelper.autoScaleUp((Monitor)this.renderer.getCanvas().getMonitor(), (org.eclipse.swt.graphics.Rectangle)rectangle);
        }
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

