/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.helpers;

import gama.core.common.interfaces.ILayer;
import gama.dev.DEBUG;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.renderer.helpers.AbstractRendererHelper;
import gama.ui.display.opengl.renderer.helpers.PickingHelper;
import gama.ui.display.opengl.scene.ModelScene;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SceneHelper
extends AbstractRendererHelper {
    volatile ModelScene backScene;
    volatile ModelScene staticScene;
    volatile ModelScene frontScene;
    private final Queue<ModelScene> garbage = new ConcurrentLinkedQueue<ModelScene>();

    static {
        DEBUG.ON();
    }

    public SceneHelper(IOpenGLRenderer iOpenGLRenderer) {
        super(iOpenGLRenderer);
    }

    @Override
    public void initialize() {
    }

    public void beginDrawingLayer(ILayer iLayer, Double d) {
        ModelScene modelScene = this.getSceneToUpdate();
        if (modelScene != null) {
            modelScene.beginDrawingLayer(iLayer, d);
        }
    }

    public boolean beginUpdatingScene() {
        if (this.backScene != null) {
            return false;
        }
        this.backScene = this.createSceneFrom(this.staticScene);
        this.backScene.beginDrawingLayers();
        return true;
    }

    public boolean isNotReadyToUpdate() {
        return this.frontScene != null && !this.frontScene.rendered();
    }

    public void endUpdatingScene() {
        if (this.backScene == null) {
            return;
        }
        this.backScene.endDrawingLayers();
        if (this.hasStructurallyChanged()) {
            this.discardStaticScene();
        }
        if (this.staticScene == null) {
            this.staticScene = this.createSceneFrom(this.backScene);
        }
        if (this.frontScene != null) {
            if (!this.frontScene.rendered()) {
                this.garbage.add(this.backScene);
                this.backScene = null;
                return;
            }
            this.garbage.add(this.frontScene);
        }
        this.frontScene = this.backScene;
        this.backScene = null;
    }

    private boolean hasStructurallyChanged() {
        return this.getSurface().getManager().hasStructurallyChanged();
    }

    protected ModelScene createSceneFrom(ModelScene modelScene) {
        ModelScene modelScene2 = modelScene == null ? new ModelScene(this.getRenderer(), true) : modelScene.copyStatic();
        return modelScene2;
    }

    public ModelScene getSceneToRender() {
        return this.frontScene;
    }

    public ModelScene getSceneToUpdate() {
        return this.backScene;
    }

    public void garbageCollect(OpenGL openGL) {
        int n = this.garbage.size();
        if (n == 0) {
            return;
        }
        ModelScene[] modelSceneArray = this.garbage.toArray(new ModelScene[n]);
        this.garbage.clear();
        ModelScene[] modelSceneArray2 = modelSceneArray;
        int n2 = modelSceneArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ModelScene modelScene = modelSceneArray2[n3];
            modelScene.wipe(openGL);
            modelScene.dispose();
            ++n3;
        }
    }

    public void dispose() {
        if (this.frontScene != null) {
            this.frontScene.dispose();
        }
        this.frontScene = null;
        if (this.backScene != null) {
            this.backScene.dispose();
        }
        this.backScene = null;
        if (this.staticScene != null) {
            this.staticScene.dispose();
        }
        this.staticScene = null;
    }

    public void layersChanged() {
        this.discardStaticScene();
        if (this.backScene != null) {
            this.garbage.add(this.backScene);
            this.backScene = null;
        }
    }

    protected void discardStaticScene() {
        if (this.staticScene != null) {
            this.garbage.add(this.staticScene);
            this.staticScene = null;
        }
    }

    public void draw() {
        OpenGL openGL = this.getOpenGL();
        this.garbageCollect(openGL);
        PickingHelper pickingHelper = this.getRenderer().getPickingHelper();
        if (pickingHelper.isBeginningPicking()) {
            pickingHelper.beginPicking();
            this.getSceneToRender().draw(openGL);
            pickingHelper.endPicking();
        }
        this.getSceneToRender().draw(openGL);
    }

    public boolean isReady() {
        return this.getSceneToRender() != null;
    }
}

