/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene;

import gama.core.common.interfaces.IDisposable;
import gama.core.common.interfaces.IImageProvider;
import gama.core.metamodel.shape.GamaPoint;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.ui.display.opengl.OpenGL;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public abstract class AbstractObject<T, ATT extends DrawingAttributes>
implements IDisposable {
    private final ATT attributes;
    protected final int[] textures;
    protected final T object;
    public final DrawingAttributes.DrawerType type;

    public AbstractObject(T t, ATT ATT, DrawingAttributes.DrawerType drawerType) {
        this.object = t;
        this.type = drawerType;
        this.attributes = ATT;
        if (ATT.getTextures() != null) {
            this.textures = new int[ATT.getTextures().size()];
            Arrays.fill(this.textures, Integer.MAX_VALUE);
        } else {
            this.textures = null;
        }
    }

    public void dispose() {
    }

    public T getObject() {
        return this.object;
    }

    public int getAlternateTexture(OpenGL openGL) {
        return this.getTexture(openGL, 1);
    }

    public int getPrimaryTexture(OpenGL openGL) {
        return this.getTexture(openGL, 0);
    }

    private int getTexture(OpenGL openGL, int n) {
        if (this.textures == null || n < 0 || n > this.textures.length - 1) {
            return Integer.MAX_VALUE;
        }
        if (this.isAnimated() || this.textures[n] == Integer.MAX_VALUE) {
            Object var3_3 = null;
            try {
                var3_3 = this.getAttributes().getTextures().get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            if (var3_3 instanceof IImageProvider) {
                IImageProvider iImageProvider = var3_3;
                ATT ATT = this.getAttributes();
                this.textures[n] = openGL.getTextureId(iImageProvider, ATT.useCache());
            } else if (var3_3 instanceof BufferedImage) {
                BufferedImage bufferedImage = var3_3;
                this.textures[n] = openGL.getTextureId(bufferedImage);
            }
        }
        return this.textures[n];
    }

    protected boolean isAnimated() {
        return this.getAttributes().isAnimated();
    }

    public boolean isTextured() {
        return this.textures != null && this.textures.length > 0;
    }

    public boolean isFilled() {
        return !this.getAttributes().isEmpty();
    }

    public ATT getAttributes() {
        return this.attributes;
    }

    public void getTranslationInto(GamaPoint gamaPoint) {
        GamaPoint gamaPoint2 = this.getAttributes().getLocation();
        if (gamaPoint2 == null) {
            gamaPoint.setLocation(0.0, 0.0, 0.0);
        } else {
            gamaPoint.setLocation(gamaPoint2);
        }
    }

    public void getTranslationForRotationInto(GamaPoint gamaPoint) {
        this.getTranslationInto(gamaPoint);
    }

    public void getTranslationForScalingInto(GamaPoint gamaPoint) {
        gamaPoint.setLocation(0.0, 0.0, 0.0);
    }

    public boolean isBordered() {
        return this.getAttributes().getBorder() != null;
    }
}

