/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.caches;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.file.GamaGeometryFile;
import gama.core.util.file.GamaObjFile;
import gama.dev.DEBUG;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.files.ObjFileDrawer;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.locationtech.jts.geom.Geometry;

public class GeometryCache {
    private static final double PI_2 = Math.PI * 2;
    static double[] roundRect;
    static DoubleBuffer db;
    private final Cache<IShape.Type, BuiltInGeometry> builtInCache;
    private final LoadingCache<String, Integer> fileCache;
    private final Map<String, GamaGeometryFile> fileMap = new ConcurrentHashMap<String, GamaGeometryFile>();
    private final Map<String, GamaGeometryFile> geometriesToProcess = new ConcurrentHashMap<String, GamaGeometryFile>();
    private final Cache<String, Envelope3D> envelopes;
    private final IScope scope;
    private final Consumer<Geometry> drawer;

    static {
        DEBUG.OFF();
        roundRect = new double[]{0.92, 0.0, 0.933892, 0.001215, 0.947362, 0.004825, 0.96, 0.010718, 0.971423, 0.018716, 0.981284, 0.028577, 0.989282, 0.04, 0.995175, 0.052638, 0.998785, 0.066108, 1.0, 0.08, 1.0, 0.92, 0.998785, 0.933892, 0.995175, 0.947362, 0.989282, 0.96, 0.981284, 0.971423, 0.971423, 0.981284, 0.96, 0.989282, 0.947362, 0.995175, 0.933892, 0.998785, 0.92, 1.0, 0.08, 1.0, 0.066108, 0.998785, 0.052638, 0.995175, 0.04, 0.989282, 0.028577, 0.981284, 0.018716, 0.971423, 0.010718, 0.96, 0.004825, 0.947362, 0.001215, 0.933892, 0.0, 0.92, 0.0, 0.08, 0.001215, 0.066108, 0.004825, 0.052638, 0.010718, 0.04, 0.018716, 0.028577, 0.028577, 0.018716, 0.04, 0.010718, 0.052638, 0.004825, 0.066108, 0.001215, 0.08, 0.0};
        db = Buffers.newDirectDoubleBuffer((int)roundRect.length).put(roundRect).rewind();
    }

    public GeometryCache(final IOpenGLRenderer iOpenGLRenderer) {
        this.scope = iOpenGLRenderer.getSurface().getScope().copy("in opengl geometry cache");
        this.drawer = geometry -> iOpenGLRenderer.getOpenGLHelper().getGeometryDrawer().drawGeometry((Geometry)geometry, null, 0.0, GeometryUtils.getTypeOf((Geometry)geometry));
        this.envelopes = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
        this.builtInCache = CacheBuilder.newBuilder().concurrencyLevel(2).initialCapacity(10).build();
        this.fileCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).initialCapacity(10).removalListener(removalNotification -> {
            if (iOpenGLRenderer.isDisposed()) {
                return;
            }
            iOpenGLRenderer.getOpenGLHelper().getGL().glDeleteLists(((Integer)removalNotification.getValue()).intValue(), 1);
        }).build((CacheLoader)new CacheLoader<String, Integer>(){

            public Integer load(String string) {
                return GeometryCache.this.buildList(iOpenGLRenderer.getOpenGLHelper(), string);
            }
        });
    }

    public Integer get(GamaGeometryFile gamaGeometryFile) {
        return (Integer)this.fileCache.getUnchecked((Object)gamaGeometryFile.getPath(this.scope));
    }

    public BuiltInGeometry get(IShape.Type type) {
        return (BuiltInGeometry)this.builtInCache.getIfPresent((Object)type);
    }

    Integer buildList(OpenGL openGL, String string) {
        DEBUG.OUT((Object)("Bulding OpenGL list for " + string));
        GamaGeometryFile gamaGeometryFile = this.fileMap.get(string);
        return openGL.compileAsList(() -> {
            if (gamaGeometryFile instanceof GamaObjFile) {
                GamaObjFile gamaObjFile = (GamaObjFile)gamaGeometryFile;
                gamaObjFile.loadObject(this.scope, true);
                ObjFileDrawer.drawToOpenGL(gamaObjFile, openGL);
            } else {
                IShape iShape = gamaGeometryFile.getGeometry(this.scope);
                if (iShape == null) {
                    return;
                }
                try {
                    this.drawSimpleGeometry(openGL, iShape.getInnerGeometry());
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        });
    }

    void drawSimpleGeometry(OpenGL openGL, Geometry geometry2) throws ExecutionException {
        geometry2.apply(geometry -> this.drawer.accept(geometry));
    }

    public void dispose() {
        this.fileMap.clear();
        GAMA.releaseScope((IScope)this.scope);
    }

    public void processUnloaded() {
        for (GamaGeometryFile gamaGeometryFile : this.geometriesToProcess.values()) {
            this.get(gamaGeometryFile);
        }
        this.geometriesToProcess.clear();
    }

    public void process(GamaGeometryFile gamaGeometryFile) {
        if (gamaGeometryFile == null) {
            return;
        }
        String string = gamaGeometryFile.getPath(this.scope);
        if (this.fileCache.getIfPresent((Object)string) != null) {
            return;
        }
        this.fileMap.putIfAbsent(string, gamaGeometryFile);
        if (!this.geometriesToProcess.containsKey(string)) {
            this.geometriesToProcess.put(string, gamaGeometryFile);
        }
    }

    public Envelope3D getEnvelope(GamaGeometryFile gamaGeometryFile) {
        try {
            return (Envelope3D)this.envelopes.get((Object)gamaGeometryFile.getPath(this.scope), () -> gamaGeometryFile.computeEnvelope(this.scope));
        }
        catch (ExecutionException executionException) {
            return Envelope3D.EMPTY;
        }
    }

    public void put(IShape.Type type, BuiltInGeometry builtInGeometry) {
        this.builtInCache.put((Object)type, (Object)builtInGeometry);
    }

    public void initialize(OpenGL openGL) {
        int n;
        int n2 = n = ((Integer)GamaPreferences.Displays.DISPLAY_SLICE_NUMBER.getValue()).intValue();
        this.put(IShape.Type.SPHERE, BuiltInGeometry.assemble().faces(openGL.compileAsList(() -> {
            openGL.translateBy(0.0, 0.0, 1.0);
            this.drawSphere(openGL, 1.0, n, n2);
            openGL.translateBy(0.0, 0.0, -1.0);
        })));
        this.put(IShape.Type.CYLINDER, BuiltInGeometry.assemble().bottom(openGL.compileAsList(() -> this.drawDisk(openGL, 0.0, 1.0, n, n / 3))).top(openGL.compileAsList(() -> {
            openGL.translateBy(0.0, 0.0, 1.0);
            this.drawDisk(openGL, 0.0, 1.0, n, n / 3);
            openGL.translateBy(0.0, 0.0, -1.0);
        })).faces(openGL.compileAsList(() -> this.drawCylinder(openGL, 1.0, 1.0, 1.0, n, n2))));
        this.put(IShape.Type.CONE, BuiltInGeometry.assemble().bottom(openGL.compileAsList(() -> this.drawDisk(openGL, 0.0, 1.0, n, n / 3))).faces(openGL.compileAsList(() -> this.drawCylinder(openGL, 1.0, 0.0, 1.0, n, n2))));
        ICoordinates iCoordinates = ICoordinates.ofLength((int)5);
        ICoordinates iCoordinates2 = ICoordinates.ofLength((int)5);
        iCoordinates.setTo(new double[]{-0.5, 0.5, 0.0, 0.5, 0.5, 0.0, 0.5, -0.5, 0.0, -0.5, -0.5, 0.0, -0.5, 0.5, 0.0});
        this.put(IShape.Type.CUBE, BuiltInGeometry.assemble().bottom(openGL.compileAsList(() -> openGL.drawSimpleShape(iCoordinates, 4, false, true, null))).top(openGL.compileAsList(() -> {
            iCoordinates.translateBy(0.0, 0.0, 1.0);
            openGL.drawSimpleShape(iCoordinates, 4, true, true, null);
            iCoordinates.translateBy(0.0, 0.0, -1.0);
        })).faces(openGL.compileAsList(() -> iCoordinates.visit((gamaPoint, gamaPoint2) -> {
            iCoordinates2.setTo(new double[]{gamaPoint2.x, gamaPoint2.y, gamaPoint2.z, gamaPoint2.x, gamaPoint2.y, gamaPoint2.z + 1.0, gamaPoint.x, gamaPoint.y, gamaPoint.z + 1.0, gamaPoint.x, gamaPoint.y, gamaPoint.z, gamaPoint2.x, gamaPoint2.y, gamaPoint2.z});
            openGL.drawSimpleShape(iCoordinates2, 4, true, true, null);
        }))));
        this.put(IShape.Type.POINT, BuiltInGeometry.assemble().faces(openGL.compileAsList(() -> this.drawSphere(openGL, 1.0, 5, 5))));
        this.put(IShape.Type.ROUNDED, BuiltInGeometry.assemble().bottom(openGL.compileAsList(() -> {
            openGL.translateBy(-0.5, -0.5);
            this.drawRoundedRectangle(openGL.getGL());
            openGL.translateBy(0.5, 0.5);
        })));
        this.put(IShape.Type.SQUARE, BuiltInGeometry.assemble().bottom(openGL.compileAsList(() -> openGL.drawSimpleShape(iCoordinates, 4, true, true, null))));
        this.put(IShape.Type.CIRCLE, BuiltInGeometry.assemble().bottom(openGL.compileAsList(() -> this.drawDisk(openGL, 0.0, 1.0, n, 1))));
        ICoordinates iCoordinates3 = ICoordinates.ofLength((int)4);
        ICoordinates iCoordinates4 = ICoordinates.ofLength((int)5);
        iCoordinates4.setTo(new double[]{-0.5, -0.5, 0.0, -0.5, 0.5, 0.0, 0.5, 0.5, 0.0, 0.5, -0.5, 0.0, -0.5, -0.5, 0.0});
        this.put(IShape.Type.PYRAMID, BuiltInGeometry.assemble().bottom(openGL.compileAsList(() -> openGL.drawSimpleShape(iCoordinates4, 4, false, true, null))).faces(openGL.compileAsList(() -> {
            GamaPoint gamaPoint = new GamaPoint(0.0, 0.0, 1.0);
            iCoordinates4.visit((gamaPoint2, gamaPoint3) -> {
                iCoordinates3.setTo(new double[]{gamaPoint2.x, gamaPoint2.y, gamaPoint2.z, gamaPoint.x, gamaPoint.y, gamaPoint.z, gamaPoint3.x, gamaPoint3.y, gamaPoint3.z, gamaPoint2.x, gamaPoint2.y, gamaPoint2.z});
                openGL.drawSimpleShape(iCoordinates3, 3, true, true, null);
            });
        })));
    }

    public void drawRoundedRectangle(GL2 gL2) {
        gL2.glEnableClientState(32884);
        gL2.glVertexPointer(2, 5130, 0, (Buffer)db);
        gL2.glDrawArrays(6, 0, 40);
        gL2.glDisableClientState(32884);
    }

    public void drawDisk(OpenGL openGL, double d, double d2, int n, int n2) {
        openGL.outputNormal(0.0, 0.0, 1.0);
        double d3 = Math.PI * 2 / (double)n;
        double d4 = (d2 - d) / (double)n2;
        double d5 = 2.0 * d2;
        double d6 = d;
        openGL.getGL().glFrontFace(2305);
        int n3 = 0;
        while (n3 < n2) {
            double d7 = d6 + d4;
            openGL.beginDrawing(8);
            int n4 = 0;
            while (n4 <= n) {
                double d8 = n4 == n ? 0.0 : (double)n4 * d3;
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                openGL.outputTexCoord(0.5 + d9 * d7 / d5, 0.5 + d10 * d7 / d5);
                openGL.outputVertex(d7 * d9, d7 * d10, 0.0);
                openGL.outputTexCoord(0.5 + d9 * d6 / d5, 0.5 + d10 * d6 / d5);
                openGL.outputVertex(d6 * d9, d6 * d10, 0.0);
                ++n4;
            }
            openGL.endDrawing();
            d6 = d7;
            ++n3;
        }
        openGL.getGL().glFrontFace(2304);
    }

    public void drawSphere(OpenGL openGL, double d, int n, int n2) {
        double d2 = Math.PI / (double)n2;
        double d3 = Math.PI * 2 / (double)n;
        double d4 = 1.0f / (float)n;
        double d5 = 1.0f / (float)n2;
        double d6 = 1.0;
        int n3 = 0;
        int n4 = n2;
        openGL.getGL().glFrontFace(2305);
        int n5 = n3;
        while (n5 < n4) {
            double d7 = (double)n5 * d2;
            openGL.beginDrawing(8);
            double d8 = 0.0;
            int n6 = 0;
            while (n6 <= n) {
                double d9 = n6 == n ? 0.0 : (double)n6 * d3;
                double d10 = -Math.sin(d9) * Math.sin(d7);
                double d11 = Math.cos(d9) * Math.sin(d7);
                double d12 = Math.cos(d7);
                openGL.outputNormal(d10, d11, d12);
                openGL.outputTexCoord(d8, d6);
                openGL.outputVertex(d10 * d, d11 * d, d12 * d);
                d10 = -Math.sin(d9) * Math.sin(d7 + d2);
                d11 = Math.cos(d9) * Math.sin(d7 + d2);
                d12 = Math.cos(d7 + d2);
                openGL.outputNormal(d10, d11, d12);
                openGL.outputTexCoord(d8, d6 - d5);
                d8 += d4;
                openGL.outputVertex(d10 * d, d11 * d, d12 * d);
                ++n6;
            }
            openGL.endDrawing();
            d6 -= d5;
            ++n5;
        }
        openGL.getGL().glFrontFace(2304);
    }

    public void drawCylinder(OpenGL openGL, double d, double d2, double d3, int n, int n2) {
        double d4 = Math.PI * 2 / (double)n;
        double d5 = (d2 - d) / (double)n2;
        double d6 = d3 / (double)n2;
        double d7 = (d - d2) / d3;
        double d8 = 1.0f / (float)n;
        double d9 = 1.0f / (float)n2;
        float f = 0.0f;
        double d10 = 0.0;
        double d11 = d;
        openGL.getGL().glFrontFace(2305);
        int n3 = 0;
        while (n3 < n2) {
            float f2 = 0.0f;
            openGL.beginDrawing(8);
            int n4 = 0;
            while (n4 <= n) {
                double d12;
                double d13;
                if (n4 == n) {
                    d13 = 0.0;
                    d12 = 1.0;
                } else {
                    d13 = Math.sin((double)n4 * d4);
                    d12 = Math.cos((double)n4 * d4);
                }
                openGL.outputNormal(d13, d12, d7);
                openGL.outputTexCoord(f2, f);
                openGL.outputVertex(d13 * d11, d12 * d11, d10);
                openGL.outputNormal(d13, d12, d7);
                openGL.outputTexCoord(f2, (double)f + d9);
                openGL.outputVertex(d13 * (d11 + d5), d12 * (d11 + d5), d10 + d6);
                f2 = (float)((double)f2 + d8);
                ++n4;
            }
            openGL.endDrawing();
            d11 += d5;
            f = (float)((double)f + d9);
            d10 += d6;
            ++n3;
        }
        openGL.getGL().glFrontFace(2304);
    }

    public static class BuiltInGeometry {
        Integer bottom;
        Integer top;
        Integer faces;

        public static BuiltInGeometry assemble() {
            return new BuiltInGeometry(null, null, null);
        }

        public BuiltInGeometry top(Integer n) {
            this.top = n;
            return this;
        }

        public BuiltInGeometry faces(Integer n) {
            this.faces = n;
            return this;
        }

        public BuiltInGeometry bottom(Integer n) {
            this.bottom = n;
            return this;
        }

        private BuiltInGeometry(Integer n, Integer n2, Integer n3) {
            this.bottom = n;
            this.top = n2;
            this.faces = n3;
        }

        public void draw(OpenGL openGL) {
            if (this.bottom != null) {
                openGL.drawList(this.bottom);
            }
            if (this.top != null) {
                openGL.drawList(this.top);
            }
            openGL.enableAlternateTexture();
            if (this.faces != null) {
                openGL.drawList(this.faces);
            }
        }
    }
}

