/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.geometry;

import com.jogamp.opengl.util.gl2.GLUT;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GamaGeometryFactory;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Rotation3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.geometry.UnboundedCoordinateSequence;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaColor;
import gama.gaml.types.GamaGeometryType;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.scene.ObjectDrawer;
import gama.ui.display.opengl.scene.geometry.GeometryObject;
import java.awt.Color;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class GeometryDrawer
extends ObjectDrawer<GeometryObject> {
    private static final GamaColor DEFAULT_BORDER = GamaColor.get((Color)Color.black);
    final GamaPoint _normal = new GamaPoint();
    final GamaPoint _center = new GamaPoint();
    final GamaPoint _tangent = new GamaPoint();
    final Rotation3D _rot = Rotation3D.identity();
    final Scaling3D.Heterogeneous _scale = new Scaling3D.Heterogeneous(1.0, 1.0, 1.0);
    final ICoordinates _quadvertices = GamaGeometryFactory.COORDINATES_FACTORY.create(5, 3);
    final UnboundedCoordinateSequence _vertices = new UnboundedCoordinateSequence();

    public GeometryDrawer(OpenGL openGL) {
        super(openGL);
    }

    @Override
    protected final void _draw(GeometryObject geometryObject) {
        this.gl.pushMatrix();
        try {
            this.applyRotation(geometryObject);
            this.applyTranslation(geometryObject);
            this.applyScaling(geometryObject);
            GamaColor gamaColor = !geometryObject.isFilled() && geometryObject.getAttributes().getBorder() == null ? geometryObject.getAttributes().getColor() : geometryObject.getAttributes().getBorder();
            Geometry geometry = (Geometry)geometryObject.getObject();
            Double d = geometryObject.getAttributes().getDepth();
            double d2 = d == null ? 0.0 : d;
            IShape.Type type = geometryObject.getAttributes().getType();
            this.drawGeometry(geometry, (Color)gamaColor, d2, type);
        }
        finally {
            this.gl.popMatrix();
        }
    }

    public void drawGeometry(Geometry geometry2, Color color, double d, IShape.Type type) {
        switch (type) {
            case SPHERE: {
                this.drawSphere(geometry2, d, color);
                break;
            }
            case CONE: {
                this.drawCone3D(geometry2, d, color);
                break;
            }
            case TEAPOT: {
                this.drawTeapot(geometry2, d, color);
                break;
            }
            case PYRAMID: {
                this.drawPyramid(geometry2, d, color);
                break;
            }
            case CYLINDER: {
                this.drawCylinder(geometry2, d, color);
                break;
            }
            case LINECYLINDER: {
                this.drawLineCylinder(geometry2, d, color);
                break;
            }
            case BOX: 
            case CUBE: {
                this.drawCube(geometry2, d, color);
                break;
            }
            case CIRCLE: 
            case SQUARE: 
            case GRIDLINE: 
            case POLYGON: 
            case POLYHEDRON: {
                if (!(geometry2 instanceof Polygon)) break;
                if (d != 0.0) {
                    this.drawPolyhedron((Polygon)geometry2, d, color);
                    break;
                }
                this.drawPolygon((Polygon)geometry2, color, true, true);
                break;
            }
            case LINESTRING: {
                if (d != 0.0) {
                    this.drawPlan(geometry2, d, color);
                    break;
                }
            }
            case LINEARRING: 
            case PLAN: 
            case POLYPLAN: {
                this.drawPlan(geometry2, d, color);
                break;
            }
            case POINT: {
                this.drawPoint(geometry2, this.gl.getMaxEnvDim() / 800.0, color);
                break;
            }
            default: {
                GeometryUtils.applyToInnerGeometries((Geometry)geometry2, geometry -> this.drawGeometry(geometry, color, d, GeometryUtils.getTypeOf((Geometry)geometry)));
            }
        }
    }

    private void drawPolyhedron(Polygon polygon, double d, Color color) {
        this.drawPolygon(polygon, color, true, true);
        this._vertices.getNormal(true, d, this._normal);
        try {
            this.gl.pushMatrix();
            this.gl.translateBy(this._normal.x, this._normal.y, this._normal.z);
            this.drawPolygon(polygon, color, true, false);
        }
        finally {
            this.gl.popMatrix();
        }
        this.gl.enableAlternateTexture();
        this._vertices.visit((gamaPoint, gamaPoint2) -> {
            this._quadvertices.setTo(new double[]{gamaPoint2.x, gamaPoint2.y, gamaPoint2.z, gamaPoint2.x + this._normal.x, gamaPoint2.y + this._normal.y, gamaPoint2.z + this._normal.z, gamaPoint.x + this._normal.x, gamaPoint.y + this._normal.y, gamaPoint.z + this._normal.z, gamaPoint.x, gamaPoint.y, gamaPoint.z, gamaPoint2.x, gamaPoint2.y, gamaPoint2.z});
            this.gl.drawSimpleShape(this._quadvertices, 4, true, true, color);
        });
    }

    private void drawPolygon(Polygon polygon, Color color, boolean bl, boolean bl2) {
        if (bl2) {
            this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Polygon)polygon));
        }
        if (!this.gl.isWireframe()) {
            this.gl.setNormal((ICoordinates)this._vertices, bl);
            boolean bl3 = GeometryUtils.getHolesNumber((Geometry)polygon) > 0;
            int n = this._vertices.size();
            if (bl3 || n > 5) {
                this.gl.drawPolygon(polygon, (ICoordinates)this._vertices, bl);
            } else {
                this.gl.drawSimpleShape((ICoordinates)this._vertices, n - 1, bl, false, null);
            }
        }
        if (color != null || this.gl.isWireframe()) {
            Color color2 = color != null ? color : this.gl.getCurrentColor();
            this.gl.drawClosedLine((ICoordinates)this._vertices, color2, -1);
            GeometryUtils.applyToInnerGeometries((Polygon)polygon, geometry -> this.gl.drawClosedLine(GeometryUtils.getYNegatedCoordinates((Geometry)geometry), color2, -1));
        }
    }

    private void drawPlan(Geometry geometry, double d, Color color) {
        this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Geometry)geometry));
        if (d != 0.0) {
            this._vertices.visit((gamaPoint, gamaPoint2) -> {
                this._quadvertices.setTo(new double[]{gamaPoint2.x, gamaPoint2.y, gamaPoint2.z, gamaPoint2.x, gamaPoint2.y, gamaPoint2.z + d, gamaPoint.x, gamaPoint.y, gamaPoint.z + d, gamaPoint.x, gamaPoint.y, gamaPoint.z, gamaPoint2.x, gamaPoint2.y, gamaPoint2.z});
                this.gl.drawSimpleShape(this._quadvertices, 4, true, true, color);
            });
        } else {
            this.gl.drawLine((ICoordinates)this._vertices, -1);
        }
    }

    private void drawCachedGeometry(IShape.Type type, Color color) {
        this.gl.pushMatrix();
        this.gl.translateBy(this._center);
        this.gl.rotateBy(this._rot.rotateToHorizontal(this._normal, this._tangent, false).revertInPlace());
        this.gl.scaleBy((Scaling3D)this._scale);
        this.gl.drawCachedGeometry(type, color);
        this.gl.popMatrix();
    }

    private void drawPoint(Geometry geometry, double d, Color color) {
        this._center.setCoordinate(geometry.getCoordinate());
        this._center.y *= -1.0;
        this._scale.setTo(d);
        this._rot.setToIdentity();
        this.drawCachedGeometry(IShape.Type.POINT, color);
    }

    private void drawCube(Geometry geometry, double d, Color color) {
        this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Geometry)geometry));
        this._vertices.getNormal(true, 1.0, this._normal);
        this._vertices.getCenter(this._center);
        this._tangent.setLocation(this._vertices.at(0)).subtract(this._vertices.at(1));
        this._scale.setTo(this._tangent.norm(), this._vertices.at(2).euclidianDistanceTo(this._vertices.at(1)), d);
        this.drawCachedGeometry(IShape.Type.CUBE, color);
    }

    private void drawPyramid(Geometry geometry, double d, Color color) {
        this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Geometry)geometry));
        this._vertices.getNormal(true, 1.0, this._normal);
        this._vertices.getCenter(this._center);
        this._tangent.setLocation(this._vertices.at(0)).subtract(this._vertices.at(1));
        this._scale.setTo(d);
        this.drawCachedGeometry(IShape.Type.PYRAMID, color);
    }

    private void drawSphere(Geometry geometry, double d, Color color) {
        this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Geometry)geometry));
        this._vertices.getNormal(true, 1.0, this._normal);
        this._vertices.getCenter(this._center);
        this._tangent.setLocation(this._center).subtract(this._vertices.at(0));
        this._scale.setTo(d);
        this.drawCachedGeometry(IShape.Type.SPHERE, color);
    }

    private void drawCylinder(Geometry geometry, double d, Color color) {
        this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Geometry)geometry));
        double d2 = geometry instanceof Polygon ? this._vertices.getLength() / (Math.PI * 2) : d;
        this._vertices.getCenter(this._center);
        this._vertices.getNormal(true, 1.0, this._normal);
        this._tangent.setLocation(this._center).subtract(this._vertices.at(0));
        this._scale.setTo(d2, d2, d);
        this.drawCachedGeometry(IShape.Type.CYLINDER, color);
    }

    private void drawLineCylinder(Geometry geometry, double d, Color color) {
        this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Geometry)geometry));
        int n = 0;
        int n2 = this._vertices.size();
        while (n < n2 - 1) {
            GamaPoint gamaPoint = this._vertices.at(n);
            GamaPoint gamaPoint2 = this._vertices.at(n + 1);
            this._center.setLocation(gamaPoint);
            this._normal.setLocation(gamaPoint2).subtract(gamaPoint);
            double d2 = this._normal.norm();
            this._tangent.setLocation(this._normal.orthogonal());
            this._normal.normalize();
            this._scale.setTo(d, d, d2);
            this.drawCachedGeometry(IShape.Type.CYLINDER, color);
            ++n;
        }
    }

    private void drawCone3D(Geometry geometry, double d, Color color) {
        this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Geometry)geometry));
        double d2 = geometry instanceof Polygon ? this._vertices.getLength() / (Math.PI * 2) : this._vertices.getLength();
        this._vertices.getCenter(this._center);
        this._vertices.getNormal(true, 1.0, this._normal);
        this._tangent.setLocation(this._center).subtract(this._vertices.at(0));
        this._scale.setTo(d2, d2, d);
        this.drawCachedGeometry(IShape.Type.CONE, color);
    }

    private void drawTeapot(Geometry geometry, double d, Color color) {
        this._vertices.setToYNegated(GeometryUtils.getContourCoordinates((Geometry)geometry));
        try {
            this.gl.pushMatrix();
            this._vertices.getCenter(this._center);
            this.gl.translateBy(this._center);
            this.gl.rotateBy(90.0, 1.0, 0.0, 0.0);
            GLUT gLUT = this.gl.getGlut();
            if (!this.gl.isWireframe()) {
                gLUT.glutSolidTeapot(d);
                if (color != null) {
                    this.gl.setCurrentColor(color);
                    gLUT.glutWireTeapot(d);
                }
            } else {
                gLUT.glutWireTeapot(d);
            }
        }
        finally {
            this.gl.popMatrix();
        }
    }

    public void drawROIHelper(Envelope3D envelope3D) {
        if (envelope3D == null) {
            return;
        }
        Polygon polygon = envelope3D.yNegated().toGeometry();
        this.gl.setCurrentColor(0.0, 0.5, 0.0, 0.15);
        this.gl.setZIncrement(0.0);
        boolean bl = this.gl.setObjectWireframe(false);
        boolean bl2 = this.gl.setObjectLighting(false);
        try {
            this.drawPolyhedron(polygon, envelope3D.getMaxZ(), (Color)DEFAULT_BORDER);
        }
        finally {
            this.gl.setObjectWireframe(bl);
            this.gl.setObjectLighting(bl2);
        }
    }

    public void drawRotationHelper(GamaPoint gamaPoint, double d, double d2) {
        this.gl.setZIncrement(0.0);
        this.gl.setCurrentColor(Color.gray, 0.3);
        GamaPoint gamaPoint2 = gamaPoint.yNegated().add(0.0, 0.0, -d2);
        Geometry geometry = GamaGeometryType.buildCircle((double)d2, (GamaPoint)gamaPoint2).getInnerGeometry();
        boolean bl = this.gl.setObjectWireframe(false);
        boolean bl2 = this.gl.setObjectLighting(false);
        try {
            this.drawSphere(geometry, d2, (Color)DEFAULT_BORDER);
        }
        finally {
            this.gl.setObjectWireframe(bl);
            this.gl.setObjectLighting(bl2);
        }
    }

    @Override
    public void dispose() {
    }
}

