/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.view;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IDisposable;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.ui.experiment.views.displays.LayeredDisplayDecorator;
import gama.ui.experiment.views.displays.LayeredDisplayMultiListener;
import java.util.function.Supplier;

public class NEWTLayeredDisplayMultiListener
implements MouseListener,
KeyListener,
WindowListener,
IDisposable {
    final LayeredDisplayMultiListener delegate;
    final Window control;
    final Supplier<Boolean> ok;

    static {
        DEBUG.OFF();
    }

    public NEWTLayeredDisplayMultiListener(LayeredDisplayDecorator layeredDisplayDecorator, IDisplaySurface iDisplaySurface, Window window) {
        this.delegate = new LayeredDisplayMultiListener(iDisplaySurface, layeredDisplayDecorator);
        this.control = window;
        this.ok = () -> {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = layeredDisplayDecorator.view != null && !layeredDisplayDecorator.view.disposed;
            if (!bl2) {
                return false;
            }
            boolean bl4 = bl = this.control != null;
            if (!bl) {
                return false;
            }
            if (iDisplaySurface != null && !iDisplaySurface.isDisposed()) {
                return true;
            }
            return false;
        };
        this.control.addKeyListener((KeyListener)this);
        this.control.addMouseListener((MouseListener)this);
        this.control.addWindowListener((WindowListener)this);
    }

    public void dispose() {
        this.control.removeKeyListener((KeyListener)this);
        this.control.removeMouseListener((MouseListener)this);
        this.control.removeWindowListener((WindowListener)this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        DEBUG.OUT((Object)("Key pressed in Newt listener: " + String.valueOf(keyEvent)));
        if (!this.ok.get().booleanValue()) {
            return;
        }
        if (keyEvent.isPrintableKey()) {
            this.delegate.keyPressed(keyEvent.getKeyChar(), PlatformHelper.isMac() ? keyEvent.isMetaDown() : keyEvent.isControlDown());
        } else if (keyEvent.getModifiers() == 0 || keyEvent.isAutoRepeat() && !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isShiftDown() && !keyEvent.isMetaDown()) {
            this.delegate.specialKeyPressed(switch (keyEvent.getKeyCode()) {
                case 150 -> 12;
                case 152 -> 13;
                case 149 -> 10;
                case 151 -> 11;
                case 16 -> 16;
                case 11 -> 17;
                case 27 -> 15;
                case 13 -> 18;
                case 9 -> 14;
                case 15 -> 22;
                case 18 -> 21;
                case 17 -> 19;
                case 155 -> 20;
                default -> 0;
            });
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isAutoRepeat()) {
            return;
        }
        DEBUG.OUT((Object)("Key released in Newt listener: " + String.valueOf(keyEvent)));
        if (!this.ok.get().booleanValue()) {
            return;
        }
        if (keyEvent.isPrintableKey()) {
            this.delegate.keyReleased(keyEvent.getKeyChar(), PlatformHelper.isMac() ? keyEvent.isMetaDown() : keyEvent.isControlDown());
        } else if (keyEvent.getModifiers() == 0 || keyEvent.isAutoRepeat() && !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isShiftDown() && !keyEvent.isMetaDown()) {
            this.delegate.specialKeyReleased(switch (keyEvent.getKeyCode()) {
                case 150 -> 12;
                case 152 -> 13;
                case 149 -> 10;
                case 151 -> 11;
                case 16 -> 16;
                case 11 -> 17;
                case 27 -> 15;
                case 13 -> 18;
                case 9 -> 14;
                default -> 0;
            });
        }
    }

    private boolean hasModifiers(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown() || mouseEvent.isAltGraphDown() || mouseEvent.isControlDown() || mouseEvent.isMetaDown() || mouseEvent.isShiftDown();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.delegate.mouseEnter(mouseEvent.getX(), mouseEvent.getY(), this.hasModifiers(mouseEvent), (int)mouseEvent.getButton());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.delegate.mouseExit(mouseEvent.getX(), mouseEvent.getY(), this.hasModifiers(mouseEvent), (int)mouseEvent.getButton());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.delegate.mouseMove(mouseEvent.getX(), mouseEvent.getY(), this.hasModifiers(mouseEvent));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        if (mouseEvent.getButton() == 3 || mouseEvent.isControlDown()) {
            this.delegate.menuDetected(mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.delegate.mouseDown(mouseEvent.getX(), mouseEvent.getY(), (int)mouseEvent.getButton(), this.hasModifiers(mouseEvent));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.delegate.mouseUp(mouseEvent.getX(), mouseEvent.getY(), (int)mouseEvent.getButton(), this.hasModifiers(mouseEvent));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.delegate.dragDetected(mouseEvent.getX(), mouseEvent.getY());
    }

    public void windowResized(WindowEvent windowEvent) {
    }

    public void windowMoved(WindowEvent windowEvent) {
    }

    public void windowDestroyNotify(WindowEvent windowEvent) {
    }

    public void windowDestroyed(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.delegate.focusGained();
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.delegate.focusLost();
    }

    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
    }

    public void mouseWheelMoved(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }
}

