/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.displays;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.interfaces.IGamaView;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.outputs.IOutput;
import gama.core.outputs.LayeredDisplayData;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExperimentStateListener;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.dev.STRINGS;
import gama.ui.application.workbench.PerspectiveHelper;
import gama.ui.experiment.controls.SimulationSpeedContributionItem;
import gama.ui.experiment.views.displays.DisplayOverlay;
import gama.ui.experiment.views.displays.DisplaySurfaceMenu;
import gama.ui.experiment.views.displays.LayeredDisplayView;
import gama.ui.shared.bindings.GamaKeyBindings;
import gama.ui.shared.menus.GamaColorMenu;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.awt.Color;
import java.util.function.Function;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class LayeredDisplayDecorator
implements LayeredDisplayData.DisplayDataListener,
IExperimentStateListener {
    protected IDisposable keyAndMouseListener;
    protected DisplaySurfaceMenu menuManager;
    public final LayeredDisplayView view;
    ToolItem fs = null;
    protected Composite normalParentOfFullScreenControl;
    protected Composite normalParentOfToolbar;
    protected Shell fullScreenShell;
    public DisplayOverlay overlay;
    public GamaToolbar2 toolbar;
    boolean isOverlayTemporaryVisible;
    boolean sideControlsVisible;
    boolean interactiveConsoleVisible;
    protected IPerspectiveListener perspectiveListener;
    GamaCommand toggleOverlay;
    GamaCommand takeSnapshot;
    GamaCommand antiAlias;
    GamaCommand toggleFullScreen;
    GamaCommand runExperiment;
    GamaCommand stepExperiment;
    GamaCommand closeExperiment;
    GamaCommand relaunchExperiment;
    private final IPartListener2 overlayListener = new IPartListener2(){

        private boolean ok(IWorkbenchPartReference iWorkbenchPartReference) {
            return iWorkbenchPartReference.getPart(false) == LayeredDisplayDecorator.this.view && LayeredDisplayDecorator.this.view.surfaceComposite != null && !LayeredDisplayDecorator.this.view.surfaceComposite.isDisposed() && !LayeredDisplayDecorator.this.view.isFullScreen();
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.ok(iWorkbenchPartReference)) {
                WorkbenchHelper.runInUI((String)("Activating " + iWorkbenchPartReference.getTitle()), (int)0, iProgressMonitor -> {
                    LayeredDisplayDecorator.this.view.showCanvas();
                    if (LayeredDisplayDecorator.this.overlay != null) {
                        LayeredDisplayDecorator.this.overlay.display();
                    }
                });
            }
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.ok(iWorkbenchPartReference) && LayeredDisplayDecorator.this.overlay != null) {
                LayeredDisplayDecorator.this.overlay.close();
            }
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            if (!PerspectiveHelper.keepTabs().booleanValue()) {
                return;
            }
            if (this.ok(iWorkbenchPartReference)) {
                WorkbenchHelper.runInUI((String)("Hide " + iWorkbenchPartReference.getTitle()), (int)0, iProgressMonitor -> {
                    LayeredDisplayDecorator.this.view.hideCanvas();
                    if (LayeredDisplayDecorator.this.overlay != null) {
                        LayeredDisplayDecorator.this.overlay.hide();
                    }
                });
            }
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.ok(iWorkbenchPartReference)) {
                WorkbenchHelper.runInUI((String)("Unhide " + iWorkbenchPartReference.getTitle()), (int)0, iProgressMonitor -> {
                    LayeredDisplayDecorator.this.view.showCanvas();
                    IDisplaySurface iDisplaySurface = LayeredDisplayDecorator.this.view.getDisplaySurface();
                    if (iDisplaySurface != null) {
                        iDisplaySurface.getOutput().update();
                    }
                    if (LayeredDisplayDecorator.this.overlay != null) {
                        LayeredDisplayDecorator.this.overlay.display();
                    }
                });
            }
        }
    };
    public final GamaCommand enterFullScreen = new GamaCommand("display/fullscreen.enter", STRINGS.PAD((String)"Enter fullscreen", (int)25) + "ESC", selectionEvent -> this.toggleFullScreen());
    public final GamaCommand exitFullScreen = new GamaCommand("display/fullscreen.exit", STRINGS.PAD((String)"Exit fullscreen", (int)25) + "ESC", selectionEvent -> this.toggleFullScreen());
    ToolItem runExperimentItem = null;
    protected Runnable displayOverlay = () -> {
        if (this.overlay == null) {
            return;
        }
        this.updateOverlay();
    };

    static {
        DEBUG.ON();
    }

    LayeredDisplayDecorator(LayeredDisplayView layeredDisplayView) {
        this.view = layeredDisplayView;
        this.createCommands();
        WorkbenchHelper.getPage().addPartListener(this.overlayListener);
        GAMA.addExperimentStateListener((IExperimentStateListener)this);
    }

    private void createCommands() {
        int n = 25;
        this.toggleOverlay = new GamaCommand("display/toggle.overlay", STRINGS.PAD((String)"Toggle overlay", (int)n) + GamaKeyBindings.format((int)GamaKeyBindings.COMMAND, (int)79), selectionEvent -> this.toggleOverlay());
        this.takeSnapshot = new GamaCommand("display/action.snapshot", STRINGS.PAD((String)"Take a snapshot", (int)n), selectionEvent -> this.view.takeSnapshot(null));
        this.antiAlias = new GamaCommand("display/toggle.antialias", STRINGS.PAD((String)"Turn antialias on/off", (int)n), selectionEvent -> {
            this.view.getOutput().getData().setAntialias(!this.view.getOutput().getData().isAntialias());
            this.view.update((IOutput)this.view.getOutput());
        });
        this.toggleFullScreen = new GamaCommand("display/fullscreen.enter", STRINGS.PAD((String)"Toggle fullscreen", (int)n) + "ESC", selectionEvent -> this.toggleFullScreen());
        this.runExperiment = new GamaCommand("experiment/experiment.run", STRINGS.PAD((String)"Run or pause experiment", (int)n) + GamaKeyBindings.PLAY_STRING, selectionEvent -> {
            Item item = (Item)selectionEvent.widget;
            if (!GAMA.isPaused()) {
                item.setImage(GamaIcon.named((String)"experiment/experiment.run").image());
            } else {
                item.setImage(GamaIcon.named((String)"experiment/experiment.pause").image());
            }
            GAMA.startPauseFrontmostExperiment((boolean)false);
        });
        this.stepExperiment = new GamaCommand("experiment/experiment.step", STRINGS.PAD((String)"Step experiment", (int)n) + GamaKeyBindings.STEP_STRING, selectionEvent -> {
            boolean bl = GAMA.stepFrontmostExperiment((boolean)false);
        });
        this.closeExperiment = new GamaCommand("experiment/experiment.stop", STRINGS.PAD((String)"Closes experiment", (int)n) + GamaKeyBindings.QUIT_STRING, selectionEvent -> new Thread(() -> GAMA.closeAllExperiments((boolean)true, (boolean)false)).start());
        this.relaunchExperiment = new GamaCommand("experiment/experiment.reload", STRINGS.PAD((String)"Reload experiment", (int)n) + GamaKeyBindings.RELOAD_STRING, selectionEvent -> {
            boolean bl = GAMA.reloadFrontmostExperiment((boolean)false);
        });
    }

    public void toggleFullScreen() {
        if (this.isFullScreen()) {
            DEBUG.OUT((Object)"Is already full screen: exiting");
            this.fs.setImage(GamaIcon.named((String)"display/fullscreen.enter").image());
            this.fs.setToolTipText(STRINGS.PAD((String)"Enter fullscreen", (int)25) + "ESC");
            this.toggleFullScreen = this.enterFullScreen;
            if (!this.toolbar.isDisposed()) {
                this.toolbar.wipe(16384, true);
                this.toolbar.setParent(this.normalParentOfToolbar);
                this.normalParentOfToolbar.requestLayout();
            }
            this.runExperimentItem = null;
            this.view.getCentralPanel().setParent(this.normalParentOfFullScreenControl);
            this.createOverlay();
            this.normalParentOfFullScreenControl.requestLayout();
            this.destroyFullScreenShell();
        } else {
            DEBUG.OUT((Object)"Is not full screen: entering");
            ViewsHelper.activate((IWorkbenchPart)this.view);
            this.fullScreenShell = this.createFullScreenShell();
            if (this.fullScreenShell == null) {
                return;
            }
            this.fs.setImage(GamaIcon.named((String)"display/fullscreen.exit").image());
            this.fs.setToolTipText(STRINGS.PAD((String)"Exit fullscreen", (int)25) + "ESC");
            this.toggleFullScreen = this.exitFullScreen;
            this.normalParentOfFullScreenControl = this.view.getCentralPanel().getParent();
            this.view.getCentralPanel().setParent((Composite)this.fullScreenShell);
            this.fullScreenShell.layout(true, true);
            this.fullScreenShell.setVisible(true);
            this.createOverlay();
            if (!this.toolbar.isDisposed()) {
                this.toolbar.wipe(16384, true);
                this.addFullscreenToolbarCommands();
                this.normalParentOfToolbar = this.toolbar.getParent();
                this.toolbar.setParent((Composite)this.fullScreenShell);
            }
        }
        if (!this.toolbar.isDisposed()) {
            this.toolbar.wipe(131072, true);
            GamaToolbarFactory.buildToolbar((IToolbarDecoratedView)this.view, (GamaToolbar2)this.toolbar);
            this.toolbar.requestLayout();
        }
        if (this.overlay.isVisible()) {
            WorkbenchHelper.runInUI((String)"Display overlay", (int)50, iProgressMonitor -> {
                this.toggleOverlay();
                this.toggleOverlay();
            });
        }
        this.view.focusCanvas();
    }

    public void toggleToolbar() {
        if (this.isFullScreen()) {
            boolean bl = this.toolbar.isVisible();
            this.toolbar.setVisible(!bl);
            ((GridData)this.toolbar.getLayoutData()).exclude = bl;
        } else if (this.toolbar.isVisible()) {
            this.toolbar.hide();
        } else {
            this.toolbar.show();
        }
        this.toolbar.getParent().requestLayout();
    }

    public void addFullscreenToolbarCommands() {
        this.toolbar.button(this.toggleOverlay, 16384);
        this.toolbar.sep(4, 16384);
        this.runExperimentItem = this.toolbar.button(this.runExperiment, 16384);
        if (GAMA.isPaused()) {
            this.runExperimentItem.setImage(GamaIcon.named((String)"experiment/experiment.run").image());
        } else {
            this.runExperimentItem.setImage(GamaIcon.named((String)"experiment/experiment.pause").image());
        }
        this.toolbar.button(this.stepExperiment, 16384);
        this.toolbar.control(SimulationSpeedContributionItem.create((Composite)this.toolbar.getToolbar(16384)), SimulationSpeedContributionItem.totalWidth(), 16384);
        this.toolbar.button(this.relaunchExperiment, 16384);
        this.toolbar.button(this.closeExperiment, 16384);
    }

    public void createOverlay() {
        boolean bl = false;
        if (this.overlay != null) {
            bl = this.overlay.isVisible();
            this.overlay.dispose();
        }
        this.overlay = new DisplayOverlay(this.view, this.view.surfaceComposite);
        if (bl) {
            this.overlay.setVisible(true);
        }
        if (this.overlay.isVisible()) {
            this.overlay.relocate();
            this.overlay.update();
        }
    }

    public void createDecorations() {
        this.createOverlay();
        this.addPerspectiveListener();
        this.keyAndMouseListener = this.view.getMultiListener();
        this.menuManager = new DisplaySurfaceMenu(this.view.getDisplaySurface(), (Control)this.view.getParentComposite(), this.presentationMenu());
        boolean bl = this.view.getOutput().getData().isToolbarVisible();
        WorkbenchHelper.runInUI((String)("Show/hide toolbar of " + this.view.getPartName()), (int)0, iProgressMonitor -> {
            if (bl) {
                this.toolbar.show();
            } else {
                this.toolbar.hide();
            }
        });
    }

    private void addPerspectiveListener() {
        this.perspectiveListener = new IPerspectiveListener(){
            boolean previousState = false;

            public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
            }

            public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                if ("gama.ui.application.perspectives.ModelingPerspective".equals(iPerspectiveDescriptor.getId())) {
                    if (LayeredDisplayDecorator.this.view.getOutput() != null && LayeredDisplayDecorator.this.view.getDisplaySurface() != null && !((Boolean)GamaPreferences.Displays.CORE_DISPLAY_PERSPECTIVE.getValue()).booleanValue()) {
                        this.previousState = LayeredDisplayDecorator.this.view.getOutput().isPaused();
                        LayeredDisplayDecorator.this.view.getOutput().setPaused(true);
                    }
                    WorkbenchHelper.run(() -> {
                        if (PlatformHelper.isMac() && LayeredDisplayDecorator.this.overlay != null) {
                            LayeredDisplayDecorator.this.overlay.hide();
                        }
                        LayeredDisplayDecorator.this.view.hideCanvas();
                    });
                } else {
                    IDisplaySurface iDisplaySurface;
                    if (PlatformHelper.isMac() && !LayeredDisplayDecorator.this.view.isOpenGL() && (iDisplaySurface = LayeredDisplayDecorator.this.view.getDisplaySurface()) != null) {
                        iDisplaySurface.updateDisplay(true);
                    }
                    if (!((Boolean)GamaPreferences.Displays.CORE_DISPLAY_PERSPECTIVE.getValue()).booleanValue() && LayeredDisplayDecorator.this.view.getOutput() != null && LayeredDisplayDecorator.this.view.getDisplaySurface() != null) {
                        LayeredDisplayDecorator.this.view.getOutput().setPaused(this.previousState);
                    }
                    WorkbenchHelper.asyncRun(() -> {
                        if (PlatformHelper.isMac() && LayeredDisplayDecorator.this.overlay != null) {
                            LayeredDisplayDecorator.this.overlay.display();
                        }
                    });
                }
            }
        };
        WorkbenchHelper.getWindow().addPerspectiveListener(this.perspectiveListener);
    }

    public boolean isFullScreen() {
        return this.fullScreenShell != null;
    }

    private Shell createFullScreenShell() {
        int n = this.view.getOutput().getData().fullScreen();
        Monitor[] monitorArray = WorkbenchHelper.getMonitors();
        int n2 = Math.min(monitorArray.length - 1, Math.max(0, n));
        Rectangle rectangle = monitorArray[n2].getBounds();
        if (ViewsHelper.registerFullScreenView((Integer)n2, (IGamaView.Display)this.view)) {
            Shell shell = new Shell(WorkbenchHelper.getDisplay(), 16392);
            shell.setBounds(rectangle);
            shell.setLayout((Layout)this.shellLayout());
            return shell;
        }
        return null;
    }

    private void destroyFullScreenShell() {
        if (this.fullScreenShell == null) {
            return;
        }
        DEBUG.OUT((Object)"Destroying full screen shell");
        this.fullScreenShell.close();
        this.fullScreenShell.dispose();
        this.fullScreenShell = null;
        ViewsHelper.unregisterFullScreenView((IGamaView.Display)this.view);
        ViewsHelper.activate((IWorkbenchPart)this.view);
    }

    private GridLayout shellLayout() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    protected void updateOverlay() {
        if (this.overlay == null) {
            return;
        }
        if (this.view.forceOverlayVisibility()) {
            if (!this.overlay.isVisible()) {
                this.isOverlayTemporaryVisible = true;
                this.overlay.setVisible(true);
            }
        } else if (this.isOverlayTemporaryVisible) {
            this.isOverlayTemporaryVisible = false;
            this.overlay.setVisible(false);
        }
        if (this.overlay.isVisible()) {
            this.overlay.update();
        }
    }

    public void toggleOverlay() {
        this.overlay.setVisible(!this.overlay.isVisible());
    }

    private Function<Menu, Menu> presentationMenu() {
        return menu -> {
            Menu menu2 = GamaMenu.sub((Menu)menu, (String)"Presentation", (String)"", (Image)GamaIcon.named((String)"editor/menu.presentation").image());
            if (!this.isFullScreen() && WorkbenchHelper.getNumberOfMonitors() > 1) {
                Menu menu3 = GamaMenu.sub((Menu)menu2, (String)"Enter fullscreen", (String)"", (Image)GamaIcon.named((String)"display/fullscreen.enter").image());
                Monitor[] monitorArray = WorkbenchHelper.getMonitors();
                int n = 0;
                while (n < monitorArray.length) {
                    Monitor monitor = monitorArray[n];
                    Rectangle rectangle = monitor.getBounds();
                    String string = "Monitor " + n + " (" + rectangle.width + "x" + rectangle.height + ")";
                    int n2 = n++;
                    GamaMenu.action((Menu)menu3, (String)string, selectionEvent -> {
                        this.view.getOutput().getData().setFullScreen(n2);
                        this.toggleFullScreen();
                    });
                }
            } else {
                this.toggleFullScreen.toItem(menu2);
            }
            this.toggleOverlay.toItem(menu2);
            GamaMenu.action((Menu)menu2, (String)(STRINGS.PAD((String)"Toggle toolbar ", (int)25) + GamaKeyBindings.format((int)GamaKeyBindings.COMMAND, (int)84)), selectionEvent -> this.toggleToolbar(), (Image)GamaIcon.named((String)(this.isFullScreen() ? "display/toolbar.fullscreen" : "display/toolbar.regular")).image());
            GamaColorMenu.addColorSubmenuTo((Menu)menu2, (String)STRINGS.PAD((String)"Background", (int)25), gamaColor -> {
                this.view.getDisplaySurface().getData().setBackgroundColor(gamaColor);
                this.view.getDisplaySurface().updateDisplay(true);
            });
            return menu2;
        };
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.toolbar = gamaToolbar2;
        gamaToolbar2.setBackgroundColor(GamaColors.get((Color)this.view.getOutput().getData().getToolbarColor()).color());
        gamaToolbar2.sep(4, 131072);
        gamaToolbar2.button(this.takeSnapshot, 131072);
        ToolItem toolItem = gamaToolbar2.check(this.antiAlias, 131072);
        gamaToolbar2.setSelection(toolItem, this.view.getOutput().getData().isAntialias());
        this.fs = !this.isFullScreen() && WorkbenchHelper.getNumberOfMonitors() > 1 ? gamaToolbar2.menu("display/fullscreen.enter", "", "Enter fullscreen", selectionEvent -> {
            GamaMenu gamaMenu = new GamaMenu(){

                protected void fillMenu() {
                    Monitor[] monitorArray = WorkbenchHelper.getMonitors();
                    int n = 0;
                    while (n < monitorArray.length) {
                        Rectangle rectangle = monitorArray[n].getBounds();
                        String string = "Enter fullscreen on monitor " + n + " (" + rectangle.width + "x" + rectangle.height + ")";
                        int n2 = n++;
                        this.action(string, selectionEvent -> {
                            LayeredDisplayDecorator.this.view.getOutput().getData().setFullScreen(n2);
                            LayeredDisplayDecorator.this.toggleFullScreen();
                        });
                    }
                }
            };
            gamaMenu.open((Control)this.toolbar.getToolbar(131072), selectionEvent);
        }, 131072) : gamaToolbar2.button(this.toggleFullScreen, 131072);
        gamaToolbar2.sep(4, 131072);
        gamaToolbar2.menu("layer/layers.menu", "Browse displayed agents by layers", "Properties and contents of layers", selectionEvent -> this.menuManager.buildToolbarMenu(selectionEvent, (ToolItem)selectionEvent.widget), 131072);
    }

    public void dispose() {
        GAMA.removeExperimentStateListener((IExperimentStateListener)this);
        try {
            WorkbenchHelper.getWindow().removePerspectiveListener(this.perspectiveListener);
            WorkbenchHelper.getPage().removePartListener(this.overlayListener);
        }
        catch (Exception exception) {}
        if (this.keyAndMouseListener != null) {
            this.keyAndMouseListener.dispose();
            this.keyAndMouseListener = null;
        }
        if (this.overlay != null) {
            this.overlay.close();
            this.overlay = null;
        }
        if (this.menuManager != null) {
            this.menuManager.disposeMenu();
            this.menuManager = null;
        }
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            this.toolbar.dispose();
            this.toolbar = null;
        }
        this.fs = null;
        this.normalParentOfToolbar = null;
        this.normalParentOfFullScreenControl = null;
        if (this.fullScreenShell != null && !this.fullScreenShell.isDisposed()) {
            this.fullScreenShell.dispose();
            this.fullScreenShell = null;
        }
    }

    public void changed(LayeredDisplayData.Changes changes, Object object) {
        switch (changes) {
            case ZOOM: {
                WorkbenchHelper.asyncRun(this::updateOverlay);
                break;
            }
        }
    }

    public void updateStateTo(IExperimentPlan iExperimentPlan, IExperimentStateListener.State state) {
        if (!this.isFullScreen() || this.toolbar == null || !this.toolbar.isVisible()) {
            return;
        }
        if (IExperimentStateListener.State.PAUSED.name().equals(state.name())) {
            WorkbenchHelper.asyncRun(() -> {
                this.runExperimentItem.setImage(GamaIcon.named((String)"experiment/experiment.run").image());
                this.toolbar.update();
            });
        } else if (IExperimentStateListener.State.RUNNING.name().equals(state.name())) {
            WorkbenchHelper.asyncRun(() -> {
                this.runExperimentItem.setImage(GamaIcon.named((String)"experiment/experiment.pause").image());
                this.toolbar.update();
            });
        }
    }
}

