/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.metadata.FileMetaDataProvider;
import gama.ui.navigator.view.actions.CloseResourceAction;
import gama.ui.navigator.view.contents.LinkedFile;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;
import org.eclipse.ui.part.FileEditorInput;

public class DeleteResourceAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.DeleteResourceAction";
    private String[] modelProviderIds;

    public DeleteResourceAction(IShellProvider iShellProvider) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        Assert.isNotNull((Object)iShellProvider);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.DeleteResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.delete_resource_action_context");
        this.setId(ID);
    }

    private boolean canDelete(List<? extends IResource> list) {
        if (!this.containsOnlyProjects(list) && !this.containsOnlyNonProjects(list)) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            IResource iResource = list.get(n);
            if (iResource.isPhantom()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean containsOnlyNonProjects(List<? extends IResource> list) {
        int n = this.getSelectedResourceTypes(list);
        if (n == 0) {
            return false;
        }
        return (n & 4) == 0;
    }

    private boolean containsOnlyProjects(List<? extends IResource> list) {
        int n = this.getSelectedResourceTypes(list);
        return n == 4;
    }

    private int getSelectedResourceTypes(List<? extends IResource> list) {
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            n |= list.get(n2).getType();
            ++n2;
        }
        return n;
    }

    protected List<? extends IResource> getSelectedResources() {
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (iStructuredSelection.toList().stream().anyMatch(object -> object instanceof LinkedFile)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (IResource iResource : super.getSelectedResources()) {
            arrayList.add(iResource);
            if (!ResourceManager.isFile(iResource)) continue;
            arrayList.addAll(FileMetaDataProvider.getInstance().getSupportFilesOf((IFile)iResource));
        }
        return arrayList;
    }

    public void run() {
        List<? extends IResource> list = this.getSelectedResources();
        if (LTKLauncher.openDeleteWizard((IStructuredSelection)new StructuredSelection(list))) {
            DeleteResourceAction.closeMatchingEditors(list, true);
            return;
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return this.canDelete(this.getSelectedResources());
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    static void closeMatchingEditors(final List<? extends IResource> list, final boolean bl) {
        if (list.isEmpty()) {
            return;
        }
        Runnable runnable = () -> SafeRunner.run((ISafeRunnable)new SafeRunnable(IDEWorkbenchMessages.ErrorOnCloseEditors){

            public void run() {
                WorkbenchWindow workbenchWindow = WorkbenchHelper.getWindow();
                if (workbenchWindow != null) {
                    List<IEditorReference> list2 = DeleteResourceAction.getMatchingEditors(list, (IWorkbenchWindow)workbenchWindow, bl);
                    if (list2.isEmpty()) {
                        return;
                    }
                    DeleteResourceAction.closeEditors(list2, (IWorkbenchWindow)workbenchWindow);
                }
            }
        });
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)runnable);
    }

    static List<IEditorReference> getMatchingEditors(List<? extends IResource> list, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        IEditorReference[] iEditorReferenceArray;
        ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = DeleteResourceAction.getEditors(iWorkbenchWindow);
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray2[n2];
            IResource iResource = DeleteResourceAction.getAdapter(iEditorReference);
            if (!(iResource == null || !DeleteResourceAction.belongsTo(list, iResource) || bl && iResource.exists())) {
                arrayList.add(iEditorReference);
            }
            ++n2;
        }
        return arrayList;
    }

    static IEditorReference[] getEditors(IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage iWorkbenchPage;
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            return iWorkbenchPage.getEditorReferences();
        }
        return new IEditorReference[0];
    }

    static IResource getAdapter(IEditorReference iEditorReference) {
        FileEditorInput fileEditorInput;
        IFile iFile;
        IEditorInput iEditorInput;
        try {
            iEditorInput = iEditorReference.getEditorInput();
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (iEditorInput instanceof FileEditorInput && (iFile = (fileEditorInput = (FileEditorInput)iEditorInput).getFile()) != null) {
            return iFile;
        }
        fileEditorInput = CloseResourceAction.getAdapter(iEditorInput, IFile.class);
        if (fileEditorInput != null) {
            return fileEditorInput;
        }
        return CloseResourceAction.getAdapter(iEditorInput, IResource.class);
    }

    static boolean belongsTo(List<? extends IResource> list, IResource iResource) {
        for (IResource iResource2 : list) {
            if (!iResource2.contains((ISchedulingRule)iResource)) continue;
            return true;
        }
        return false;
    }

    static void closeEditors(List<IEditorReference> list, IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        iWorkbenchPage.closeEditors(list.toArray(new IEditorReference[list.size()]), false);
    }
}

