/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.view.actions.CloseResourceAction;
import gama.ui.navigator.view.actions.OpenResourceAction;
import gama.ui.shared.resources.GamaIcon;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class OpenCloseActionProvider
extends CommonActionProvider {
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private Shell shell;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        super.init(iCommonActionExtensionSite);
        this.shell = iCommonActionExtensionSite.getViewSite().getShell();
        this.makeActions();
    }

    public void fillActionBars(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        this.updateActionBars();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext() && (!bl2 || !bl3 || bl)) {
            Object e = iterator.next();
            IProject iProject = null;
            if (e instanceof IProject) {
                iProject = (IProject)e;
            } else if (e instanceof IAdaptable) {
                iProject = (IProject)((IAdaptable)e).getAdapter(IProject.class);
            }
            if (iProject == null) {
                bl = false;
                continue;
            }
            if (iProject.isOpen()) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl) {
            if (bl3) {
                this.openProjectAction.selectionChanged(iStructuredSelection);
                iMenuManager.appendToGroup("group.refresh", (IAction)this.openProjectAction);
            }
            if (bl2) {
                this.closeProjectAction.selectionChanged(iStructuredSelection);
                iMenuManager.appendToGroup("group.refresh", (IAction)this.closeProjectAction);
            }
        }
    }

    protected void makeActions() {
        IShellProvider iShellProvider = () -> this.shell;
        this.openProjectAction = new OpenResourceAction(iShellProvider);
        this.openProjectAction.setImageDescriptor(GamaIcon.named((String)"navigator/project.open2").descriptor());
        this.openProjectAction.setDisabledImageDescriptor(GamaIcon.named((String)"navigator/project.open2").disabledDescriptor());
        this.closeProjectAction = new CloseResourceAction(iShellProvider);
        this.closeProjectAction.setImageDescriptor(GamaIcon.named((String)"navigator/project.close2").descriptor());
        this.closeProjectAction.setDisabledImageDescriptor(GamaIcon.named((String)"navigator/project.close2").disabledDescriptor());
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.openProjectAction.selectionChanged(iStructuredSelection);
        this.closeProjectAction.selectionChanged(iStructuredSelection);
    }
}

