/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.view.actions.RefreshAction;
import gama.ui.navigator.view.actions.RunAllTestsAction;
import gama.ui.shared.resources.GamaIcon;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class RefreshActionProvider
extends CommonActionProvider {
    private RefreshAction refreshAction;
    private RunAllTestsAction runAllTestsAction;
    private Shell shell;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        super.init(iCommonActionExtensionSite);
        this.shell = iCommonActionExtensionSite.getViewSite().getShell();
        this.makeActions();
    }

    public void fillActionBars(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        this.updateActionBars();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(iStructuredSelection);
        this.runAllTestsAction.selectionChanged(iStructuredSelection);
        if (this.runAllTestsAction.isEnabled()) {
            iMenuManager.appendToGroup("group.refresh", (IAction)this.runAllTestsAction);
        }
        iMenuManager.appendToGroup("group.refresh", (IAction)this.refreshAction);
    }

    protected void makeActions() {
        IShellProvider iShellProvider = () -> this.shell;
        this.refreshAction = new RefreshAction(iShellProvider);
        this.refreshAction.setImageDescriptor(GamaIcon.named((String)"navigator/file.refresh").descriptor());
        this.refreshAction.setDisabledImageDescriptor(GamaIcon.named((String)"navigator/file.refresh").disabledDescriptor());
        this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.runAllTestsAction = new RunAllTestsAction(iShellProvider, "Run all tests");
        this.runAllTestsAction.setImageDescriptor(GamaIcon.named((String)"build/test.run").descriptor());
        this.runAllTestsAction.setDisabledImageDescriptor(GamaIcon.named((String)"build/test.run").disabledDescriptor());
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(iStructuredSelection);
        this.runAllTestsAction.selectionChanged(iStructuredSelection);
    }
}

