/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.metadata;

import gama.core.common.GamlFileExtension;
import gama.core.runtime.GAMA;
import gama.core.util.file.GamaCSVFile;
import gama.core.util.file.GamaFileMetaData;
import gama.core.util.file.GamaOsmFile;
import gama.core.util.file.GamaShapeFile;
import gama.core.util.file.GamlFileInfo;
import gama.core.util.file.IFileMetaDataProvider;
import gama.core.util.file.IGamaFileMetaData;
import gama.dev.DEBUG;
import gama.dev.THREADS;
import gama.gaml.compilation.GAML;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.operators.Strings;
import gama.ui.navigator.metadata.ImageDataLoader;
import gama.ui.navigator.metadata.ImageInfo;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.graphics.ImageData;

public class FileMetaDataProvider
implements IFileMetaDataProvider {
    private static volatile Set<Object> processing = Collections.synchronizedSet(new HashSet());
    public static final QualifiedName CACHE_KEY = new QualifiedName("gama.ui.application", "metadata");
    public static final QualifiedName CHANGE_KEY = new QualifiedName("gama.ui.application", "changed");
    public static final String CSV_CT_ID = "gama.ui.csv.type";
    public static final String IMAGE_CT_ID = "gama.ui.images.type";
    public static final String GAML_CT_ID = "gama.ui.gaml.type";
    public static final String SHAPEFILE_CT_ID = "gama.ui.shapefile.type";
    public static final String OSM_CT_ID = "gama.ui.osm.type";
    public static final String SHAPEFILE_SUPPORT_CT_ID = "gama.ui.shapefile.support.type";
    public static final String GSIM_CT_ID = "gama.ui.gsim.type";
    private static final FileMetaDataProvider instance = new FileMetaDataProvider();
    public static final ArrayList<String> OSMExt = new ArrayList<String>(){
        {
            this.add("osm");
            this.add("gz");
            this.add("pbf");
            this.add("bz2");
        }
    };
    public static final HashMap<String, String> longNames = new HashMap<String, String>(){
        {
            this.put("prj", "Projection data");
            this.put("shx", "Index data");
            this.put("dbf", "Attribute data");
            this.put("xml", "Metadata");
            this.put("sbn", "Query data");
            this.put("sbx", "Query data");
            this.put("qix", "Query data");
            this.put("qpj", "QGis project");
            this.put("fix", "Feature index");
            this.put("cpg", "Character set codepage");
            this.put("qml", "Style information");
        }
    };
    public static final Map<String, Class<? extends GamaFileMetaData>> CLASSES = new HashMap<String, Class<? extends GamaFileMetaData>>(){
        {
            this.put(FileMetaDataProvider.CSV_CT_ID, GamaCSVFile.CSVInfo.class);
            this.put(FileMetaDataProvider.IMAGE_CT_ID, ImageInfo.class);
            this.put(FileMetaDataProvider.GAML_CT_ID, GamlFileInfo.class);
            this.put(FileMetaDataProvider.SHAPEFILE_CT_ID, GamaShapeFile.ShapeInfo.class);
            this.put(FileMetaDataProvider.OSM_CT_ID, GamaOsmFile.OSMInfo.class);
            this.put(FileMetaDataProvider.SHAPEFILE_SUPPORT_CT_ID, GenericFileInfo.class);
            this.put("project", ProjectInfo.class);
        }
    };
    ExecutorService executor = Executors.newCachedThreadPool();
    volatile boolean started;

    private <T> T adaptTo(Object object, Class<T> clazz, Class<?> clazz2) {
        Object object2;
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        if (object instanceof IAdaptable && clazz.isInstance(object2 = ((IAdaptable)object).getAdapter(clazz2))) {
            return clazz.cast(object2);
        }
        return null;
    }

    private FileMetaDataProvider() {
        ResourcesPlugin.getWorkspace().getSynchronizer().add(CACHE_KEY);
    }

    private IGamaFileMetaData getMetaData(IProject iProject, boolean bl) {
        if (!iProject.isAccessible()) {
            return null;
        }
        Class<? extends GamaFileMetaData> clazz = CLASSES.get("project");
        if (clazz == null) {
            return null;
        }
        GamaFileMetaData gamaFileMetaData = this.readMetadata((IResource)iProject, clazz, bl);
        if (gamaFileMetaData == null) {
            try {
                this.storeMetaData((IResource)iProject, (IGamaFileMetaData)new ProjectInfo(iProject), false);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return null;
            }
        }
        return gamaFileMetaData;
    }

    public IGamaFileMetaData getMetaData(Object object, boolean bl, boolean bl2) {
        Class<? extends GamaFileMetaData> clazz;
        String string;
        this.startup();
        if (processing.contains(object)) {
            while (processing.contains(object)) {
                THREADS.WAIT((long)100L, (String[])new String[0]);
            }
            return this.getMetaData(object, bl, bl2);
        }
        if (object instanceof IProject) {
            return this.getMetaData((IProject)object, bl);
        }
        IFile iFile = this.adaptTo(object, IFile.class, IFile.class);
        if (iFile == null) {
            if (object instanceof File) {
                string = Path.fromOSString((String)((File)object).getAbsolutePath());
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)string);
            }
            if (iFile == null || !iFile.exists()) {
                return null;
            }
        } else if (!iFile.isAccessible()) {
            return null;
        }
        if ((clazz = CLASSES.get(string = FileMetaDataProvider.getContentTypeId(iFile))) == null) {
            return null;
        }
        IGamaFileMetaData[] iGamaFileMetaDataArray = new IGamaFileMetaData[]{this.readMetadata((IResource)iFile, clazz, bl)};
        if (iGamaFileMetaDataArray[0] == null) {
            processing.add(object);
            IFile iFile2 = iFile;
            Runnable runnable = () -> {
                try {
                    switch (string) {
                        case "gama.ui.shapefile.type": {
                            iGamaFileMetaDataArray[0] = this.createShapeFileMetaData(iFile2);
                            break;
                        }
                        case "gama.ui.osm.type": {
                            iGamaFileMetaDataArray[0] = this.createOSMMetaData(iFile2);
                            break;
                        }
                        case "gama.ui.images.type": {
                            iGamaFileMetaDataArray[0] = this.createImageFileMetaData(iFile2);
                            break;
                        }
                        case "gama.ui.csv.type": {
                            iGamaFileMetaDataArray[0] = this.createCSVFileMetaData(iFile2);
                            break;
                        }
                        case "gama.ui.gaml.type": {
                            iGamaFileMetaDataArray[0] = this.createGamlFileMetaData(iFile2);
                            break;
                        }
                        case "gama.ui.shapefile.support.type": {
                            iGamaFileMetaDataArray[0] = this.createShapeFileSupportMetaData(iFile2);
                        }
                    }
                    if (iGamaFileMetaDataArray[0] == null) {
                        iGamaFileMetaDataArray[0] = this.createGenericFileMetaData(iFile2);
                    }
                    this.storeMetaData((IResource)iFile2, iGamaFileMetaDataArray[0], bl2);
                    try {
                        iFile2.refreshLocal(0, null);
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                }
                finally {
                    processing.remove(object);
                }
            };
            if (bl2) {
                runnable.run();
            } else {
                this.executor.submit(runnable);
            }
        }
        return iGamaFileMetaDataArray[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends IGamaFileMetaData> T readMetadata(IResource iResource, Class<T> clazz, boolean bl) {
        IGamaFileMetaData iGamaFileMetaData = null;
        long l = iResource.getModificationStamp();
        try {
            String string = (String)iResource.getSessionProperty(CACHE_KEY);
            if (string != null) {
                iGamaFileMetaData = GamaFileMetaData.from((String)string, (long)l, clazz, (boolean)bl);
            }
            if (clazz.isInstance(iGamaFileMetaData)) return (T)iGamaFileMetaData;
            return null;
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)("Error loading metadata for " + iResource.getName() + " : " + exception.getMessage()));
            return (T)iGamaFileMetaData;
        }
    }

    public void storeMetaData(IResource iResource, IGamaFileMetaData iGamaFileMetaData, boolean bl) {
        this.startup();
        if (!iResource.isAccessible()) {
            return;
        }
        try {
            if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
                return;
            }
            if (iGamaFileMetaData != null) {
                iGamaFileMetaData.setModificationStamp(iResource.getModificationStamp());
            }
            Runnable runnable = () -> {
                try {
                    iResource.setSessionProperty(CACHE_KEY, (Object)(iGamaFileMetaData == null ? null : iGamaFileMetaData.toPropertyString()));
                    iResource.setSessionProperty(CHANGE_KEY, (Object)true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            };
            if (!bl) {
                this.executor.submit(runnable);
            } else {
                runnable.run();
            }
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)("Error storing metadata for " + iResource.getName() + " : " + exception.getMessage()));
            exception.printStackTrace();
        }
    }

    private GamlFileInfo createGamlFileMetaData(IFile iFile) {
        return GAML.getInfo((URI)URI.createPlatformResourceURI((String)iFile.getFullPath().toOSString(), (boolean)true), (long)iFile.getModificationStamp());
    }

    private GamaCSVFile.CSVInfo createCSVFileMetaData(IFile iFile) {
        return new GamaCSVFile.CSVInfo(iFile.getLocation().toOSString(), iFile.getModificationStamp(), null);
    }

    private ImageInfo createImageFileMetaData(IFile iFile) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        ImageData imageData = ImageDataLoader.getImageData(iFile);
        if (imageData != null) {
            n2 = imageData.width;
            n3 = imageData.height;
            n = imageData.type;
        } else {
            n2 = -1;
            n3 = -1;
            n = -1;
        }
        return new ImageInfo(iFile.getModificationStamp(), n, n2, n3);
    }

    private GamaShapeFile.ShapeInfo createShapeFileMetaData(IFile iFile) {
        GamaShapeFile.ShapeInfo shapeInfo = null;
        try {
            shapeInfo = new GamaShapeFile.ShapeInfo(null, iFile.getLocationURI().toURL(), iFile.getModificationStamp());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return shapeInfo;
    }

    private GamaOsmFile.OSMInfo createOSMMetaData(IFile iFile) {
        GamaOsmFile.OSMInfo oSMInfo = null;
        try {
            oSMInfo = new GamaOsmFile.OSMInfo(iFile.getLocationURI().toURL(), iFile.getModificationStamp());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return oSMInfo;
    }

    private GenericFileInfo createShapeFileSupportMetaData(IFile iFile) {
        IResource iResource = FileMetaDataProvider.shapeFileSupportedBy(iFile);
        if (iResource == null) {
            return null;
        }
        String string = iFile.getFileExtension();
        String string2 = longNames.containsKey(string) ? longNames.get(string) : "Data";
        return new GenericFileInfo(iFile.getModificationStamp(), string2 + " for '" + iResource.getName() + "'");
    }

    private GenericFileInfo createGenericFileMetaData(IFile iFile) {
        String string = iFile.getFileExtension();
        if (string == null) {
            return new GenericFileInfo(iFile.getModificationStamp(), "Generic file");
        }
        string = string.toUpperCase();
        return new GenericFileInfo(iFile.getModificationStamp(), "Generic " + string + " file");
    }

    public static String getContentTypeId(IFile iFile) {
        IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(iFile.getFullPath().toOSString());
        if (iContentType != null) {
            return iContentType.getId();
        }
        if (GamlFileExtension.isAny((String)iFile.getName())) {
            return GAML_CT_ID;
        }
        String string = iFile.getFileExtension();
        if ("shp".equals(string)) {
            return SHAPEFILE_CT_ID;
        }
        if (OSMExt.contains(string)) {
            return OSM_CT_ID;
        }
        if (longNames.containsKey(string)) {
            return SHAPEFILE_SUPPORT_CT_ID;
        }
        if ("gsim".equals(string)) {
            return GSIM_CT_ID;
        }
        return "";
    }

    public static IResource shapeFileSupportedBy(IFile iFile) {
        String string = iFile.getName();
        if (string.endsWith(".shp.xml")) {
            string = string.replace(".xml", "");
        } else {
            String string2 = iFile.getFileExtension();
            if (!longNames.containsKey(string2)) {
                return null;
            }
            string = string.replace(string2, "shp");
        }
        return iFile.getParent().findMember(string);
    }

    public static boolean isSupport(IFile iFile, IFile iFile2) {
        IResource iResource = FileMetaDataProvider.shapeFileSupportedBy(iFile2);
        return iFile.equals((Object)iResource);
    }

    public static FileMetaDataProvider getInstance() {
        return instance;
    }

    private void startup() {
        if (this.started) {
            return;
        }
        this.started = true;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        DEBUG.TIMER((String)"GAMA", (String)"Retrieving workspace metadata", (String)"done in", () -> {
            try {
                iWorkspace.getRoot().accept(iResource -> {
                    String string;
                    if (iResource.isAccessible() && (string = iResource.getPersistentProperty(CACHE_KEY)) != null) {
                        iResource.setSessionProperty(CACHE_KEY, (Object)Strings.unzip(null, (String)string));
                    }
                    return true;
                });
            }
            catch (CoreException coreException) {}
        }, (Consumer[])new Consumer[0]);
        try {
            iWorkspace.addSaveParticipant("gama.ui.shared.modeling", this.getSaveParticipant());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private ISaveParticipant getSaveParticipant() {
        return new ISaveParticipant(){

            public void saving(ISaveContext iSaveContext) throws CoreException {
                if (iSaveContext.getKind() != 1) {
                    return;
                }
                DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"workspace metadata ", (String)"saved in", () -> ResourcesPlugin.getWorkspace().getRoot().accept(iResource -> {
                    String string = null;
                    try {
                        if (iResource.isAccessible() && (string = (String)iResource.getSessionProperty(CACHE_KEY)) != null) {
                            iResource.setPersistentProperty(CACHE_KEY, Strings.zip(null, (String)string));
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        DEBUG.ERR((Object)("Error when saving metadata of " + iResource.getName() + ": " + exception.getMessage()));
                        if (string != null) {
                            DEBUG.ERR((Object)("Trying to save " + string));
                        }
                        return true;
                    }
                }));
            }

            public void rollback(ISaveContext iSaveContext) {
            }

            public void prepareToSave(ISaveContext iSaveContext) throws CoreException {
            }

            public void doneSaving(ISaveContext iSaveContext) {
            }
        };
    }

    public List<IFile> getSupportFilesOf(IFile iFile) {
        if (iFile == null || !SHAPEFILE_CT_ID.equals(FileMetaDataProvider.getContentTypeId(iFile))) {
            return Collections.EMPTY_LIST;
        }
        IContainer iContainer = iFile.getParent();
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        try {
            IResource[] iResourceArray = iContainer.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource instanceof IFile && FileMetaDataProvider.isSupport(iFile, (IFile)iResource)) {
                    arrayList.add((IFile)iResource);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return arrayList;
    }

    public boolean hasSupportFiles(IResource iResource) {
        return iResource instanceof IFile && SHAPEFILE_CT_ID.equals(FileMetaDataProvider.getContentTypeId((IFile)iResource));
    }

    public void refreshAllMetaData() {
        try {
            GAMA.getGui().getStatus().informStatus("Refreshing metadata of files in workspace", "status/status.compile");
            ResourcesPlugin.getWorkspace().getRoot().accept(iResource -> {
                if (iResource.isAccessible()) {
                    this.storeMetaData(iResource, null, true);
                    this.getMetaData(iResource, false, true);
                }
                return true;
            });
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static class GenericFileInfo
    extends GamaFileMetaData {
        final String suffix;

        public GenericFileInfo(long l, String string) {
            super(l);
            this.suffix = string;
        }

        public GenericFileInfo(String string) {
            super(string);
            String[] stringArray = this.split(string);
            this.suffix = stringArray[1];
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void appendSuffix(StringBuilder stringBuilder) {
            if (this.suffix != null) {
                stringBuilder.append(this.suffix);
            }
        }

        public String toPropertyString() {
            return super.toPropertyString() + "_!_" + this.suffix;
        }

        public IGamlDescription.Doc getDocumentation() {
            return new IGamlDescription.ConstantDoc(this.suffix);
        }
    }

    public static class ProjectInfo
    extends GamaFileMetaData {
        final String comment;

        public ProjectInfo(IProject iProject) throws CoreException {
            super(iProject.getModificationStamp());
            IProjectDescription iProjectDescription = iProject.getDescription();
            this.comment = iProjectDescription.getComment();
        }

        public ProjectInfo(String string) {
            super(string);
            String[] stringArray = this.split(string);
            this.comment = stringArray[1];
        }

        public String getSuffix() {
            if (this.comment == null || this.comment.isEmpty()) {
                return "";
            }
            return this.comment;
        }

        public void appendSuffix(StringBuilder stringBuilder) {
            if (this.comment != null && !this.comment.isEmpty()) {
                stringBuilder.append(this.comment);
            }
        }

        public String toPropertyString() {
            return super.toPropertyString() + "_!_" + this.comment;
        }

        public IGamlDescription.Doc getDocumentation() {
            return new IGamlDescription.ConstantDoc(this.comment);
        }
    }
}

