/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.dev.DEBUG;
import gama.gaml.operators.Cast;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.ParameterExpandBar;
import gama.ui.shared.controls.ParameterExpandItem;
import gama.ui.shared.dialogs.Messages;
import gama.ui.shared.interfaces.IParameterEditor;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.parameters.EditorFactory;
import gama.ui.shared.parameters.EditorLabel;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public class GamaPreferencesView {
    static final Pref<GamaPoint> DIALOG_LOCATION;
    static final Pref<GamaPoint> DIALOG_SIZE;
    static final Pref<Integer> DIALOG_TAB;
    public static final Map<String, Image> prefs_images;
    public static final int NB_DIVISIONS = 2;
    static GamaPreferencesView instance;
    static boolean restartRequired;
    Shell parentShell;
    Shell shell;
    CTabFolder tabFolder;
    final Map<String, IParameterEditor> editors = new LinkedHashMap<String, IParameterEditor>();
    final Map<String, Object> modelValues = new LinkedHashMap<String, Object>();
    final Map<String, Boolean> activations = new HashMap<String, Boolean>();

    static {
        DEBUG.ON();
        DIALOG_LOCATION = GamaPreferences.create((String)"dialog_location", (String)"Location of the preferences dialog on screen", (Object)new GamaPoint(-1.0, -1.0), (int)7, (boolean)false).hidden();
        DIALOG_SIZE = GamaPreferences.create((String)"dialog_size", (String)"Size of the preferences dialog on screen", (Object)new GamaPoint(-1.0, -1.0), (int)7, (boolean)false).hidden();
        DIALOG_TAB = GamaPreferences.create((String)"dialog_tab", (String)"Tab selected in the preferences dialog", (Object)-1, (int)1, (boolean)false).hidden();
        prefs_images = new LinkedHashMap<String, Image>();
        prefs_images.put("Interface", GamaIcon.named("prefs/prefs.general2").image());
        prefs_images.put("Editors", GamaIcon.named("prefs/prefs.editor2").image());
        prefs_images.put("Execution", GamaIcon.named("prefs/prefs.simulations2").image());
        prefs_images.put("Simulations", GamaIcon.named("prefs/prefs.runtime2").image());
        prefs_images.put("Displays", GamaIcon.named("prefs/prefs.ui2").image());
        prefs_images.put("Data and Operators", GamaIcon.named("prefs/prefs.libraries2").image());
    }

    public static void show() {
        if (instance == null || GamaPreferencesView.instance.shell == null || GamaPreferencesView.instance.shell.isDisposed()) {
            instance = new GamaPreferencesView(WorkbenchHelper.getShell());
        }
        for (IParameterEditor iParameterEditor : GamaPreferencesView.instance.editors.values()) {
            iParameterEditor.updateWithValueOfParameter(true, false);
        }
        instance.open();
    }

    public static void preload() {
        DEBUG.TIMER((String)"GAMA", (String)"Preloading preferences view", (String)"done in", () -> WorkbenchHelper.run(() -> {
            if (instance == null || GamaPreferencesView.instance.shell == null || GamaPreferencesView.instance.shell.isDisposed()) {
                instance = new GamaPreferencesView(WorkbenchHelper.getShell());
            }
            for (IParameterEditor iParameterEditor : GamaPreferencesView.instance.editors.values()) {
                iParameterEditor.updateWithValueOfParameter(false, false);
            }
        }), (Consumer[])new Consumer[0]);
    }

    private GamaPreferencesView(Shell shell) {
        this.parentShell = shell;
        this.shell = new Shell(this.parentShell, 65584);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).spacing(5, 5).applyTo((Composite)this.shell);
        this.tabFolder = new CTabFolder((Composite)this.shell, 136);
        this.tabFolder.setBorderVisible(true);
        this.tabFolder.setMRUVisible(true);
        this.tabFolder.setSimple(false);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.tabFolder);
        Map map = GamaPreferences.organizePrefs();
        for (String string : map.keySet()) {
            CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
            cTabItem.setText(string);
            cTabItem.setImage(prefs_images.get(string));
            cTabItem.setShowClose(false);
            this.buildContentsFor(cTabItem, (Map)map.get(string));
        }
        this.buildButtons();
        this.shell.layout();
    }

    private void buildContentsFor(CTabItem cTabItem, Map<String, List<Pref<?>>> map) {
        ParameterExpandBar parameterExpandBar = new ParameterExpandBar((Composite)cTabItem.getParent(), 512);
        parameterExpandBar.setBackground(!ThemeHelper.isDark() ? IGamaColors.VERY_LIGHT_GRAY.color() : IGamaColors.DARK_GRAY.darker());
        parameterExpandBar.setSpacing(5);
        cTabItem.setControl((Control)parameterExpandBar);
        for (String string : map.keySet()) {
            ParameterExpandItem parameterExpandItem = new ParameterExpandItem(parameterExpandBar, map.get(string), 0, null);
            parameterExpandItem.setText(string);
            Composite composite = new Composite((Composite)parameterExpandBar, 0);
            parameterExpandItem.setControl(composite);
            this.buildGroupContents(composite, map.get(string));
            parameterExpandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
            parameterExpandItem.setExpanded(true);
        }
    }

    void checkActivables(Pref pref, Boolean bl) {
        IParameterEditor iParameterEditor;
        String string;
        String[] stringArray = pref.getEnablement();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            iParameterEditor = this.editors.get(string);
            if (iParameterEditor == null) {
                this.activations.put(string, bl);
            } else if (WorkbenchHelper.isDisplayThread()) {
                iParameterEditor.setActive(bl);
            }
            ++n2;
        }
        stringArray = pref.getDisablement();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            iParameterEditor = this.editors.get(string);
            if (iParameterEditor == null) {
                this.activations.put(string, bl == false);
            } else if (WorkbenchHelper.isDisplayThread()) {
                iParameterEditor.setActive(bl == false);
            }
            ++n2;
        }
    }

    void checkRefreshables(Pref pref) {
        if (!WorkbenchHelper.isDisplayThread()) {
            return;
        }
        String[] stringArray = pref.getRefreshment();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            IParameterEditor iParameterEditor = this.editors.get(string);
            if (iParameterEditor != null && WorkbenchHelper.isDisplayThread()) {
                iParameterEditor.updateWithValueOfParameter(false, false);
            }
            ++n2;
        }
    }

    private void buildGroupContents(Composite composite, List<Pref<?>> list) {
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(5, 0).equalWidth(true).applyTo(composite);
        EditorsGroup[] editorsGroupArray = new EditorsGroup[2];
        int n = 0;
        while (n < 2) {
            editorsGroupArray[n] = new EditorsGroup(composite, 0);
            ++n;
        }
        n = 0;
        for (Pref<?> object2 : list) {
            this.modelValues.put(object2.getKey(), object2.getValue());
            this.checkActivables(object2, Cast.asBool(null, (Object)object2.getValue()));
            object2.onChange(object -> {
                if (object2.acceptChange(object)) {
                    this.modelValues.put(object2.getKey(), object);
                    Boolean bl = Cast.asBool((IScope)GAMA.getPlatformAgent().getScope(), (Object)object);
                    this.checkActivables((Pref)object2, bl);
                    this.checkRefreshables((Pref)object2);
                    if (object2.isRestartRequired()) {
                        GamaPreferencesView.setRestartRequired();
                    }
                } else {
                    this.showError(String.valueOf(object) + " is not accepted for parameter " + object2.getKey());
                }
            });
            boolean bl = this.activations.containsKey(object2.getKey());
            AbstractEditor abstractEditor = EditorFactory.create(GAMA.getPlatformAgent().getScope(), editorsGroupArray[(int)((double)n * (2.0 / (double)list.size()))], object2, bl);
            if (object2.isDisabled()) {
                abstractEditor.setActive(false);
            } else {
                Menu menu = GamaPreferencesView.getMenuFor(object2, abstractEditor);
                EditorLabel editorLabel = abstractEditor.getLabel();
                editorLabel.setMenu(menu);
            }
            this.editors.put(object2.getKey(), abstractEditor);
            ++n;
        }
        for (String string : this.activations.keySet()) {
            IParameterEditor iParameterEditor = this.editors.get(string);
            if (iParameterEditor == null) continue;
            iParameterEditor.setActive(this.activations.get(string));
        }
        this.activations.clear();
        composite.layout();
        composite.pack(true);
    }

    private static Menu getMenuFor(Pref pref, AbstractEditor abstractEditor) {
        MenuItem menuItem;
        Menu menu = abstractEditor.getLabel().createMenu();
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setEnabled(false);
        if (pref.inGaml()) {
            menuItem2.setText("Use gama." + pref.getKey() + " in GAML");
            new MenuItem(menu, 2);
            menuItem = new MenuItem(menu, 8);
            menuItem.setText("Copy name to clipboard");
            menuItem.addSelectionListener(selectionEvent -> WorkbenchHelper.copy("gama." + pref.getKey()));
        } else {
            menuItem2.setText("Not assignable from GAML");
            new MenuItem(menu, 2);
        }
        menuItem = new MenuItem(menu, 8);
        menuItem.setText("Revert to default value");
        menuItem.addSelectionListener(selectionEvent -> {
            pref.set(pref.getInitialValue(GAMA.getRuntimeScope()));
            abstractEditor.updateWithValueOfParameter(true, false);
        });
        return menu;
    }

    protected void showError(String string) {
        DEBUG.LOG((Object)("Error in preferences : " + string));
    }

    private void buildButtons() {
        Label label = new Label((Composite)this.shell, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        label.setText("Some preferences can also be set in GAML, using 'gama.pref_name <- new_value;'. 'pref_name' is displayed in the contextual menu of each preference");
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(1, 3, true, false);
        composite.setLayoutData((Object)gridData);
        Button button = new Button(composite, 0x800008);
        button.setText("Revert to defaults");
        button.setImage(GamaIcon.named("generic/menu.undo").image());
        button.setToolTipText("Restore default values for all preferences");
        Button button2 = new Button(composite, 0x800008);
        button2.setText("Advanced...");
        button2.setToolTipText("Access to advanced preferences");
        Button button3 = new Button(composite, 0x800008);
        button3.setText("Import...");
        button3.setToolTipText("Import preferences from a file...");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(GamaPreferencesView.this.shell, 4096);
                fileDialog.setFilterExtensions(new String[]{"*.prefs"});
                String string = fileDialog.open();
                if (string == null) {
                    return;
                }
                GamaPreferences.applyPreferencesFrom((String)string, GamaPreferencesView.this.modelValues);
                for (IParameterEditor iParameterEditor : GamaPreferencesView.this.editors.values()) {
                    iParameterEditor.updateWithValueOfParameter(true, false);
                }
            }
        });
        Button button4 = new Button(composite, 0x800008);
        button4.setText("Export to GAML");
        button4.setToolTipText("Export preferences to a model that can be run to restore or share them...");
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(GamaPreferencesView.this.shell, 8192);
                fileDialog.setFileName("Preferences.gaml");
                fileDialog.setFilterExtensions(new String[]{"*.gaml"});
                fileDialog.setOverwrite(false);
                String string = fileDialog.open();
                if (string == null) {
                    return;
                }
                GamaPreferences.savePreferencesToGAML((String)string);
            }
        });
        Button button5 = new Button(composite, 0x800008);
        button5.setText("Export to preferences");
        button5.setToolTipText("Export preferences in a format suitable to reimport them in another instance of GAMA");
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(GamaPreferencesView.this.shell, 8192);
                fileDialog.setFileName("gama.prefs");
                fileDialog.setFilterExtensions(new String[]{"*.prefs"});
                fileDialog.setOverwrite(false);
                String string = fileDialog.open();
                if (string == null) {
                    return;
                }
                GamaPreferences.savePreferencesToProperties((String)string);
            }
        });
        Composite composite2 = new Composite((Composite)this.shell, 0);
        composite2.setLayout((Layout)new FillLayout());
        GridData gridData2 = new GridData(3, 3, true, false);
        gridData2.widthHint = 200;
        composite2.setLayoutData((Object)gridData2);
        Button button6 = new Button(composite2, 8);
        button6.setText("Cancel");
        button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GamaPreferencesView.this.close();
            }
        });
        Button button7 = new Button(composite2, 8);
        button7.setText("Save");
        button7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GamaPreferences.setNewPreferences(GamaPreferencesView.this.modelValues);
                if (restartRequired) {
                    restartRequired = false;
                    boolean bl = Messages.confirm("Restart GAMA", "It is advised to restart GAMA after these changes. Restart now ?");
                    if (bl) {
                        GamaPreferencesView.this.close();
                        PlatformUI.getWorkbench().restart(true);
                    }
                } else {
                    GamaPreferencesView.this.close();
                }
            }
        });
        this.shell.setDefaultButton(button7);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!Messages.question("Revert to default", "Do you want to revert all preferences to their default values ? A restart of the platform will be performed immediately")) {
                    return;
                }
                GamaPreferences.revertToDefaultValues(GamaPreferencesView.this.modelValues);
                PlatformUI.getWorkbench().restart(true);
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GamaPreferencesView.this.close();
                WorkbenchHelper.asyncRun(() -> {
                    WorkbenchPreferenceDialog workbenchPreferenceDialog = WorkbenchPreferenceDialog.createDialogOn((Shell)GamaPreferencesView.this.parentShell, null);
                    workbenchPreferenceDialog.open();
                    GamaPreferencesView.this.shell.setVisible(true);
                });
            }
        });
        this.shell.addDisposeListener(disposeEvent -> this.saveDialogProperties());
    }

    void close() {
        this.shell.setVisible(false);
    }

    private void saveLocation() {
        Point point = this.shell.getLocation();
        DIALOG_LOCATION.set((Object)new GamaPoint((double)point.x, (double)point.y)).save();
    }

    private void saveSize() {
        Point point = this.shell.getSize();
        DIALOG_SIZE.set((Object)new GamaPoint((double)point.x, (double)point.y)).save();
    }

    private void saveTab() {
        int n = this.tabFolder.getSelectionIndex();
        DIALOG_TAB.set((Object)n).save();
    }

    private void saveDialogProperties() {
        if (this.shell.isDisposed()) {
            return;
        }
        this.saveLocation();
        this.saveSize();
        this.saveTab();
    }

    public void open() {
        GamaPoint gamaPoint = (GamaPoint)DIALOG_LOCATION.getValue();
        GamaPoint gamaPoint2 = (GamaPoint)DIALOG_SIZE.getValue();
        int n = (Integer)DIALOG_TAB.getValue();
        int n2 = (int)gamaPoint.x;
        int n3 = (int)gamaPoint.y;
        int n4 = (int)gamaPoint2.x;
        int n5 = (int)gamaPoint2.y;
        if (gamaPoint.x == -1.0 || gamaPoint.y == -1.0 || gamaPoint2.x == -1.0 || gamaPoint2.y == -1.0) {
            Point point = this.shell.computeSize(-1, -1, true);
            Rectangle rectangle = WorkbenchHelper.getDisplay().getBounds();
            n4 = Math.min(point.x, rectangle.width - 200);
            n5 = Math.min(point.y, rectangle.height - 200);
            n2 = (rectangle.width - n4) / 2;
            n3 = (rectangle.height - n5) / 2;
        }
        this.tabFolder.setSelection(n);
        this.shell.setLocation(n2, n3);
        this.shell.setSize(n4, n5);
        this.shell.open();
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        this.saveDialogProperties();
    }

    public static void setRestartRequired() {
        restartRequired = true;
    }
}

