/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.csv.text;

import gama.ui.viewers.csv.text.CSVToken;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class CSVTokenScanner
implements ITokenScanner {
    private final char m_delimiter;
    private IDocument m_document;
    private int m_docOffset;
    private int m_docLength;
    private int m_currentOffset;
    private int m_currentColumn;
    private int m_tokenOffset;
    private int m_tokenLength;

    public CSVTokenScanner(char c) {
        this.m_delimiter = c;
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        this.m_document = iDocument;
        this.m_docOffset = n;
        this.m_docLength = n2;
        this.m_currentColumn = 0;
        this.m_currentOffset = n;
        this.m_tokenOffset = n;
        this.m_tokenLength = 0;
    }

    public IToken nextToken() {
        if (this.m_currentOffset >= this.m_docOffset + this.m_docLength) {
            return Token.EOF;
        }
        Object object = Token.UNDEFINED;
        int n = this.m_currentOffset;
        int n2 = 0;
        try {
            IRegion iRegion = this.m_document.getLineInformationOfOffset(this.m_currentOffset);
            int n3 = iRegion.getOffset();
            int n4 = n3 + iRegion.getLength();
            char c = this.m_document.getChar(this.m_currentOffset++);
            ++n2;
            if (c == '\n') {
                object = Token.WHITESPACE;
                this.m_tokenOffset = n;
                this.m_tokenLength = n2;
                this.m_currentColumn = 0;
            } else if (c == this.m_delimiter) {
                object = new CSVToken(CSVToken.CSVTokenType.SEPARATOR, this.m_currentColumn++);
                this.m_tokenOffset = n;
                this.m_tokenLength = n2;
            } else {
                boolean bl = true;
                while (bl) {
                    if (this.m_currentOffset >= n4) {
                        CSVToken.CSVTokenType cSVTokenType = this.m_currentColumn % 2 == 0 ? CSVToken.CSVTokenType.ODD_COLUMN : CSVToken.CSVTokenType.EVEN_COLUMN;
                        object = new CSVToken(cSVTokenType, this.m_currentColumn);
                        this.m_tokenOffset = n;
                        this.m_tokenLength = n2;
                        this.m_currentColumn = 0;
                        bl = false;
                        continue;
                    }
                    char c2 = this.m_document.getChar(this.m_currentOffset);
                    if (c2 == this.m_delimiter) {
                        CSVToken.CSVTokenType cSVTokenType = this.m_currentColumn % 2 == 0 ? CSVToken.CSVTokenType.ODD_COLUMN : CSVToken.CSVTokenType.EVEN_COLUMN;
                        object = new CSVToken(cSVTokenType, this.m_currentColumn);
                        this.m_tokenOffset = n;
                        this.m_tokenLength = n2;
                        bl = false;
                        continue;
                    }
                    ++this.m_currentOffset;
                    ++n2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            object = Token.EOF;
        }
        return object;
    }

    public int getTokenOffset() {
        return this.m_tokenOffset;
    }

    public int getTokenLength() {
        return this.m_tokenLength;
    }
}

