/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis;

import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.GAMA;
import gama.core.util.file.GamaShapeFile;
import gama.dev.DEBUG;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.PreferencesHelper;
import gama.ui.viewers.gis.GISFileViewer;
import gama.ui.viewers.gis.geotools.styling.Mode;
import gama.ui.viewers.gis.geotools.styling.SLDs;
import gama.ui.viewers.gis.geotools.styling.Utils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.MapContent;
import org.geotools.map.StyleLayer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.style.Fill;

public class ShapeFileViewer
extends GISFileViewer {
    Mode mode;
    FeatureTypeStyle fts;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$gama$ui$viewers$gis$geotools$styling$Mode;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
        this.file = fileEditorInput.getFile();
        IPath iPath = fileEditorInput.getPath();
        File file = iPath.makeAbsolute().toFile();
        try {
            this.pathStr = file.getAbsolutePath();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(file.toURI().toURL());
            shapefileDataStore.setCharset(Charset.forName("UTF8"));
            this.content = new MapContent();
            this.featureSource = shapefileDataStore.getFeatureSource();
            this.style = Utils.createStyle2(this.featureSource);
            this.layer = new FeatureLayer((FeatureSource)this.featureSource, this.style);
            this.mode = this.determineMode((SimpleFeatureType)this.featureSource.getSchema(), "Polygon");
            List list = this.style.featureTypeStyles();
            this.fts = list.size() > 0 ? (FeatureTypeStyle)list.get(0) : null;
            if (this.fts != null) {
                this.setFillColor((Color)PreferencesHelper.SHAPEFILE_VIEWER_FILL.getValue(), this.mode, this.fts);
                this.setStrokeColor((Color)PreferencesHelper.SHAPEFILE_VIEWER_LINE_COLOR.getValue(), this.mode, this.fts);
                ((StyleLayer)this.layer).setStyle(this.style);
            }
            this.content.addLayer(this.layer);
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)("Unable to view file " + String.valueOf(iPath)));
        }
        this.setPartName(iPath.lastSegment());
        this.setInput(iEditorInput);
    }

    @Override
    protected void displayInfoString() {
        String string;
        final GamaShapeFile.ShapeInfo shapeInfo = (GamaShapeFile.ShapeInfo)GAMA.getGui().getMetaDataProvider().getMetaData((Object)this.file, false, true);
        if (shapeInfo == null) {
            string = "Error in reading file information";
        } else {
            string = shapeInfo.getSuffix();
            if (shapeInfo.getCRS() == null) {
                this.noCRS = true;
            }
        }
        ToolItem toolItem = this.toolbar.status(string);
        if (shapeInfo != null) {
            ((FlatButton)toolItem.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){
                Menu menu;

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (this.menu == null) {
                        this.menu = new Menu((Decorations)ShapeFileViewer.this.toolbar.getShell(), 8);
                        this.fillMenu();
                    }
                    Point point = ShapeFileViewer.this.toolbar.toDisplay(new Point(selectionEvent.x, selectionEvent.y + ShapeFileViewer.this.toolbar.getSize().y));
                    this.menu.setLocation(point.x, point.y);
                    this.menu.setVisible(true);
                }

                /*
                 * WARNING - void declaration
                 */
                private void fillMenu() {
                    GamaMenu.separate((Menu)this.menu, (String)"Bounds");
                    try {
                        void exception;
                        ReferencedEnvelope object = ShapeFileViewer.this.featureSource.getBounds();
                        Object object2 = new MenuItem(this.menu, 0);
                        object2.setEnabled(false);
                        object2.setText("     - upper corner : " + object.getUpperCorner().getOrdinate(0) + " " + object.getUpperCorner().getOrdinate(1));
                        object2 = new MenuItem(this.menu, 0);
                        object2.setEnabled(false);
                        object2.setText("     - lower corner : " + object.getLowerCorner().getOrdinate(0) + " " + object.getLowerCorner().getOrdinate(1));
                        if (!ShapeFileViewer.this.noCRS) {
                            ReferencedEnvelope exception2 = object.transform(new ProjectionFactory().getTargetCRS(GAMA.getRuntimeScope()), true);
                        }
                        object2 = new MenuItem(this.menu, 0);
                        object2.setEnabled(false);
                        object2.setText("     - dimensions : " + (int)exception.getWidth() + "m x " + (int)exception.getHeight() + "m");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    GamaMenu.separate((Menu)this.menu);
                    GamaMenu.separate((Menu)this.menu, (String)"Attributes");
                    try {
                        for (Map.Entry entry : shapeInfo.getAttributes().entrySet()) {
                            MenuItem menuItem = new MenuItem(this.menu, 0);
                            menuItem.setEnabled(false);
                            menuItem.setText("     - " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    public void setStrokeColor(Color color, Mode mode, FeatureTypeStyle featureTypeStyle) {
        Mode mode2 = mode;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LINE", "POLYGON", "POINT", "ALL"}, (Mode)mode2, n)) {
            case 0: {
                LineSymbolizer lineSymbolizer = SLD.lineSymbolizer((FeatureTypeStyle)featureTypeStyle);
                SLD.setLineColour((LineSymbolizer)lineSymbolizer, (Color)color);
                break;
            }
            case 1: {
                PolygonSymbolizer polygonSymbolizer = SLD.polySymbolizer((FeatureTypeStyle)featureTypeStyle);
                Stroke stroke = new StyleBuilder().createStroke(color);
                polygonSymbolizer.setStroke((org.opengis.style.Stroke)stroke);
                break;
            }
            case 2: 
            case 3: {
                PointSymbolizer pointSymbolizer = SLD.pointSymbolizer((FeatureTypeStyle)featureTypeStyle);
                SLD.setPointColour((PointSymbolizer)pointSymbolizer, (Color)color);
                break;
            }
        }
    }

    public Stroke getStroke(Mode mode, FeatureTypeStyle featureTypeStyle) {
        Mode mode2 = mode;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LINE", "POLYGON", "POINT", "ALL"}, (Mode)mode2, n)) {
            case 0: {
                LineSymbolizer lineSymbolizer = SLD.lineSymbolizer((FeatureTypeStyle)featureTypeStyle);
                return SLD.stroke((LineSymbolizer)lineSymbolizer);
            }
            case 1: {
                PolygonSymbolizer polygonSymbolizer = SLD.polySymbolizer((FeatureTypeStyle)featureTypeStyle);
                return SLD.stroke((PolygonSymbolizer)polygonSymbolizer);
            }
            case 2: 
            case 3: {
                PointSymbolizer pointSymbolizer = SLD.pointSymbolizer((FeatureTypeStyle)featureTypeStyle);
                return SLD.stroke((PointSymbolizer)pointSymbolizer);
            }
        }
        return new StyleBuilder().createStroke();
    }

    public org.geotools.styling.Fill getFill(Mode mode, FeatureTypeStyle featureTypeStyle) {
        if (mode == Mode.POLYGON) {
            PolygonSymbolizer polygonSymbolizer = SLD.polySymbolizer((FeatureTypeStyle)featureTypeStyle);
            return SLD.fill((PolygonSymbolizer)polygonSymbolizer);
        }
        if (mode == Mode.POINT || mode == Mode.ALL) {
            PointSymbolizer pointSymbolizer = SLD.pointSymbolizer((FeatureTypeStyle)featureTypeStyle);
            return SLD.fill((PointSymbolizer)pointSymbolizer);
        }
        return new StyleBuilder().createFill();
    }

    public void setFillColor(Color color, Mode mode, FeatureTypeStyle featureTypeStyle) {
        if (mode == Mode.POLYGON) {
            PolygonSymbolizer polygonSymbolizer = SLD.polySymbolizer((FeatureTypeStyle)featureTypeStyle);
            org.geotools.styling.Fill fill = new StyleBuilder().createFill(color);
            polygonSymbolizer.setFill((Fill)fill);
        } else if (mode == Mode.POINT || mode == Mode.ALL) {
            PointSymbolizer pointSymbolizer = SLD.pointSymbolizer((FeatureTypeStyle)featureTypeStyle);
            SLD.setPointColour((PointSymbolizer)pointSymbolizer, (Color)color);
        }
    }

    public Mode determineMode(SimpleFeatureType simpleFeatureType, String string) {
        if (simpleFeatureType == null) {
            return Mode.NONE;
        }
        if (SLDs.isLine(simpleFeatureType)) {
            return Mode.LINE;
        }
        if (SLDs.isPolygon(simpleFeatureType)) {
            return Mode.POLYGON;
        }
        if (SLDs.isPoint(simpleFeatureType)) {
            return Mode.POINT;
        }
        String string2 = string;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"Polygon", "Line", "Point"}, (Object)string2, n)) {
            case 0: {
                return Mode.POLYGON;
            }
            case 1: {
                return Mode.LINE;
            }
            case 2: {
                return Mode.POINT;
            }
        }
        return Mode.ALL;
    }

    public String[] getColorLabels() {
        if (this.mode == Mode.POLYGON || this.mode == Mode.ALL) {
            return new String[]{"Set line color...", "Set fill color..."};
        }
        return new String[]{"Set line color..."};
    }

    public GamaColors.GamaUIColor getColor(int n) {
        Color color = n == 0 ? SLD.color((Stroke)this.getStroke(this.mode, this.fts)) : SLD.color((org.geotools.styling.Fill)this.getFill(this.mode, this.fts));
        return GamaColors.get((Color)color);
    }

    public void setColor(int n, GamaColors.GamaUIColor gamaUIColor) {
        RGB rGB = gamaUIColor.getRGB();
        Color color = new Color(rGB.red, rGB.green, rGB.blue);
        if (n == 0) {
            this.setStrokeColor(color, this.mode, this.fts);
        } else {
            this.setFillColor(color, this.mode, this.fts);
        }
        ((StyleLayer)this.layer).setStyle(this.style);
    }

    public void saveAsCSV() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertyDescriptor propertyDescriptor : this.layer.getFeatureSource().getSchema().getDescriptors()) {
            arrayList.add(propertyDescriptor.getName().toString());
        }
        this.saveAsCSV(arrayList, null, null);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$gama$ui$viewers$gis$geotools$styling$Mode() {
        if ($SWITCH_TABLE$gama$ui$viewers$gis$geotools$styling$Mode != null) {
            return $SWITCH_TABLE$gama$ui$viewers$gis$geotools$styling$Mode;
        }
        int[] nArray = new int[Mode.values().length];
        try {
            nArray[Mode.ALL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Mode.LINE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Mode.NONE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Mode.POINT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Mode.POLYGON.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$gama$ui$viewers$gis$geotools$styling$Mode = nArray;
        return nArray;
    }
}

