/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis.geotools.styling;

import gama.ui.viewers.gis.geotools.styling.Mode;
import gama.ui.viewers.gis.geotools.styling.SimpleConfigurator;
import gama.ui.viewers.gis.geotools.styling.StolenColorEditor;
import java.awt.Color;
import java.text.MessageFormat;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.styling.Fill;
import org.geotools.styling.SLD;
import org.geotools.styling.StyleBuilder;

public class FillViewer {
    boolean enabled;
    Color color;
    double opacity;
    Button on;
    StolenColorEditor chooser;
    Combo percent;
    Listener sync = new Listener();
    private SelectionListener listener;

    public void addListener(SelectionListener selectionListener) {
        this.listener = selectionListener;
    }

    protected void fire(SelectionEvent selectionEvent) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(selectionEvent);
    }

    public Composite createControl(Composite composite, KeyListener keyListener) {
        Composite composite2 = SimpleConfigurator.subpart(composite, "Fill:");
        this.on = new Button(composite2, 32);
        this.on.addSelectionListener((SelectionListener)this.sync);
        this.chooser = new StolenColorEditor(composite2, this.sync);
        this.percent = new Combo(composite2, 4);
        this.percent.setItems(new String[]{"0%", "25%", "50%", "75%", "100%"});
        this.percent.setTextLimit(4);
        this.percent.addKeyListener(keyListener);
        this.percent.setToolTipText("Fill opacity");
        return composite2;
    }

    public Fill getFill(StyleBuilder styleBuilder) {
        if (!this.enabled) {
            return null;
        }
        if (!Double.isNaN(this.opacity)) {
            return styleBuilder.createFill(this.color, this.opacity);
        }
        return styleBuilder.createFill(this.color);
    }

    void listen(boolean bl) {
        if (bl) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.chooser.setListener(this.sync);
            this.percent.addSelectionListener((SelectionListener)this.sync);
            this.percent.addModifyListener((ModifyListener)this.sync);
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.chooser.setListener(null);
            this.percent.removeSelectionListener((SelectionListener)this.sync);
            this.percent.removeModifyListener((ModifyListener)this.sync);
        }
    }

    public void setFill(Fill fill, Mode mode, Color color) {
        this.listen(false);
        try {
            Object object;
            boolean bl = true;
            Fill fill2 = fill;
            if (fill2 == null) {
                object = new StyleBuilder();
                fill2 = object.createFill(color, 0.5);
                bl = false;
            }
            this.enabled = bl && mode != Mode.NONE && mode != Mode.LINE && fill2 != null;
            this.color = SLD.color((Fill)fill2);
            this.opacity = SLD.opacity((Fill)fill2);
            this.on.setEnabled(mode != Mode.NONE && mode != Mode.LINE);
            this.chooser.setColor(this.color);
            object = MessageFormat.format("{0,number,#0%}", this.opacity);
            this.percent.setText((String)object);
            this.percent.select(this.percent.indexOf((String)object));
            this.on.setSelection(this.enabled);
            this.chooser.setEnabled(this.enabled);
            this.percent.setEnabled(this.enabled);
        }
        finally {
            this.listen(true);
        }
    }

    class Listener
    implements SelectionListener,
    ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.sync(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.sync(selectionEvent);
        }

        public void modifyText(ModifyEvent modifyEvent) {
            this.sync(SimpleConfigurator.selectionEvent(modifyEvent));
        }

        private void sync(SelectionEvent selectionEvent) {
            try {
                try {
                    FillViewer.this.enabled = FillViewer.this.on.getSelection();
                    FillViewer.this.color = FillViewer.this.chooser.getColor();
                    String string = FillViewer.this.percent.getText();
                    if (string.endsWith("%")) {
                        string = string.substring(0, string.length() - 1);
                        FillViewer.this.opacity = Double.parseDouble(string) / 100.0;
                    } else {
                        FillViewer.this.opacity = Double.parseDouble(string);
                        if (FillViewer.this.opacity > 1.0) {
                            FillViewer.this.opacity /= 100.0;
                        }
                    }
                    FillViewer.this.fire(selectionEvent);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    FillViewer.this.chooser.setEnabled(FillViewer.this.enabled);
                    FillViewer.this.percent.setEnabled(FillViewer.this.enabled);
                }
            }
            finally {
                FillViewer.this.chooser.setEnabled(FillViewer.this.enabled);
                FillViewer.this.percent.setEnabled(FillViewer.this.enabled);
            }
        }
    }
}

