/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis.geotools.styling;

import java.awt.Color;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class StolenColorEditor {
    final Point fExtent;
    Image fImage;
    RGB fColorValue;
    org.eclipse.swt.graphics.Color fColor;
    final Button fButton;
    SelectionListener listener;

    public StolenColorEditor(Composite composite, SelectionListener selectionListener) {
        this.listener = selectionListener;
        this.fButton = new Button(composite, 8);
        this.fExtent = this.computeImageSize((Control)composite);
        this.fImage = new Image((Device)composite.getDisplay(), this.fExtent.x, this.fExtent.y);
        GC gC = new GC((Drawable)this.fImage);
        gC.setBackground(this.fButton.getBackground());
        gC.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
        gC.dispose();
        this.fButton.setImage(this.fImage);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(StolenColorEditor.this.fButton.getShell());
                colorDialog.setRGB(StolenColorEditor.this.fColorValue);
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    StolenColorEditor.this.fColorValue = rGB;
                    StolenColorEditor.this.updateColorImage();
                }
                StolenColorEditor.this.notifyParent(selectionEvent);
            }
        });
        this.fButton.addDisposeListener(disposeEvent -> {
            if (this.fImage != null) {
                this.fImage.dispose();
                this.fImage = null;
            }
            if (this.fColor != null) {
                this.fColor.dispose();
                this.fColor = null;
            }
        });
    }

    public void setListener(SelectionListener selectionListener) {
        this.listener = selectionListener;
    }

    void notifyParent(SelectionEvent selectionEvent) {
        if (this.listener != null) {
            this.listener.widgetSelected(selectionEvent);
        }
    }

    public Color getColor() {
        RGB rGB = this.getColorValue();
        return new Color(rGB.red, rGB.green, rGB.blue);
    }

    public void setColor(Color color) {
        if (color == null) {
            this.setColorValue(null);
        } else {
            RGB rGB = new RGB(color.getRed(), color.getGreen(), color.getBlue());
            this.setColorValue(rGB);
        }
    }

    public void setEnabled(boolean bl) {
        this.getButton().setEnabled(bl);
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void setColorValue(RGB rGB) {
        this.fColorValue = rGB == null ? new RGB(0, 0, 0) : rGB;
        this.updateColorImage();
    }

    public Button getButton() {
        return this.fButton;
    }

    protected void updateColorImage() {
        Display display = this.fButton.getDisplay();
        GC gC = new GC((Drawable)this.fImage);
        gC.setForeground(display.getSystemColor(2));
        gC.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
        if (this.fColor != null) {
            this.fColor.dispose();
        }
        this.fColor = new org.eclipse.swt.graphics.Color((Device)display, this.fColorValue);
        gC.setBackground(this.fColor);
        gC.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
        gC.dispose();
        this.fButton.setImage(this.fImage);
    }

    protected Point computeImageSize(Control control) {
        GC gC = new GC((Drawable)control);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gC.setFont(font);
        int n = gC.getFontMetrics().getHeight();
        gC.dispose();
        Point point = new Point(n * 3 - 6, n);
        return point;
    }
}

