/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.linking;

import com.google.inject.Inject;
import gama.core.runtime.IExecutionContext;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.GamlDefinition;
import gaml.compiler.gaml.GamlPackage;
import gaml.compiler.gaml.resource.GamlResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScope;

public class GamlLinkingService
extends DefaultLinkingService {
    private static final Map<EClass, Map<String, List<EObject>>> STUB_NAMES = new ConcurrentHashMap<EClass, Map<String, List<EObject>>>();
    private static Resource STUB_RESOURCE;
    @Inject
    private XtextResourceSet resourceSet;

    public List<EObject> addSymbol(String string, EClass eClass) {
        List<EObject> list;
        Map<String, List<EObject>> map = STUB_NAMES.get(eClass);
        if (map == null) {
            map = new ConcurrentHashMap<String, List<EObject>>();
            STUB_NAMES.put(eClass, map);
        }
        if ((list = map.get(string)) == null) {
            EObject eObject = this.create(string, eClass);
            this.getResource().getContents().add((Object)eObject);
            list = Collections.singletonList(eObject);
            map.put(string, list);
        }
        return list;
    }

    public EObject create(String string, EClass eClass) {
        GamlDefinition gamlDefinition = (GamlDefinition)EGaml.getInstance().getFactory().create(eClass);
        gamlDefinition.setName(string);
        return gamlDefinition;
    }

    private Resource getResource() {
        if (STUB_RESOURCE == null) {
            STUB_RESOURCE = this.resourceSet.createResource(URI.createURI((String)"gaml:/newSymbols.xmi", (boolean)false));
        }
        return STUB_RESOURCE;
    }

    protected IScope getScope(EObject eObject, EReference eReference) {
        try {
            this.registerImportedNamesAdapter(eObject);
            IScope iScope = this.getScopeProvider().getScope(eObject, eReference);
            return iScope;
        }
        finally {
            this.unRegisterImportedNamesAdapter();
        }
    }

    public List<EObject> getLinkedObjects(EObject eObject, EReference eReference, INode iNode) throws IllegalNodeException {
        List list = super.getLinkedObjects(eObject, eReference, iNode);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        String string = this.getCrossRefNodeAsString(iNode);
        EClass eClass = eReference.getEReferenceType();
        if (GamlPackage.eINSTANCE.getTypeDefinition().isSuperTypeOf(eClass) || GamlPackage.eINSTANCE.getActionDefinition().isSuperTypeOf(eClass) || GamlPackage.eINSTANCE.getVarDefinition().isSuperTypeOf(eClass)) {
            return this.addSymbol(string, eReference.getEReferenceType());
        }
        GamlResource gamlResource = (GamlResource)eObject.eResource();
        IExecutionContext iExecutionContext = (IExecutionContext)gamlResource.getCache().getOrCreate((Resource)gamlResource).get((Object)"linking");
        if (iExecutionContext != null && iExecutionContext.hasLocalVar(string)) {
            return Collections.singletonList(this.create(string, eReference.getEReferenceType()));
        }
        return Collections.EMPTY_LIST;
    }
}

