/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common;

import gama.core.common.interfaces.IConsoleListener;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.util.GamaColor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CompositeConsoleListener
implements IConsoleListener {
    List<IConsoleListener> consoles = new CopyOnWriteArrayList<IConsoleListener>();

    @Override
    public void addConsoleListener(IConsoleListener iConsoleListener) {
        if (iConsoleListener == null || this.consoles.contains(iConsoleListener)) {
            return;
        }
        this.consoles.add(iConsoleListener);
    }

    @Override
    public void removeConsoleListener(IConsoleListener iConsoleListener) {
        this.consoles.remove(iConsoleListener);
    }

    @Override
    public void informConsole(String string, ITopLevelAgent iTopLevelAgent, GamaColor gamaColor) {
        for (IConsoleListener iConsoleListener : this.consoles) {
            iConsoleListener.informConsole(string, iTopLevelAgent, gamaColor);
        }
    }

    @Override
    public void toggleConsoleViews(ITopLevelAgent iTopLevelAgent, boolean bl) {
        for (IConsoleListener iConsoleListener : this.consoles) {
            iConsoleListener.toggleConsoleViews(iTopLevelAgent, bl);
        }
    }

    @Override
    public void eraseConsole(boolean bl) {
        for (IConsoleListener iConsoleListener : this.consoles) {
            iConsoleListener.eraseConsole(bl);
        }
    }
}

