/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import com.google.common.collect.Iterators;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GamaCoordinateSequence;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Rotation3D;
import gama.core.metamodel.shape.GamaPoint;
import java.util.Arrays;
import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class UnboundedCoordinateSequence
implements ICoordinates {
    final int dimension;
    static final int INITIAL_SIZE = 1000;
    GamaPoint[] points = null;
    int nbPoints;
    final GamaPoint temp = new GamaPoint();

    private void fillFrom(int n) {
        int n2 = n;
        while (n2 < this.points.length) {
            this.points[n2] = new GamaPoint();
            ++n2;
        }
    }

    public UnboundedCoordinateSequence() {
        this(3);
    }

    public UnboundedCoordinateSequence(int n) {
        this.dimension = n;
        this.growTo(1000);
    }

    private void growTo(int n) {
        int n2 = 0;
        if (this.points == null) {
            this.points = new GamaPoint[n];
        } else {
            if (n <= this.points.length) {
                return;
            }
            n2 = this.points.length;
            this.points = Arrays.copyOf(this.points, Math.max(n, n2 + n2 / 2));
        }
        this.fillFrom(n2);
    }

    public int getDimension() {
        return 3;
    }

    UnboundedCoordinateSequence(int n, boolean bl, int n2, GamaPoint[] gamaPointArray) {
        this.dimension = n;
        this.growTo(n2);
        this.nbPoints = n2;
        int n3 = 0;
        while (n3 < n2) {
            this.points[n3].setLocation(gamaPointArray[n3]);
            ++n3;
        }
        if (bl) {
            this.ensureClockwiseness();
        }
    }

    public final UnboundedCoordinateSequence copy() {
        return new UnboundedCoordinateSequence(this.dimension, true, this.nbPoints, this.points);
    }

    @Override
    @Deprecated
    public UnboundedCoordinateSequence clone() {
        return this.copy();
    }

    public Coordinate getCoordinateCopy(int n) {
        return this.points[n].clone();
    }

    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.setCoordinate((Coordinate)this.points[n]);
    }

    public double getX(int n) {
        return this.points[n].x;
    }

    public double getY(int n) {
        return this.points[n].y;
    }

    public double getOrdinate(int n, int n2) {
        return this.points[n].getOrdinate(n2);
    }

    public int size() {
        return this.nbPoints;
    }

    public void setOrdinate(int n, int n2, double d) {
        this.points[n].setOrdinate(n2, d);
    }

    public Envelope expandEnvelope(Envelope envelope) {
        int n = 0;
        while (n < this.nbPoints - 1) {
            envelope.expandToInclude((Coordinate)this.points[n]);
            ++n;
        }
        return envelope;
    }

    @Override
    public Iterator<GamaPoint> iterator() {
        return Iterators.limit((Iterator)Iterators.forArray((Object[])this.points), (int)this.nbPoints);
    }

    @Override
    public void addCenterTo(GamaPoint gamaPoint) {
        int n = this.isRing() ? this.nbPoints - 1 : this.nbPoints;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint2 = this.points[n2];
            d += gamaPoint2.x;
            d2 += gamaPoint2.y;
            d3 += gamaPoint2.z;
            ++n2;
        }
        gamaPoint.x += (d /= (double)n);
        gamaPoint.y += (d2 /= (double)n);
        gamaPoint.z += (d3 /= (double)n);
    }

    @Override
    public GamaPoint getCoordinate(int n) {
        return this.points[n];
    }

    @Override
    public ICoordinates yNegated() {
        int n = this.points.length;
        Coordinate[] coordinateArray = new GamaPoint[n];
        int n2 = 0;
        while (n2 < n) {
            coordinateArray[n2] = this.points[n - n2 - 1].yNegated();
            ++n2;
        }
        return new GamaCoordinateSequence(this.dimension, false, coordinateArray);
    }

    @Override
    public GamaPoint[] toCoordinateArray() {
        return this.points;
    }

    @Override
    public void visit(ICoordinates.IndexedVisitor indexedVisitor, int n, boolean bl) {
        boolean bl2;
        int n2 = n < 0 || n > this.nbPoints ? this.nbPoints : n;
        boolean bl3 = bl2 = this.isRing() && !bl;
        if (bl2) {
            this.reverseVisit(indexedVisitor, n2);
        } else {
            this.visit(indexedVisitor, n2);
        }
    }

    private void visit(ICoordinates.IndexedVisitor indexedVisitor, int n) {
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = this.points[n2];
            indexedVisitor.process(n2, gamaPoint.x, gamaPoint.y, gamaPoint.z);
            ++n2;
        }
    }

    private void reverseVisit(ICoordinates.IndexedVisitor indexedVisitor, int n) {
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            GamaPoint gamaPoint = this.points[n2];
            indexedVisitor.process(n3, gamaPoint.x, gamaPoint.y, gamaPoint.z);
            --n2;
            ++n3;
        }
    }

    @Override
    public void visitClockwise(ICoordinates.VertexVisitor vertexVisitor) {
        int n = this.isRing() ? this.nbPoints - 1 : this.nbPoints;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = this.points[n2];
            vertexVisitor.process(gamaPoint.x, gamaPoint.y, gamaPoint.z);
            ++n2;
        }
    }

    @Override
    public void visitYNegatedCounterClockwise(ICoordinates.VertexVisitor vertexVisitor) {
        int n = this.isRing() ? this.nbPoints - 1 : this.nbPoints;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = this.points[n2];
            vertexVisitor.process(gamaPoint.x, -gamaPoint.y, gamaPoint.z);
            ++n2;
        }
    }

    @Override
    public void visit(ICoordinates.PairVisitor pairVisitor) {
        int n = 0;
        while (n < this.nbPoints - 1) {
            pairVisitor.process(this.points[n], this.points[n + 1]);
            ++n;
        }
    }

    @Override
    public void getNormal(boolean bl, double d, GamaPoint gamaPoint) {
        GamaPoint gamaPoint2;
        gamaPoint.setLocation(0.0, 0.0, 0.0);
        if (this.nbPoints < 3) {
            return;
        }
        int n = 0;
        while (n < this.nbPoints - 1) {
            gamaPoint2 = this.points[n];
            GamaPoint gamaPoint3 = this.points[n + 1];
            gamaPoint.x += (gamaPoint2.y - gamaPoint3.y) * (gamaPoint2.z + gamaPoint3.z);
            gamaPoint.y += (gamaPoint2.z - gamaPoint3.z) * (gamaPoint2.x + gamaPoint3.x);
            gamaPoint.z += (gamaPoint2.x - gamaPoint3.x) * (gamaPoint2.y + gamaPoint3.y);
            ++n;
        }
        if (!this.isRing()) {
            GamaPoint gamaPoint4 = this.points[0];
            gamaPoint2 = this.points[1];
            gamaPoint.x += (gamaPoint4.y - gamaPoint2.y) * (gamaPoint4.z + gamaPoint2.z);
            gamaPoint.y += (gamaPoint4.z - gamaPoint2.z) * (gamaPoint4.x + gamaPoint2.x);
            gamaPoint.z += (gamaPoint4.x - gamaPoint2.x) * (gamaPoint4.y + gamaPoint2.y);
        }
        double d2 = bl ? -gamaPoint.norm() : gamaPoint.norm();
        gamaPoint.divideBy(d2 / d);
    }

    @Override
    public Envelope3D getEnvelopeInto(Envelope3D envelope3D) {
        envelope3D.setToNull();
        this.expandEnvelope(envelope3D);
        return envelope3D;
    }

    @Override
    public double averageZ() {
        double d = 0.0;
        if (this.nbPoints == 0) {
            return d;
        }
        int n = 0;
        while (n < this.nbPoints) {
            d += this.points[n].z;
            ++n;
        }
        return d / (double)this.nbPoints;
    }

    @Override
    public ICoordinates setTo(GamaPoint ... gamaPointArray) {
        this.growTo(gamaPointArray.length);
        this.nbPoints = gamaPointArray.length;
        int n = 0;
        while (n < this.nbPoints) {
            this.points[n].setLocation(gamaPointArray[n]);
            ++n;
        }
        return this;
    }

    @Override
    public ICoordinates setTo(int n, double ... dArray) {
        this.growTo(dArray.length / 3);
        this.nbPoints = dArray.length / 3;
        int n2 = n / 3;
        while (n2 < this.nbPoints) {
            this.points[n2].setLocation(dArray[n2 * 3], dArray[n2 * 3 + 1], dArray[n2 * 3 + 2]);
            ++n2;
        }
        this.ensureClockwiseness();
        return this;
    }

    @Override
    public void replaceWith(int n, double d, double d2, double d3) {
        if (n < 0 || n >= this.nbPoints) {
            return;
        }
        this.points[n].setLocation(d, d2, d3);
    }

    @Override
    public GamaPoint directionBetweenLastPointAndOrigin() {
        GamaPoint gamaPoint = new GamaPoint();
        GamaPoint gamaPoint2 = this.points[0];
        int n = this.nbPoints - 1;
        while (n > 0) {
            if (!this.points[n].equals(gamaPoint2)) {
                gamaPoint.setLocation(this.points[n]).subtract(gamaPoint2).normalize();
                return gamaPoint;
            }
            --n;
        }
        return gamaPoint;
    }

    @Override
    public void applyRotation(Rotation3D rotation3D) {
        int n = 0;
        while (n < this.nbPoints) {
            rotation3D.applyTo(this.points[n]);
            ++n;
        }
    }

    @Override
    public boolean isHorizontal() {
        double d = this.points[0].z;
        int n = 1;
        while (n < this.nbPoints) {
            if (this.points[n].z != d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public double getLength() {
        double d = 0.0;
        int n = 1;
        while (n < this.nbPoints) {
            d += this.points[n].euclidianDistanceTo(this.points[n - 1]);
            ++n;
        }
        return d;
    }

    @Override
    public void setAllZ(double d) {
        int n = 0;
        while (n < this.nbPoints) {
            this.points[n].z = d;
            ++n;
        }
    }

    @Override
    public boolean isCoveredBy(Envelope3D envelope3D) {
        int n = 0;
        while (n < this.nbPoints) {
            if (!envelope3D.covers(this.points[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean isClockwise() {
        return this.signedArea() > 0.0;
    }

    @Override
    public void completeRing() {
        this.points[this.nbPoints++] = this.points[0];
    }

    @Override
    public void translateBy(double d, double d2, double d3) {
        int n = 0;
        while (d < (double)this.nbPoints) {
            this.points[n].add(d, d2, d3);
            ++n;
        }
    }

    @Override
    public void ensureClockwiseness() {
        if (this.isRing() && this.signedArea() <= 0.0) {
            this.reverse();
        }
    }

    public boolean isRing() {
        if (this.nbPoints < 4) {
            return false;
        }
        return this.points[0].equals(this.points[this.nbPoints - 1]);
    }

    public double signedArea() {
        if (this.nbPoints < 3) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = this.points[0].x;
        int n = 1;
        while (n < this.nbPoints - 1) {
            double d3 = this.points[n].x - d2;
            double d4 = this.points[n + 1].y;
            double d5 = this.points[n - 1].y;
            d += d3 * (d5 - d4);
            ++n;
        }
        return d / 2.0;
    }

    public void setToYNegated(ICoordinates iCoordinates) {
        this.growTo(iCoordinates.size());
        this.nbPoints = iCoordinates.size();
        int n = 0;
        for (GamaPoint gamaPoint : iCoordinates) {
            this.points[n++].setLocation(gamaPoint.x, -gamaPoint.y, gamaPoint.z);
        }
        if (this.isRing()) {
            this.reverse();
        }
    }

    public void setTo(ICoordinates iCoordinates) {
        this.growTo(iCoordinates.size());
        this.nbPoints = iCoordinates.size();
        int n = 0;
        for (GamaPoint gamaPoint : iCoordinates) {
            this.points[n++].setLocation(gamaPoint);
        }
    }

    public void reverse() {
        int n = this.nbPoints - 1;
        int n2 = 0;
        while (n >= this.nbPoints / 2) {
            this.temp.setLocation(this.points[n]);
            this.points[n].setLocation(this.points[n2]);
            this.points[n2].setLocation(this.temp);
            ++n2;
            --n;
        }
    }
}

