/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import gama.core.common.interfaces.ISkill;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaUtils {
    public static final Map<Integer, List<Class>> IMPLEMENTATION_CLASSES = new HashMap<Integer, List<Class>>();
    private static Multimap<Class, Class> INTERFACES = HashMultimap.create();
    private static Multimap<Class, Class> SUPERCLASSES = HashMultimap.create();

    private static int keyOf(Class clazz, Iterable<Class<? extends ISkill>> iterable) {
        int n = clazz.hashCode();
        for (Class<? extends ISkill> clazz2 : iterable) {
            n += clazz2.hashCode();
        }
        return n;
    }

    private static final Set<Class> allInterfacesOf(Class clazz, Set<Class> set) {
        if (clazz == null) {
            return Collections.EMPTY_SET;
        }
        if (!INTERFACES.containsKey((Object)clazz)) {
            Class<?>[] classArray;
            Class<?>[] classArray2 = classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz2 = classArray2[n2];
                if (set.contains(clazz2)) {
                    INTERFACES.put((Object)clazz, clazz2);
                    INTERFACES.putAll((Object)clazz, JavaUtils.allInterfacesOf(clazz2, set));
                }
                ++n2;
            }
            INTERFACES.putAll((Object)clazz, JavaUtils.allInterfacesOf(clazz.getSuperclass(), set));
        }
        return (Set)INTERFACES.get((Object)clazz);
    }

    private static final Set<Class> allSuperclassesOf(Class clazz, Set<Class> set) {
        if (clazz == null) {
            return null;
        }
        if (!SUPERCLASSES.containsKey((Object)clazz)) {
            Class clazz2 = clazz.getSuperclass();
            while (clazz2 != null) {
                if (set.contains(clazz2)) {
                    SUPERCLASSES.put((Object)clazz, clazz2);
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
        return (Set)SUPERCLASSES.get((Object)clazz);
    }

    public static List<Class> collectImplementationClasses(Class clazz3, Iterable<Class<? extends ISkill>> iterable, Set<Class> set) {
        int n = JavaUtils.keyOf(clazz3, iterable);
        if (!IMPLEMENTATION_CLASSES.containsKey(n)) {
            Iterable iterable2 = Iterables.concat(Collections.singleton(clazz3), iterable, (Iterable)Iterables.concat((Iterable)Iterables.transform(iterable, clazz -> JavaUtils.allInterfacesOf(clazz, set))), JavaUtils.allInterfacesOf(clazz3, set));
            Iterable iterable3 = Iterables.concat((Iterable)Iterables.transform((Iterable)iterable2, clazz -> JavaUtils.allSuperclassesOf(clazz, set)));
            HashSet hashSet = Sets.newHashSet((Iterable)Iterables.concat((Iterable)iterable2, (Iterable)iterable3));
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList, (clazz, clazz2) -> {
                if (clazz == clazz2) {
                    return 0;
                }
                if (clazz.isAssignableFrom((Class<?>)clazz2)) {
                    return -1;
                }
                if (clazz2.isAssignableFrom((Class<?>)clazz)) {
                    return 1;
                }
                if (clazz.isInterface() && !clazz2.isInterface()) {
                    return -1;
                }
                if (clazz2.isInterface()) {
                    clazz.isInterface();
                }
                return 1;
            });
            IMPLEMENTATION_CLASSES.put(n, arrayList);
        }
        return IMPLEMENTATION_CLASSES.get(n);
    }
}

