/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IKeyword;
import gama.core.kernel.batch.IExploration;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.AbstractGamlAdditions;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@GamlAnnotations.inside(kinds={13})
public abstract class AOptimizationAlgorithm
extends Symbol
implements IExploration {
    public static final short C_MAX = 0;
    public static final short C_MIN = 1;
    public static final short C_MEAN = 2;
    public static final String[] COMBINATIONS = new String[]{"maximum", "minimum", "average"};
    protected HashMap<ParametersSet, Double> testedSolutions;
    protected IExpression fitnessExpression;
    protected boolean isMaximize;
    protected ParametersSet bestSolution = null;
    protected Double bestFitness = null;
    protected short combination;

    static {
        AbstractGamlAdditions._constants(new String[][]{COMBINATIONS});
    }

    protected abstract ParametersSet findBestSolution(IScope var1) throws GamaRuntimeException;

    @Override
    public void initializeFor(IScope iScope, BatchAgent batchAgent) throws GamaRuntimeException {
    }

    protected void initializeTestedSolutions() {
        this.testedSolutions = new HashMap();
    }

    protected void initParams() {
        GAMA.run(new GAMA.InScope.Void(){

            @Override
            public void process(IScope iScope) {
                AOptimizationAlgorithm.this.initParams(iScope);
            }
        });
    }

    protected void initParams(IScope iScope) {
    }

    public AOptimizationAlgorithm(IDescription iDescription) {
        super(iDescription);
        this.initializeTestedSolutions();
        this.fitnessExpression = this.getFacet("maximize", "minimize");
        this.isMaximize = this.hasFacet("maximize");
        String string = this.getLiteral("aggregation");
        this.combination = "max".equals(string) ? 0 : ("min".equals(string) ? 1 : 2);
        this.bestFitness = this.isMaximize ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    @Override
    public void run(IScope iScope) {
        try {
            this.findBestSolution(iScope);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            GAMA.reportError(iScope, gamaRuntimeException, false);
        }
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, final BatchAgent batchAgent) {
        list.add(new ParameterAdapter("Parameter space", "Calibration experiment", "", 4){

            @Override
            public String value() {
                BatchAgent batchAgent = AOptimizationAlgorithm.this.getCurrentExperiment();
                if (batchAgent == null) {
                    return "-";
                }
                Map<String, IParameter.Batch> map = batchAgent.getSpecies().getExplorableParameters();
                if (map.isEmpty()) {
                    return "1";
                }
                Object object = "";
                int n = 1;
                for (Map.Entry<String, IParameter.Batch> entry : map.entrySet()) {
                    object = (String)object + entry.getKey() + " (";
                    int n2 = this.getExplorationDimension(entry.getValue());
                    n *= n2;
                    object = (String)object + String.valueOf(n2) + ") * ";
                }
                object = ((String)object).substring(0, ((String)object).length() - 2);
                object = (String)object + " = " + n;
                return object;
            }

            int getExplorationDimension(IParameter.Batch batch) {
                IScope iScope;
                BatchAgent batchAgent = AOptimizationAlgorithm.this.getCurrentExperiment();
                IScope iScope2 = iScope = batchAgent == null ? GAMA.getRuntimeScope() : batchAgent.getScope();
                if (batch.getAmongValue(iScope) != null) {
                    return batch.getAmongValue(iScope).size();
                }
                return (int)((Cast.asFloat(iScope, batch.getMaxValue(iScope)) - Cast.asFloat(iScope, batch.getMinValue(iScope))) / Cast.asFloat(iScope, batch.getStepValue(iScope))) + 1;
            }
        });
        list.add(new ParameterAdapter("Last parameter set tested", "Calibration experiment", "", 4){

            @Override
            public String value() {
                BatchAgent batchAgent = AOptimizationAlgorithm.this.getCurrentExperiment();
                if (batchAgent == null || batchAgent.getLatestSolution() == null) {
                    return "-";
                }
                return batchAgent.getLatestSolution().toString();
            }
        });
        list.add(new ParameterAdapter("Calibration method", "Calibration experiment", 4){

            @Override
            public Object value() {
                String string;
                List<Class> list = Arrays.asList(CLASSES);
                String string2 = IKeyword.METHODS[list.indexOf(AOptimizationAlgorithm.this.getClass())];
                String string3 = AOptimizationAlgorithm.this.fitnessExpression == null ? "" : (string = "fitness = " + (AOptimizationAlgorithm.this.isMaximize ? " maximize " : " minimize ") + AOptimizationAlgorithm.this.fitnessExpression.serializeToGaml(false));
                String string4 = AOptimizationAlgorithm.this.fitnessExpression == null ? "" : (AOptimizationAlgorithm.this.combination == 0 ? " max " : (AOptimizationAlgorithm.this.combination == 1 ? " min " : " average ")) + "of " + batchAgent.getSeeds().length + " simulations";
                return "Method " + string2 + " | " + string + " | compute the" + string4 + " for each solution";
            }
        });
        list.add(new ParameterAdapter("Best parameter set found", "Calibration experiment", "", 4){

            @Override
            public String value() {
                ParametersSet parametersSet = AOptimizationAlgorithm.this.bestSolution;
                if (parametersSet == null) {
                    return "";
                }
                return parametersSet.toString();
            }
        });
        list.add(new ParameterAdapter("Best fitness", "Calibration experiment", "", 4){

            @Override
            public String value() {
                Double d = AOptimizationAlgorithm.this.bestFitness;
                if (d == null) {
                    return "-";
                }
                return d.toString();
            }
        });
    }

    @Override
    public boolean isFitnessBased() {
        return true;
    }

    @Override
    public IExpression getOutputs() {
        return this.getFitnessExpression();
    }

    public Double getBestFitness() {
        return this.bestFitness;
    }

    public IExpression getFitnessExpression() {
        return this.fitnessExpression;
    }

    public ParametersSet getBestSolution() {
        return this.bestSolution;
    }

    public boolean getIsMaximize() {
        return this.isMaximize;
    }

    public short getCombination() {
        return this.combination;
    }

    public boolean isMaximize() {
        return this.isMaximize;
    }

    public String getCombinationName() {
        return COMBINATIONS[this.combination];
    }

    protected void setBestSolution(ParametersSet parametersSet) {
        this.bestSolution = new ParametersSet(parametersSet);
    }

    protected void setBestFitness(Double d) {
        this.bestFitness = d;
    }

    public void updateBestFitness(ParametersSet parametersSet, Double d) {
        if (d == null) {
            return;
        }
        Double d2 = this.getBestFitness();
        if (this.bestSolution == null || (this.isMaximize() ? d > d2 : d < d2)) {
            this.setBestFitness(d);
            this.setBestSolution(parametersSet);
        }
    }

    protected BatchAgent getCurrentExperiment() {
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan == null) {
            return null;
        }
        ExperimentAgent experimentAgent = iExperimentPlan.getAgent();
        if (experimentAgent instanceof BatchAgent) {
            BatchAgent batchAgent = (BatchAgent)experimentAgent;
            return batchAgent;
        }
        return null;
    }

    protected Double getFirstFitness(Map<String, List<Object>> map) {
        double d;
        List<Object> list = map.get("fitness");
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        Object object = list.get(0);
        if (object instanceof Double) {
            Double d2 = (Double)object;
            d = d2;
        } else {
            d = 0.0;
        }
        return d;
    }
}

