/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.batch.StoppingCriterion;
import gama.core.kernel.batch.StoppingCriterionMaxIt;
import gama.core.kernel.batch.optimization.AOptimizationAlgorithm;
import gama.core.kernel.batch.optimization.Particle;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="iter_max", type={1}, optional=false, doc={@GamlAnnotations.doc(value="number of iterations")}), @GamlAnnotations.facet(name="num_particles", type={1}, optional=true, doc={@GamlAnnotations.doc(value="number of particles")}), @GamlAnnotations.facet(name="weight_inertia", type={2}, optional=true, doc={@GamlAnnotations.doc(value="weight for the inertia component")}), @GamlAnnotations.facet(name="weight_cognitive", type={2}, optional=true, doc={@GamlAnnotations.doc(value="weight for the cognitive component")}), @GamlAnnotations.facet(name="weight_social", type={2}, optional=true, doc={@GamlAnnotations.doc(value="weight for the social component")}), @GamlAnnotations.facet(name="maximize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to maximize")}), @GamlAnnotations.facet(name="minimize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to minimize")}), @GamlAnnotations.facet(name="aggregation", type={-200}, optional=true, values={"min", "max", "avr"}, doc={@GamlAnnotations.doc(value="the agregation method")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm is an implementation of the Particle Swarm Optimization algorithm. Only usable for numerical paramaters and based on a continuous parameter space search. See the wikipedia article for more details.", usages={@GamlAnnotations.usage(value="As other batch methods, the basic syntax of the `pso` statement uses `method pso` instead of the expected `pso name: id` : ", examples={@GamlAnnotations.example(value="method pso [facet: value];", isExecutable=false)}), @GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method pso iter_max: 50 num_particles: 10 weight_inertia:0.7 weight_cognitive: 1.5 weight_social: 1.5 maximize: food_gathered; ", isExecutable=false)})})
public class Swarm
extends AOptimizationAlgorithm {
    public static final double DEFAULT_INERTIA = 0.729844;
    public static final double DEFAULT_COGNITIVE = 1.49618;
    public static final double DEFAULT_SOCIAL = 1.49618;
    protected static final String ITER_MAX = "iter_max";
    protected static final String NUM_PARTICLES = "num_particles";
    protected static final String INERTIA_WEIGHT = "weight_inertia";
    protected static final String COGNITIVE_WEIGHT = "weight_cognitive";
    protected static final String SOCIAL_WEIGHT = "weight_social";
    StoppingCriterion stoppingCriterion = null;
    int maxIt;
    int numParticles;
    double weightInertia;
    double weightCognitive;
    double weightSocial;

    public Swarm(IDescription iDescription) {
        super(iDescription);
        this.initParams();
    }

    @Override
    public void initParams(IScope iScope) {
        IExpression iExpression = this.getFacet(ITER_MAX);
        if (iExpression != null) {
            this.maxIt = Cast.asInt(iScope, iExpression.value(iScope));
            this.stoppingCriterion = new StoppingCriterionMaxIt(this.maxIt);
        }
        IExpression iExpression2 = this.getFacet(NUM_PARTICLES);
        this.numParticles = iExpression != null ? Cast.asInt(iScope, iExpression2.value(iScope)) : 10;
        IExpression iExpression3 = this.getFacet(INERTIA_WEIGHT);
        this.weightInertia = iExpression3 != null ? Cast.asFloat(iScope, iExpression3.value(iScope)) : 0.729844;
        IExpression iExpression4 = this.getFacet(COGNITIVE_WEIGHT);
        this.weightCognitive = iExpression4 != null ? Cast.asFloat(iScope, iExpression4.value(iScope)) : 1.49618;
        IExpression iExpression5 = this.getFacet(SOCIAL_WEIGHT);
        this.weightSocial = iExpression5 != null ? Cast.asFloat(iScope, iExpression5.value(iScope)) : 1.49618;
    }

    @Override
    public ParametersSet findBestSolution(IScope iScope) throws GamaRuntimeException {
        Particle[] particleArray = this.initialize(iScope);
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return this.getBestSolution();
        }
        int n = 0;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("Iteration", n);
        while (!this.stoppingCriterion.stopSearchProcess(hashtable)) {
            Particle particle;
            int n2;
            int n3;
            Particle[] particleArray2;
            IMap iMap = GamaMapFactory.create();
            if (GamaExecutorService.shouldRunAllSimulationsInParallel(batchAgent) && !batchAgent.getParametersToExplore().isEmpty()) {
                particleArray2 = particleArray;
                n3 = particleArray.length;
                n2 = 0;
                while (n2 < n3) {
                    particle = particleArray2[n2];
                    List<Particle> list = null;
                    list = iMap.containsKey(particle.getPosition()) ? (List)iMap.get(particle.getPosition()) : new ArrayList<Particle>();
                    list.add(particle);
                    iMap.put(particle.getPosition(), list);
                    ++n2;
                }
            }
            this.evaluation(particleArray, iMap);
            particleArray2 = particleArray;
            n3 = particleArray.length;
            n2 = 0;
            while (n2 < n3) {
                particle = particleArray2[n2];
                this.updateVelocity(iScope, particle);
                particle.updatePosition(iScope);
                ++n2;
            }
            hashtable.put("Iteration", ++n);
        }
        return this.getBestSolution();
    }

    public Map<ParametersSet, Double> testSolutions(Collection<ParametersSet> collection) {
        Map<String, Object> map2;
        IMap iMap = GamaMapFactory.create();
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return iMap;
        }
        collection.removeIf(parametersSet -> parametersSet == null);
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        for (Map<String, Object> map2 : collection) {
            if (this.testedSolutions.containsKey(map2)) {
                iMap.put(map2, (Double)this.testedSolutions.get(map2));
                continue;
            }
            arrayList.add((ParametersSet)map2);
        }
        map2 = batchAgent.runSimulationsAndReturnResults(arrayList).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getFirstFitness((Map)entry.getValue())));
        this.testedSolutions.putAll(map2);
        iMap.putAll(map2);
        return iMap;
    }

    public void evaluation(Particle[] particleArray, Map<ParametersSet, List<Particle>> map) {
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return;
        }
        if (GamaExecutorService.shouldRunAllSimulationsInParallel(batchAgent) && !batchAgent.getParametersToExplore().isEmpty()) {
            Map<ParametersSet, Double> map2 = this.testSolutions(map.keySet());
            for (ParametersSet parametersSet : map2.keySet()) {
                for (Particle particle : map.get(parametersSet)) {
                    particle.updatePersonalBest();
                }
            }
        } else {
            int n = 0;
            while (n < this.numParticles) {
                Particle particle = particleArray[n];
                particle.currentVal = particle.eval();
                particle.updatePersonalBest();
                ++n;
            }
        }
    }

    private Particle[] initialize(IScope iScope) {
        Particle[] particleArray = new Particle[this.numParticles];
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return particleArray;
        }
        IMap iMap = GamaMapFactory.create();
        int n = 0;
        while (n < this.numParticles) {
            Particle particle;
            particleArray[n] = particle = new Particle(iScope, batchAgent, this, this.testedSolutions);
            if (GamaExecutorService.shouldRunAllSimulationsInParallel(batchAgent) && !batchAgent.getParametersToExplore().isEmpty()) {
                List<Particle> list = null;
                list = iMap.containsKey(particle.getPosition()) ? (List)iMap.get(particle.getPosition()) : new ArrayList<Particle>();
                list.add(particle);
                iMap.put(particle.getPosition(), list);
            }
            ++n;
        }
        this.evaluation(particleArray, iMap);
        return particleArray;
    }

    private void updateVelocity(IScope iScope, Particle particle) {
        ParametersSet parametersSet = particle.getVelocity();
        ParametersSet parametersSet2 = new ParametersSet(particle.getBestPosition());
        ParametersSet parametersSet3 = new ParametersSet(this.bestSolution);
        ParametersSet parametersSet4 = particle.getPosition();
        double d = iScope.getRandom().next();
        double d2 = iScope.getRandom().next();
        ParametersSet parametersSet5 = new ParametersSet(parametersSet);
        parametersSet5 = this.mul(iScope, parametersSet5, this.weightInertia);
        parametersSet2 = this.sub(iScope, parametersSet2, parametersSet4);
        parametersSet2 = this.mul(iScope, parametersSet2, this.weightCognitive);
        parametersSet2 = this.mul(iScope, parametersSet2, d);
        parametersSet5 = this.add(iScope, parametersSet5, parametersSet2);
        parametersSet3 = this.sub(iScope, parametersSet3, parametersSet4);
        parametersSet3 = this.mul(iScope, parametersSet3, this.weightSocial);
        parametersSet3 = this.mul(iScope, parametersSet3, d2);
        parametersSet5 = this.add(iScope, parametersSet5, parametersSet3);
        particle.setVelocity(parametersSet5);
    }

    protected ParametersSet mul(IScope iScope, ParametersSet parametersSet, double d) {
        for (String string : parametersSet.keySet()) {
            parametersSet.put(string, (Object)(Cast.asFloat(iScope, parametersSet.get(string)) * d));
        }
        return parametersSet;
    }

    protected ParametersSet sub(IScope iScope, ParametersSet parametersSet, ParametersSet parametersSet2) {
        for (String string : parametersSet.keySet()) {
            parametersSet.put(string, (Object)(Cast.asFloat(iScope, parametersSet.get(string)) - Cast.asFloat(iScope, parametersSet2.get(string))));
        }
        return parametersSet;
    }

    protected ParametersSet add(IScope iScope, ParametersSet parametersSet, ParametersSet parametersSet2) {
        for (String string : parametersSet.keySet()) {
            parametersSet.put(string, (Object)(Cast.asFloat(iScope, parametersSet.get(string)) + Cast.asFloat(iScope, parametersSet2.get(string))));
        }
        return parametersSet;
    }
}

