/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.agent;

import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.interfaces.IJsonable;
import java.util.LinkedList;
import one.util.streamex.StreamEx;

public record AgentReference(String[] species, Integer[] index, String cached_ref) implements IJsonable
{
    public static final AgentReference NULL = new AgentReference(new String[0], new Integer[0], null);

    public static AgentReference of(IAgent iAgent) {
        if (iAgent == null) {
            return NULL;
        }
        return AgentReference.of(AgentReference.buildSpeciesArray(iAgent), AgentReference.buildIndicesArray(iAgent));
    }

    public static AgentReference of(String string2) {
        Object[] objectArray = string2.split("[\\[\\]\\.]");
        objectArray = (String[])((StreamEx)StreamEx.of((Object[])objectArray).filter(string -> !string.isEmpty())).toArray(String.class);
        int n = objectArray.length / 2;
        String[] stringArray = new String[n];
        Integer[] integerArray = new Integer[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = objectArray[n2 * 2];
            integerArray[n2] = Integer.decode((String)objectArray[n2 * 2 + 1]);
            ++n2;
        }
        return new AgentReference(stringArray, integerArray, string2);
    }

    public static AgentReference of(String[] stringArray, Integer[] integerArray) {
        if (stringArray.length == 0) {
            return NULL;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < stringArray.length) {
            stringBuilder.append(stringArray[n]).append('[').append(integerArray[n]).append(']').append('.');
            ++n;
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        String string = stringBuilder.toString();
        return new AgentReference(stringArray, integerArray, string);
    }

    @Override
    public String toString() {
        return this.cached_ref;
    }

    public IAgent getReferencedAgent(IScope iScope) {
        if (iScope == null) {
            return null;
        }
        IExperimentAgent iExperimentAgent = iScope.getExperiment();
        if (iExperimentAgent == null) {
            return null;
        }
        IPopulation<SimulationAgent> iPopulation = iExperimentAgent.getSimulationPopulation();
        Object object = iPopulation.getOrCreateAgent(iScope, this.index[0]);
        int n = 1;
        while (n < this.index.length) {
            iPopulation = object.getPopulationFor(this.species[n]);
            if (iPopulation == null) {
                return null;
            }
            object = iPopulation.getOrCreateAgent(iScope, this.index[n]);
            ++n;
        }
        return object;
    }

    static String[] buildSpeciesArray(IAgent iAgent) {
        String string;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (iAgent instanceof SimulationAgent) {
            SimulationAgent simulationAgent = (SimulationAgent)iAgent;
            string = "simulation";
        } else {
            string = iAgent.getSpeciesName();
        }
        linkedList.add(string);
        IMacroAgent iMacroAgent = iAgent.getHost();
        while (iMacroAgent != null && !(iMacroAgent instanceof IExperimentAgent)) {
            linkedList.add(0, iMacroAgent.getSpeciesName());
            iMacroAgent = iMacroAgent.getHost();
        }
        return linkedList.toArray(new String[0]);
    }

    static Integer[] buildIndicesArray(IAgent iAgent) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(iAgent.getIndex());
        IMacroAgent iMacroAgent = iAgent.getHost();
        while (iMacroAgent != null && !(iMacroAgent instanceof IExperimentAgent)) {
            linkedList.add(0, iMacroAgent.getIndex());
            iMacroAgent = iMacroAgent.getHost();
        }
        return linkedList.toArray(new Integer[0]);
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.object("agent_reference", this.toString());
    }
}

