/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.core.common.interfaces.IValue;
import gama.core.outputs.layers.charts.ChartDataSet;
import gama.core.outputs.layers.charts.ChartDataSource;
import gama.core.outputs.layers.charts.ChartHistory;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.core.util.IList;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.HashMap;

public class ChartDataSeries {
    final ArrayList<String> cvalues = new ArrayList();
    final ArrayList<Double> xvalues = new ArrayList();
    final ArrayList<Double> yvalues = new ArrayList();
    final ArrayList<Double> svalues = new ArrayList();
    final ArrayList<Double> xerrvaluesmax = new ArrayList();
    final ArrayList<Double> yerrvaluesmax = new ArrayList();
    final ArrayList<Double> xerrvaluesmin = new ArrayList();
    final ArrayList<Double> yerrvaluesmin = new ArrayList();
    GamaColor mycolor;
    GamaColor mymincolor;
    GamaColor mymedcolor;
    ChartDataSource mysource;
    ChartDataSet mydataset;
    String name;
    boolean ongoing_update = false;
    final ArrayList<String> oldcvalues = new ArrayList();
    final ArrayList<Double> oldxvalues = new ArrayList();
    final ArrayList<Double> oldyvalues = new ArrayList();
    final ArrayList<Double> oldsvalues = new ArrayList();

    public boolean isOngoing_update() {
        return this.ongoing_update;
    }

    public ChartDataSet getDataset() {
        return this.mydataset;
    }

    public void setDataset(ChartDataSet chartDataSet) {
        this.mydataset = chartDataSet;
    }

    public String getName() {
        return this.name;
    }

    public ChartDataSource getMysource() {
        return this.mysource;
    }

    public void setMysource(ChartDataSource chartDataSource) {
        this.mysource = chartDataSource;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Comparable getSerieLegend(IScope iScope) {
        return this.name;
    }

    public String getSerieId(IScope iScope) {
        return this.name;
    }

    public String getStyle(IScope iScope) {
        return this.getMysource().getStyle(iScope);
    }

    public GamaColor getMycolor() {
        return this.mycolor;
    }

    public GamaColor getMyMedcolor() {
        return this.mymedcolor;
    }

    public GamaColor getMyMincolor() {
        return this.mymincolor;
    }

    public void setMycolor(GamaColor gamaColor) {
        this.mycolor = gamaColor;
    }

    public void setMyMedcolor(GamaColor gamaColor) {
        this.mymedcolor = gamaColor;
    }

    public void setMyMincolor(GamaColor gamaColor) {
        this.mymincolor = gamaColor;
    }

    public boolean isUseYErrValues() {
        return this.getMysource().useYErrValues;
    }

    public void setUseYErrValues(boolean bl) {
        this.getMysource().useYErrValues = bl;
    }

    public boolean isUseXErrValues() {
        return this.getMysource().useXErrValues;
    }

    public void setUseXErrValues(boolean bl) {
        this.getMysource().useXErrValues = bl;
    }

    public boolean isUseYMinMaxValues() {
        return this.getMysource().useYMinMaxValues;
    }

    public void setUseYMinMaxValues(boolean bl) {
        this.getMysource().useYMinMaxValues = bl;
    }

    public ArrayList<String> getCValues(IScope iScope) {
        if (this.isOngoing_update()) {
            return this.oldcvalues;
        }
        return this.cvalues;
    }

    public ArrayList<Double> getXValues(IScope iScope) {
        if (this.isOngoing_update()) {
            return this.oldxvalues;
        }
        return this.xvalues;
    }

    public ArrayList<Double> getYValues(IScope iScope) {
        if (this.isOngoing_update()) {
            return this.oldyvalues;
        }
        return this.yvalues;
    }

    public ArrayList<Double> getSValues(IScope iScope) {
        if (this.isOngoing_update()) {
            return this.oldsvalues;
        }
        return this.svalues;
    }

    public void clearValues(IScope iScope) {
        this.oldcvalues.clear();
        this.oldcvalues.addAll(this.cvalues);
        this.oldxvalues.clear();
        this.oldxvalues.addAll(this.xvalues);
        this.oldyvalues.clear();
        this.oldyvalues.addAll(this.yvalues);
        this.oldsvalues.clear();
        this.oldsvalues.addAll(this.svalues);
        this.cvalues.clear();
        this.xvalues.clear();
        this.yvalues.clear();
        this.svalues.clear();
        this.xerrvaluesmax.clear();
        this.yerrvaluesmax.clear();
        this.xerrvaluesmin.clear();
        this.yerrvaluesmin.clear();
    }

    private Object getlistvalue(IScope iScope, HashMap hashMap, String string, int n) {
        Object v;
        if (!hashMap.containsKey(string)) {
            return null;
        }
        boolean bl = true;
        if (n < 0) {
            bl = false;
        }
        Object object = v = hashMap.get(string);
        if (v instanceof IExpression) {
            object = ((IExpression)v).value(iScope);
        }
        if (!bl) {
            return object;
        }
        if (object instanceof IList) {
            IList iList = Cast.asList(iScope, object);
            if (iList.size() < n) {
                return null;
            }
            return iList.get(n);
        }
        return object;
    }

    public void addcbwvalue(IScope iScope, String string, double d, double d2, double d3, double d4, double d5, double d6, int n, HashMap hashMap, int n2) {
        Object object;
        this.cvalues.add(string);
        this.yvalues.add(d);
        this.svalues.add(d2);
        this.xerrvaluesmin.add(d3);
        this.xerrvaluesmax.add(d4);
        this.yerrvaluesmin.add(d5);
        this.yerrvaluesmax.add(d6);
        if (hashMap.containsKey("color") && (object = this.getlistvalue(iScope, hashMap, "color", n2)) != null) {
            if (object instanceof IList) {
                IList iList = Cast.asList(iScope, object);
                if (iList.size() == 1) {
                    this.setMycolor(Cast.asColor(iScope, iList.get(0)));
                }
                if (iList.size() == 2) {
                    this.setMycolor(Cast.asColor(iScope, iList.get(1)));
                    this.setMyMincolor(Cast.asColor(iScope, iList.get(0)));
                }
                if (iList.size() > 2) {
                    this.setMyMincolor(Cast.asColor(iScope, iList.get(0)));
                    this.setMyMedcolor(Cast.asColor(iScope, iList.get(1)));
                    this.setMycolor(Cast.asColor(iScope, iList.get(2)));
                }
            } else {
                GamaColor gamaColor = Cast.asColor(iScope, object);
                this.setMycolor(gamaColor);
            }
        }
        this.getDataset().serieToUpdateBefore.put(this.getName(), n);
    }

    public void addxysvalue(IScope iScope, double d, double d2, double d3, int n, HashMap hashMap, int n2) {
        this.svalues.add(d3);
        this.addxyvalue(iScope, d, d2, n, hashMap, n2);
    }

    public void initColor(IScope iScope, HashMap hashMap, int n) {
        Object object;
        if (hashMap.containsKey("color") && (object = this.getlistvalue(iScope, hashMap, "color", n)) != null) {
            if (object instanceof IList) {
                IList iList = Cast.asList(iScope, object);
                if (iList.size() == 1) {
                    this.setMycolor(Cast.asColor(iScope, iList.get(0)));
                }
                if (iList.size() == 2) {
                    this.setMycolor(Cast.asColor(iScope, iList.get(1)));
                    this.setMyMincolor(Cast.asColor(iScope, iList.get(0)));
                }
                if (iList.size() > 2) {
                    this.setMyMincolor(Cast.asColor(iScope, iList.get(0)));
                    this.setMyMedcolor(Cast.asColor(iScope, iList.get(1)));
                    this.setMycolor(Cast.asColor(iScope, iList.get(2)));
                }
            } else {
                GamaColor gamaColor = Cast.asColor(iScope, object);
                this.setMycolor(gamaColor);
            }
        }
    }

    public void addxyvalue(IScope iScope, double d, double d2, int n, HashMap hashMap, int n2) {
        IList iList;
        Object object;
        this.xvalues.add(d);
        this.yvalues.add(d2);
        this.initColor(iScope, hashMap, n2);
        if (hashMap.containsKey("marker_size") && (object = this.getlistvalue(iScope, hashMap, "marker_size", n2)) != null) {
            if (this.svalues.size() > this.xvalues.size()) {
                this.svalues.remove(this.svalues.get(this.svalues.size() - 1));
            }
            this.svalues.add(Cast.asFloat(iScope, object));
        }
        if (this.isUseYErrValues() && (object = this.getlistvalue(iScope, hashMap, "y_err_values", n2)) != null) {
            if (object instanceof IList) {
                iList = Cast.asList(iScope, object);
                if (iList.size() > 1) {
                    this.yerrvaluesmin.add(Cast.asFloat(iScope, iList.get(0)));
                    this.yerrvaluesmax.add(Cast.asFloat(iScope, iList.get(1)));
                } else {
                    this.yerrvaluesmin.add(d2 - Cast.asFloat(iScope, iList.get(0)));
                    this.yerrvaluesmax.add(d2 + Cast.asFloat(iScope, iList.get(0)));
                }
            } else {
                this.yerrvaluesmin.add(d2 - Cast.asFloat(iScope, object));
                this.yerrvaluesmax.add(d2 + Cast.asFloat(iScope, object));
            }
        }
        if (this.isUseXErrValues() && (object = this.getlistvalue(iScope, hashMap, "x_err_values", n2)) != null) {
            if (object instanceof IList) {
                iList = Cast.asList(iScope, object);
                if (iList.size() > 1) {
                    this.xerrvaluesmin.add(Cast.asFloat(iScope, iList.get(0)));
                    this.xerrvaluesmax.add(Cast.asFloat(iScope, iList.get(1)));
                } else {
                    this.xerrvaluesmin.add(d - Cast.asFloat(iScope, iList.get(0)));
                    this.xerrvaluesmax.add(d + Cast.asFloat(iScope, iList.get(0)));
                }
            } else {
                this.xerrvaluesmin.add(d - Cast.asFloat(iScope, object));
                this.xerrvaluesmax.add(d + Cast.asFloat(iScope, object));
            }
        }
        this.getDataset().serieToUpdateBefore.put(this.getName(), n);
    }

    public void addcysvalue(IScope iScope, String string, double d, double d2, int n, HashMap hashMap, int n2) {
        this.svalues.add(d2);
        this.addcyvalue(iScope, string, d, n, hashMap, n2);
    }

    public void addcyvalue(IScope iScope, String string, double d, int n, HashMap hashMap, int n2) {
        IValue iValue;
        Object object;
        this.cvalues.add(string);
        this.yvalues.add(d);
        if (hashMap.containsKey("color") && (object = this.getlistvalue(iScope, hashMap, "color", n2)) != null) {
            if (object instanceof IList) {
                iValue = Cast.asList(iScope, object);
                if (iValue.size() == 1) {
                    this.setMycolor(Cast.asColor(iScope, iValue.get(0)));
                }
                if (iValue.size() == 2) {
                    this.setMycolor(Cast.asColor(iScope, iValue.get(1)));
                    this.setMyMincolor(Cast.asColor(iScope, iValue.get(0)));
                }
                if (iValue.size() > 2) {
                    this.setMyMincolor(Cast.asColor(iScope, iValue.get(0)));
                    this.setMyMedcolor(Cast.asColor(iScope, iValue.get(1)));
                    this.setMycolor(Cast.asColor(iScope, iValue.get(2)));
                }
            } else {
                iValue = Cast.asColor(iScope, object);
                this.setMycolor((GamaColor)iValue);
            }
        }
        if (hashMap.containsKey("marker_size") && (object = this.getlistvalue(iScope, hashMap, "marker_size", n2)) != null) {
            if (this.svalues.size() > this.xvalues.size()) {
                this.svalues.remove(this.svalues.get(this.svalues.size() - 1));
            }
            this.svalues.add(Cast.asFloat(iScope, object));
        }
        if (this.isUseYErrValues() && (object = this.getlistvalue(iScope, hashMap, "y_err_values", n2)) != null) {
            if (object instanceof IList) {
                iValue = Cast.asList(iScope, object);
                if (iValue.size() > 1) {
                    this.yerrvaluesmin.add(Cast.asFloat(iScope, iValue.get(0)));
                    this.yerrvaluesmax.add(Cast.asFloat(iScope, iValue.get(1)));
                } else {
                    this.yerrvaluesmin.add(d - Cast.asFloat(iScope, iValue.get(0)));
                    this.yerrvaluesmax.add(d + Cast.asFloat(iScope, iValue.get(0)));
                }
            } else {
                this.yerrvaluesmin.add(d - Cast.asFloat(iScope, object));
                this.yerrvaluesmax.add(d + Cast.asFloat(iScope, object));
            }
        }
        this.getDataset().serieToUpdateBefore.put(this.getName(), n);
    }

    public void endupdate(IScope iScope) {
        this.ongoing_update = false;
    }

    public void startupdate(IScope iScope) {
        this.ongoing_update = true;
    }

    private void savelistd(IScope iScope, ChartHistory chartHistory, ArrayList<Double> arrayList) {
        if (arrayList.size() == 0) {
            chartHistory.append(",");
            return;
        }
        for (Double d : arrayList) {
            chartHistory.append(Cast.asFloat(iScope, d).floatValue() + ",");
        }
    }

    private void savelists(IScope iScope, ChartHistory chartHistory, ArrayList arrayList) {
        if (arrayList.size() == 0) {
            return;
        }
        for (Object e : arrayList) {
            chartHistory.append(Cast.asString(iScope, e) + ",");
        }
    }

    public void savehistory(IScope iScope, ChartHistory chartHistory) {
        chartHistory.append(this.getName() + ",");
        if (this.mysource.isByCategory()) {
            if (this.cvalues.size() > 0) {
                if (this.getMysource().isCumulative()) {
                    chartHistory.append(this.cvalues.get(this.cvalues.size() - 1) + ",");
                } else {
                    this.savelists(iScope, chartHistory, this.cvalues);
                }
            }
        } else if (this.xvalues.size() > 0) {
            if (this.getMysource().isCumulative()) {
                chartHistory.append(String.valueOf(this.xvalues.get(this.xvalues.size() - 1)) + ",");
            } else {
                this.savelistd(iScope, chartHistory, this.xvalues);
            }
        }
        if (this.yvalues.size() > 0) {
            if (this.getMysource().isCumulative()) {
                chartHistory.append(String.valueOf(this.yvalues.get(this.yvalues.size() - 1)) + ",");
            } else {
                this.savelistd(iScope, chartHistory, this.yvalues);
            }
        }
        if (this.svalues.size() > 0 && this.svalues.size() >= this.yvalues.size()) {
            if (this.getMysource().isCumulative()) {
                chartHistory.append(String.valueOf(this.svalues.get(this.svalues.size() - 1)) + ",");
            } else {
                this.savelistd(iScope, chartHistory, this.svalues);
            }
        }
    }

    public IExpression getLineThickness() {
        return this.getMysource().getLineThickness();
    }
}

