/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import com.google.common.collect.Sets;
import gama.core.common.util.PoolUtils;
import gama.core.common.util.RandomUtils;
import gama.core.util.GamaListFactory;
import gama.core.util.ICollector;
import gama.core.util.IList;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class Collector<E, C extends Collection<E>>
implements ICollector<E>,
Collection<E> {
    private static final PoolUtils.ObjectPool<ICollector<?>> LISTS = PoolUtils.create("Ordered Collectors", true, AsList::new, (iCollector, iCollector2) -> iCollector2.set((ICollector<?>)iCollector), Collection::clear);
    private static final PoolUtils.ObjectPool<ICollector<?>> SETS = PoolUtils.create("Unique Collectors", true, AsSet::new, (iCollector, iCollector2) -> iCollector2.set((ICollector<?>)iCollector), Collection::clear);
    private static final PoolUtils.ObjectPool<ICollector<?>> ORDERED_SETS = PoolUtils.create("Unique Ordered Collectors", true, AsOrderedSet::new, (iCollector, iCollector2) -> iCollector2.set((ICollector<?>)iCollector), Collection::clear);
    C collect;

    public static final <T> AsList<T> getList() {
        return (AsList)LISTS.get();
    }

    public static final <T> AsSet<T> getSet() {
        return (AsSet)SETS.get();
    }

    public static final <T> AsOrderedSet<T> getOrderedSet() {
        return (AsOrderedSet)ORDERED_SETS.get();
    }

    public static final <T> void release(ICollector<T> iCollector) {
        if (iCollector instanceof AsList) {
            LISTS.release(iCollector);
        } else if (iCollector instanceof AsOrderedSet) {
            ORDERED_SETS.release(iCollector);
        } else if (iCollector instanceof AsSet) {
            SETS.release(iCollector);
        }
    }

    @Override
    public void set(ICollector<?> iCollector) {
        this.addAll(iCollector.items());
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        if (this.collect != null) {
            return this.collect.removeIf(predicate);
        }
        return ICollector.super.removeIf(predicate);
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.collect != null) {
            return this.collect.spliterator();
        }
        return ICollector.super.spliterator();
    }

    @Override
    public Stream<E> stream() {
        if (this.collect != null) {
            return this.collect.stream();
        }
        return ICollector.super.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        if (this.collect != null) {
            return this.collect.parallelStream();
        }
        return ICollector.super.parallelStream();
    }

    @Override
    public int size() {
        if (this.collect == null) {
            return 0;
        }
        return this.collect.size();
    }

    @Override
    public boolean contains(Object object) {
        if (this.collect == null) {
            return false;
        }
        return this.collect.contains(object);
    }

    @Override
    public Object[] toArray() {
        if (this.collect == null) {
            return new Object[0];
        }
        return this.collect.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (this.collect == null) {
            return TArray;
        }
        return this.collect.toArray(TArray);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (this.collect == null) {
            return false;
        }
        return this.collect.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.initCollect();
        return this.collect.addAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.collect == null) {
            return false;
        }
        return this.collect.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (this.collect == null) {
            return false;
        }
        return this.collect.retainAll(collection);
    }

    @Override
    public boolean add(E e) {
        this.initCollect();
        return this.collect.add(e);
    }

    protected abstract void initCollect();

    public abstract C items();

    @Override
    public Iterator<E> iterator() {
        return this.items().iterator();
    }

    @Override
    public boolean remove(Object object) {
        if (this.collect == null) {
            return false;
        }
        return this.collect.remove(object);
    }

    @Override
    public boolean isEmpty() {
        return this.collect == null || this.collect.isEmpty();
    }

    @Override
    public void clear() {
        this.collect = null;
    }

    public static class AsList<E>
    extends Collector<E, IList<E>> {
        protected AsList() {
        }

        @Override
        protected void initCollect() {
            if (this.collect == null) {
                this.collect = GamaListFactory.create();
            }
        }

        @Override
        public IList<E> items() {
            return this.collect == null ? GamaListFactory.EMPTY_LIST : (IList)this.collect;
        }

        public void setSize(int n) {
            if (n > 0 && this.collect == null) {
                this.collect = GamaListFactory.create(Types.NO_TYPE, n);
            }
        }

        @Override
        public void shuffleInPlaceWith(RandomUtils randomUtils) {
            randomUtils.shuffleInPlace((List)this.items());
        }
    }

    public static class AsOrderedSet<E>
    extends AsSet<E> {
        protected AsOrderedSet() {
        }

        @Override
        protected void initCollect() {
            if (this.collect == null) {
                this.collect = new LinkedHashSet();
            }
        }
    }

    public static class AsSet<E>
    extends Collector<E, Set<E>> {
        protected AsSet() {
        }

        @Override
        protected void initCollect() {
            if (this.collect == null) {
                this.collect = new HashSet();
            }
        }

        @Override
        public Set<E> items() {
            return this.collect == null ? Collections.EMPTY_SET : (Set)this.collect;
        }

        public static class Concurrent<E>
        extends AsSet<E> {
            @Override
            protected void initCollect() {
                if (this.collect == null) {
                    this.collect = Sets.newConcurrentHashSet();
                }
            }

            @Override
            public boolean remove(Object object) {
                if (object == null) {
                    return false;
                }
                return super.remove(object);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                if (collection == null) {
                    return false;
                }
                return super.removeAll(collection);
            }
        }
    }
}

