/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation;

import com.google.common.collect.ImmutableSet;
import gama.gaml.compilation.IValidator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.Types;
import org.eclipse.emf.ecore.EObject;

public interface IDescriptionValidator<T extends IDescription>
extends IValidator {
    public static final ImmutableSet<String> RESERVED = ImmutableSet.copyOf((Object[])new String[]{"false", "true", "nil", "myself"});

    public void validate(T var1);

    @Override
    default public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
        this.validate(iDescription);
        return true;
    }

    default public void swap(IDescription iDescription, String string, String string2) {
        if (iDescription.hasFacet(string)) {
            iDescription.setFacetExprDescription(string2, iDescription.getFacet(string));
            iDescription.removeFacets(string);
        }
    }

    public static class Assert {
        public static void typesAreCompatibleForAssignment(String string, IDescription iDescription, String string2, IType<?> iType, IExpressionDescription iExpressionDescription) {
            if (iExpressionDescription == null) {
                return;
            }
            IExpression iExpression = iExpressionDescription.getExpression();
            if (iExpression == null) {
                return;
            }
            IType<?> iType2 = iExpression.getGamlType();
            Assert.verifyIntFloatAndEmptyContainers(string, iDescription, string2, iType, iExpressionDescription, iExpression, iType2);
            if (iType.isContainer() && iType2.isContainer()) {
                IType<?> iType3 = iType.getContentType();
                IType<?> iType4 = iType2.getContentType();
                if (Types.isEmptyContainerCase(iType, iExpression) || Assert.speciesAreIncompatible(iDescription, iType, iExpressionDescription, iExpression, iType3, iType4)) {
                    return;
                }
                if (iType.id() == 10 && iType2.id() == 5 && iType4.id() == 9) {
                    iType4 = iType4.getContentType();
                }
                if (!iType4.isTranslatableInto(iType3)) {
                    Assert.emitCastingWarning(string, iDescription, string2, iType, iExpressionDescription, iType3, iType4);
                }
            }
        }

        private static void verifyIntFloatAndEmptyContainers(String string, IDescription iDescription, String string2, IType<?> iType, IExpressionDescription iExpressionDescription, IExpression iExpression, IType iType2) {
            if ((iExpression != IExpressionFactory.NIL_EXPR && !iType2.getGamlType().isTranslatableInto(iType.getGamlType()) || Types.intFloatCase(iType, iType2)) && !Types.isEmptyContainerCase(iType, iExpression)) {
                EObject eObject = iExpressionDescription.getTarget();
                String string3 = string2 + " of type " + String.valueOf(iType.getGamlType()) + " is assigned a value of type " + String.valueOf(iType2.getGamlType()) + ", which will be casted to " + String.valueOf(iType.getGamlType());
                if (eObject == null) {
                    iDescription.warning(string3, "gaml.casting.issue", string, iType.toString());
                } else {
                    iDescription.warning(string3, "gaml.casting.issue", eObject, iType.toString());
                }
            }
        }

        private static void emitCastingWarning(String string, IDescription iDescription, String string2, IType<?> iType, IExpressionDescription iExpressionDescription, IType iType2, IType<?> iType3) {
            EObject eObject = iExpressionDescription.getTarget();
            if (eObject == null) {
                iDescription.warning("Elements of " + string2 + " are of type " + String.valueOf(iType2) + " but are assigned elements of type " + String.valueOf(iType3) + ", which will be casted to " + String.valueOf(iType2), "gaml.casting.issue", string, iType.toString());
            } else {
                iDescription.warning("Elements of " + string2 + " are of type " + String.valueOf(iType2) + " but are assigned elements of type " + String.valueOf(iType3) + ", which will be casted to " + String.valueOf(iType2), "gaml.casting.issue", eObject, iType.toString());
            }
        }

        private static boolean speciesAreIncompatible(IDescription iDescription, IType<?> iType, IExpressionDescription iExpressionDescription, IExpression iExpression, IType iType2, IType<?> iType3) {
            if (iExpression != IExpressionFactory.NIL_EXPR && iType.getGamlType().id() == 14 && !iType3.isTranslatableInto(iType2)) {
                iDescription.error("Impossible assignment: " + iType3.getSpeciesName() + " is not a sub-species of " + iType2.getSpeciesName(), "gaml.wrong.type.issue", iExpressionDescription.getTarget(), new String[0]);
                return true;
            }
            return false;
        }

        public static boolean nameIsValid(IDescription iDescription) {
            ITypesManager iTypesManager;
            String string = iDescription.getName();
            if (string == null) {
                iDescription.error("The attribute 'name' is missing", "gaml.missing.name.issue");
                return false;
            }
            if (RESERVED.contains((Object)string)) {
                String string2 = "It cannot be used as a " + (iDescription instanceof VariableDescription ? "variable" : iDescription.getKeyword()) + " name.";
                iDescription.error(string + " is a reserved keyword. " + string2 + " Reserved keywords are: " + String.valueOf(RESERVED), "gaml.is.reserved.issue", "name", string);
                return false;
            }
            ModelDescription modelDescription = iDescription.getModelDescription();
            ITypesManager iTypesManager2 = iTypesManager = modelDescription == null ? Types.builtInTypes : modelDescription.getTypesManager();
            if (!iTypesManager.containsType(string)) {
                return true;
            }
            String string3 = "It cannot be used as a " + (iDescription instanceof VariableDescription ? "variable" : iDescription.getKeyword()) + " name.";
            String string4 = iTypesManager.get(string).isAgentType() ? "species" : "type";
            iDescription.error(string + " is a " + string4 + " name. " + string3, "gaml.is.a.type.issue", "name", string);
            return false;
        }
    }

    public static class NullValidator
    implements IDescriptionValidator {
        public void validate(IDescription iDescription) {
        }
    }

    public static class ValidNameValidator
    implements IDescriptionValidator {
        public void validate(IDescription iDescription) {
            Assert.nameIsValid(iDescription);
        }
    }
}

