/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.GamaFile;
import gama.core.util.file.GamaGisFile;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class SpatialProjections {
    private static final String THE_CODE = "The code ";

    @GamlAnnotations.operator(value={"crs"}, category={"Spatial operators", "Files-related operators"}, concept={"geometry", "spatial_computation", "file", "gis"})
    @GamlAnnotations.doc(value="the Coordinate Reference System (CRS) of the GIS file", examples={@GamlAnnotations.example(value="crs(my_shapefile)", equals="the crs of the shapefile", isExecutable=false)}, see={})
    public static String crsFromFile(IScope iScope, GamaFile gamaFile) {
        if (!(gamaFile instanceof GamaGisFile)) {
            throw GamaRuntimeException.error("Impossible to compute the CRS for this type of file", iScope);
        }
        CoordinateReferenceSystem coordinateReferenceSystem = ((GamaGisFile)gamaFile).getGis(iScope).getInitialCRS(iScope);
        if (coordinateReferenceSystem == null) {
            return null;
        }
        try {
            return CRS.lookupIdentifier((IdentifiedObject)coordinateReferenceSystem, (boolean)true);
        }
        catch (NullPointerException | FactoryException throwable) {
            return null;
        }
    }

    @GamlAnnotations.operator(value={"CRS_transform"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "gis"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="returns the geometry corresponding to the transformation of the given geometry by the current CRS (Coordinate Reference System), the one corresponding to the world's agent one", examples={@GamlAnnotations.example(value="CRS_transform(shape)", equals="a geometry corresponding to the agent geometry transformed into the current CRS", test=false)})})
    public static IShape transform_CRS(IScope iScope, IShape iShape) {
        IProjection iProjection = iScope.getSimulation().getProjectionFactory().getWorld();
        if (iProjection == null) {
            return iShape.copy(iScope);
        }
        GamaShape gamaShape = GamaShapeFactory.createFrom(iProjection.inverseTransform(iShape.getInnerGeometry()));
        if (iShape instanceof GamaPoint) {
            return gamaShape.getLocation();
        }
        return gamaShape;
    }

    @GamlAnnotations.operator(value={"to_GAMA_CRS"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "gis"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="returns the geometry corresponding to the transformation of the given geometry to the GAMA CRS (Coordinate Reference System) assuming the given geometry is referenced by the current CRS, the one corresponding to the world's agent one", examples={@GamlAnnotations.example(value="to_GAMA_CRS({121,14})", equals="a geometry corresponding to the agent geometry transformed into the GAMA CRS", test=false)})})
    public static IShape to_GAMA_CRS(IScope iScope, IShape iShape) {
        IProjection iProjection = iScope.getSimulation().getProjectionFactory().getWorld();
        if (iProjection == null) {
            return iShape.copy(iScope);
        }
        GamaShape gamaShape = GamaShapeFactory.createFrom(iProjection.transform(iShape.getInnerGeometry()));
        if (iShape instanceof GamaPoint) {
            return gamaShape.getLocation();
        }
        return gamaShape;
    }

    @GamlAnnotations.operator(value={"to_GAMA_CRS"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="returns the geometry corresponding to the transformation of the given geometry to the GAMA CRS (Coordinate Reference System) assuming the given geometry is referenced by given CRS", examples={@GamlAnnotations.example(value="to_GAMA_CRS({121,14}, \"EPSG:4326\")", equals="a geometry corresponding to the agent geometry transformed into the GAMA CRS", test=false)})})
    public static IShape to_GAMA_CRS(IScope iScope, IShape iShape, String string) {
        IProjection iProjection;
        try {
            iProjection = iScope.getSimulation().getProjectionFactory().forSavingWith(iScope, string);
        }
        catch (FactoryException factoryException) {
            throw GamaRuntimeException.error(THE_CODE + string + " does not correspond to a known EPSG code", iScope);
        }
        if (iProjection == null) {
            return iShape.copy(iScope);
        }
        GamaShape gamaShape = GamaShapeFactory.createFrom(iProjection.transform(iShape.getInnerGeometry()));
        if (iShape instanceof GamaPoint) {
            return gamaShape.getLocation();
        }
        return gamaShape;
    }

    @GamlAnnotations.operator(value={"CRS_transform"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "gis"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="returns the geometry corresponding to the transformation of the given geometry by the left operand CRS (Coordinate Reference System)", examples={@GamlAnnotations.example(value="shape CRS_transform(\"EPSG:4326\")", equals="a geometry corresponding to the agent geometry transformed into the EPSG:4326 CRS", test=false)})})
    public static IShape transform_CRS(IScope iScope, IShape iShape, String string) {
        IProjection iProjection;
        try {
            iProjection = iScope.getSimulation().getProjectionFactory().forSavingWith(iScope, string);
        }
        catch (FactoryException factoryException) {
            throw GamaRuntimeException.error(THE_CODE + string + " does not correspond to a known EPSG code", iScope);
        }
        if (iProjection == null) {
            return iShape.copy(iScope);
        }
        GamaShape gamaShape = GamaShapeFactory.createFrom(iProjection.inverseTransform(iShape.getInnerGeometry()));
        if (iShape instanceof GamaPoint) {
            return gamaShape.getLocation();
        }
        return gamaShape;
    }

    @GamlAnnotations.operator(value={"CRS_transform"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "gis"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="returns the geometry corresponding to the transformation of the given geometry from the first CRS to the second CRS (Coordinate Reference System)", examples={@GamlAnnotations.example(value="{8.35,47.22} CRS_transform(\"EPSG:4326\",\"EPSG:4326\")", equals="{929517.7481238344,5978057.894895313,0.0}", test=false)})})
    public static IShape transform_CRS(IScope iScope, IShape iShape, String string, String string2) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (iShape == null) {
            return iShape;
        }
        try {
            coordinateReferenceSystem2 = CRS.decode((String)string);
        }
        catch (FactoryException factoryException) {
            throw GamaRuntimeException.error(THE_CODE + string + " does not correspond to a known EPSG code", iScope);
        }
        try {
            coordinateReferenceSystem = CRS.decode((String)string2);
        }
        catch (FactoryException factoryException) {
            throw GamaRuntimeException.error(THE_CODE + string2 + " does not correspond to a known EPSG code", iScope);
        }
        Geometry geometry = null;
        try {
            MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)coordinateReferenceSystem2, (CoordinateReferenceSystem)coordinateReferenceSystem);
            geometry = JTS.transform((Geometry)iShape.getInnerGeometry(), (MathTransform)mathTransform);
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("No transformation found from " + string + " to " + string2, iScope);
        }
        if (geometry == null) {
            return null;
        }
        GamaShape gamaShape = GamaShapeFactory.createFrom(geometry);
        if (iShape instanceof GamaPoint) {
            return gamaShape.getLocation();
        }
        return gamaShape;
    }
}

