/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kml;

import gama.dependencies.kml.AbstractObject;
import gama.dependencies.kml.AbstractView;
import gama.dependencies.kml.Container;
import gama.dependencies.kml.ExtendedData;
import gama.dependencies.kml.Feature;
import gama.dependencies.kml.Folder;
import gama.dependencies.kml.GroundOverlay;
import gama.dependencies.kml.Metadata;
import gama.dependencies.kml.NetworkLink;
import gama.dependencies.kml.PhotoOverlay;
import gama.dependencies.kml.Placemark;
import gama.dependencies.kml.Region;
import gama.dependencies.kml.Schema;
import gama.dependencies.kml.ScreenOverlay;
import gama.dependencies.kml.Snippet;
import gama.dependencies.kml.StyleSelector;
import gama.dependencies.kml.TimePrimitive;
import gama.dependencies.kml.annotations.Obvious;
import gama.dependencies.kml.atom.Author;
import gama.dependencies.kml.atom.Link;
import gama.dependencies.kml.gx.Tour;
import gama.dependencies.kml.xal.AddressDetails;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentType", propOrder={"schema", "feature", "documentSimpleExtension", "documentObjectExtension"})
@XmlRootElement(name="Document", namespace="http://www.opengis.net/kml/2.2")
public class Document
extends Container
implements Cloneable {
    @XmlElement(name="Schema")
    protected List<Schema> schema;
    @XmlElementRef(name="AbstractFeatureGroup", namespace="http://www.opengis.net/kml/2.2", required=false)
    protected List<Feature> feature;
    @XmlElement(name="DocumentSimpleExtensionGroup")
    @XmlSchemaType(name="anySimpleType")
    protected List<Object> documentSimpleExtension;
    @XmlElement(name="DocumentObjectExtensionGroup")
    protected List<AbstractObject> documentObjectExtension;

    public List<Schema> getSchema() {
        if (this.schema == null) {
            this.schema = new ArrayList<Schema>();
        }
        return this.schema;
    }

    public List<Feature> getFeature() {
        if (this.feature == null) {
            this.feature = new ArrayList<Feature>();
        }
        return this.feature;
    }

    public List<Object> getDocumentSimpleExtension() {
        if (this.documentSimpleExtension == null) {
            this.documentSimpleExtension = new ArrayList<Object>();
        }
        return this.documentSimpleExtension;
    }

    public List<AbstractObject> getDocumentObjectExtension() {
        if (this.documentObjectExtension == null) {
            this.documentObjectExtension = new ArrayList<AbstractObject>();
        }
        return this.documentObjectExtension;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.schema == null ? 0 : this.schema.hashCode());
        n = 31 * n + (this.feature == null ? 0 : this.feature.hashCode());
        n = 31 * n + (this.documentSimpleExtension == null ? 0 : this.documentSimpleExtension.hashCode());
        n = 31 * n + (this.documentObjectExtension == null ? 0 : this.documentObjectExtension.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof Document)) {
            return false;
        }
        Document document = (Document)object;
        if (this.schema == null ? document.schema != null : !this.schema.equals(document.schema)) {
            return false;
        }
        if (this.feature == null ? document.feature != null : !this.feature.equals(document.feature)) {
            return false;
        }
        if (this.documentSimpleExtension == null ? document.documentSimpleExtension != null : !this.documentSimpleExtension.equals(document.documentSimpleExtension)) {
            return false;
        }
        return !(this.documentObjectExtension == null ? document.documentObjectExtension != null : !this.documentObjectExtension.equals(document.documentObjectExtension));
    }

    public Schema createAndAddSchema() {
        Schema schema = new Schema();
        this.getSchema().add(schema);
        return schema;
    }

    public Tour createAndAddTour() {
        Tour tour = new Tour();
        this.getFeature().add(tour);
        return tour;
    }

    public ScreenOverlay createAndAddScreenOverlay() {
        ScreenOverlay screenOverlay = new ScreenOverlay();
        this.getFeature().add(screenOverlay);
        return screenOverlay;
    }

    public PhotoOverlay createAndAddPhotoOverlay() {
        PhotoOverlay photoOverlay = new PhotoOverlay();
        this.getFeature().add(photoOverlay);
        return photoOverlay;
    }

    public GroundOverlay createAndAddGroundOverlay() {
        GroundOverlay groundOverlay = new GroundOverlay();
        this.getFeature().add(groundOverlay);
        return groundOverlay;
    }

    public NetworkLink createAndAddNetworkLink() {
        NetworkLink networkLink = new NetworkLink();
        this.getFeature().add(networkLink);
        return networkLink;
    }

    public Folder createAndAddFolder() {
        Folder folder = new Folder();
        this.getFeature().add(folder);
        return folder;
    }

    public Document createAndAddDocument() {
        Document document = new Document();
        this.getFeature().add(document);
        return document;
    }

    public Placemark createAndAddPlacemark() {
        Placemark placemark = new Placemark();
        this.getFeature().add(placemark);
        return placemark;
    }

    public void setSchema(List<Schema> list) {
        this.schema = list;
    }

    public Document addToSchema(Schema schema) {
        this.getSchema().add(schema);
        return this;
    }

    public void setFeature(List<Feature> list) {
        this.feature = list;
    }

    public Document addToFeature(Feature feature) {
        this.getFeature().add(feature);
        return this;
    }

    public void setDocumentSimpleExtension(List<Object> list) {
        this.documentSimpleExtension = list;
    }

    public Document addToDocumentSimpleExtension(Object object) {
        this.getDocumentSimpleExtension().add(object);
        return this;
    }

    public void setDocumentObjectExtension(List<AbstractObject> list) {
        this.documentObjectExtension = list;
    }

    public Document addToDocumentObjectExtension(AbstractObject abstractObject) {
        this.getDocumentObjectExtension().add(abstractObject);
        return this;
    }

    @Override
    @Obvious
    public void setObjectSimpleExtension(List<Object> list) {
        super.setObjectSimpleExtension(list);
    }

    @Override
    @Obvious
    public Document addToObjectSimpleExtension(Object object) {
        super.getObjectSimpleExtension().add(object);
        return this;
    }

    @Override
    @Obvious
    public void setStyleSelector(List<StyleSelector> list) {
        super.setStyleSelector(list);
    }

    @Override
    @Obvious
    public Document addToStyleSelector(StyleSelector styleSelector) {
        super.getStyleSelector().add(styleSelector);
        return this;
    }

    @Override
    @Obvious
    public void setFeatureSimpleExtension(List<Object> list) {
        super.setFeatureSimpleExtension(list);
    }

    @Override
    @Obvious
    public Document addToFeatureSimpleExtension(Object object) {
        super.getFeatureSimpleExtension().add(object);
        return this;
    }

    @Override
    @Obvious
    public void setFeatureObjectExtension(List<AbstractObject> list) {
        super.setFeatureObjectExtension(list);
    }

    @Override
    @Obvious
    public Document addToFeatureObjectExtension(AbstractObject abstractObject) {
        super.getFeatureObjectExtension().add(abstractObject);
        return this;
    }

    @Override
    @Obvious
    public void setContainerSimpleExtension(List<Object> list) {
        super.setContainerSimpleExtension(list);
    }

    @Override
    @Obvious
    public Document addToContainerSimpleExtension(Object object) {
        super.getContainerSimpleExtension().add(object);
        return this;
    }

    @Override
    @Obvious
    public void setContainerObjectExtension(List<AbstractObject> list) {
        super.setContainerObjectExtension(list);
    }

    @Override
    @Obvious
    public Document addToContainerObjectExtension(AbstractObject abstractObject) {
        super.getContainerObjectExtension().add(abstractObject);
        return this;
    }

    public Document withSchema(List<Schema> list) {
        this.setSchema(list);
        return this;
    }

    public Document withFeature(List<Feature> list) {
        this.setFeature(list);
        return this;
    }

    public Document withDocumentSimpleExtension(List<Object> list) {
        this.setDocumentSimpleExtension(list);
        return this;
    }

    public Document withDocumentObjectExtension(List<AbstractObject> list) {
        this.setDocumentObjectExtension(list);
        return this;
    }

    @Override
    @Obvious
    public Document withObjectSimpleExtension(List<Object> list) {
        super.withObjectSimpleExtension((List)list);
        return this;
    }

    @Override
    @Obvious
    public Document withId(String string) {
        super.withId(string);
        return this;
    }

    @Override
    @Obvious
    public Document withTargetId(String string) {
        super.withTargetId(string);
        return this;
    }

    @Override
    @Obvious
    public Document withName(String string) {
        super.withName(string);
        return this;
    }

    @Override
    @Obvious
    public Document withVisibility(Boolean bl) {
        super.withVisibility(bl);
        return this;
    }

    @Override
    @Obvious
    public Document withOpen(Boolean bl) {
        super.withOpen(bl);
        return this;
    }

    @Override
    @Obvious
    public Document withAtomAuthor(Author author) {
        super.withAtomAuthor(author);
        return this;
    }

    @Override
    @Obvious
    public Document withAtomLink(Link link) {
        super.withAtomLink(link);
        return this;
    }

    @Override
    @Obvious
    public Document withAddress(String string) {
        super.withAddress(string);
        return this;
    }

    @Override
    @Obvious
    public Document withXalAddressDetails(AddressDetails addressDetails) {
        super.withXalAddressDetails(addressDetails);
        return this;
    }

    @Override
    @Obvious
    public Document withPhoneNumber(String string) {
        super.withPhoneNumber(string);
        return this;
    }

    @Override
    @Obvious
    public Document withSnippet(Snippet snippet) {
        super.withSnippet(snippet);
        return this;
    }

    @Override
    @Obvious
    public Document withSnippetd(String string) {
        super.withSnippetd(string);
        return this;
    }

    @Override
    @Obvious
    public Document withDescription(String string) {
        super.withDescription(string);
        return this;
    }

    @Override
    @Obvious
    public Document withAbstractView(AbstractView abstractView) {
        super.withAbstractView(abstractView);
        return this;
    }

    @Override
    @Obvious
    public Document withTimePrimitive(TimePrimitive timePrimitive) {
        super.withTimePrimitive(timePrimitive);
        return this;
    }

    @Override
    @Obvious
    public Document withStyleUrl(String string) {
        super.withStyleUrl(string);
        return this;
    }

    @Override
    @Obvious
    public Document withStyleSelector(List<StyleSelector> list) {
        super.withStyleSelector((List)list);
        return this;
    }

    @Override
    @Obvious
    public Document withRegion(Region region) {
        super.withRegion(region);
        return this;
    }

    @Override
    @Obvious
    public Document withMetadata(Metadata metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    @Obvious
    public Document withExtendedData(ExtendedData extendedData) {
        super.withExtendedData(extendedData);
        return this;
    }

    @Override
    @Obvious
    public Document withFeatureSimpleExtension(List<Object> list) {
        super.withFeatureSimpleExtension((List)list);
        return this;
    }

    @Override
    @Obvious
    public Document withFeatureObjectExtension(List<AbstractObject> list) {
        super.withFeatureObjectExtension((List)list);
        return this;
    }

    @Override
    @Obvious
    public Document withContainerSimpleExtension(List<Object> list) {
        super.withContainerSimpleExtension(list);
        return this;
    }

    @Override
    @Obvious
    public Document withContainerObjectExtension(List<AbstractObject> list) {
        super.withContainerObjectExtension(list);
        return this;
    }

    @Override
    public Document clone() {
        Document document = (Document)super.clone();
        document.schema = new ArrayList<Schema>(this.getSchema().size());
        for (Schema object : this.schema) {
            document.schema.add(object.clone());
        }
        document.feature = new ArrayList<Feature>(this.getFeature().size());
        for (Feature feature : this.feature) {
            document.feature.add(feature.clone());
        }
        document.documentSimpleExtension = new ArrayList<Object>(this.getDocumentSimpleExtension().size());
        for (Object object : this.documentSimpleExtension) {
            document.documentSimpleExtension.add(object);
        }
        document.documentObjectExtension = new ArrayList<AbstractObject>(this.getDocumentObjectExtension().size());
        for (AbstractObject abstractObject : this.documentObjectExtension) {
            document.documentObjectExtension.add(abstractObject.clone());
        }
        return document;
    }
}

