/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BlockInputStream;
import gama.dependencies.osmosis.OsmosisBinaryParser;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.RunnableSource;
import gama.dependencies.osmosis.Sink;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;

public class OsmosisReader
implements RunnableSource {
    private Sink sink;
    final InputStream input;
    final OsmosisBinaryParser parser;

    public OsmosisReader(InputStream inputStream) {
        if (inputStream == null) {
            throw new Error("Null input");
        }
        this.input = inputStream;
        this.parser = new OsmosisBinaryParser();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
        this.parser.setSink(sink);
    }

    @Override
    public void run() {
        try {
            try {
                this.sink.initialize(Collections.emptyMap());
                new BlockInputStream(this.input, this.parser).process();
            }
            catch (IOException iOException) {
                throw new OsmosisRuntimeException("Unable to process PBF stream", iOException);
            }
        }
        finally {
            this.sink.complete();
        }
    }
}

